/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc.metadata;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCLeftJoinMetaData;
import org.jboss.metadata.MetaData;
import org.w3c.dom.Element;

public class JDBCReadAheadMetaData {
    public static final JDBCReadAheadMetaData DEFAULT = new JDBCReadAheadMetaData();
    private static final byte NONE = 0;
    private static final byte ON_LOAD = 1;
    private static final byte ON_FIND = 2;
    private static final List STRATEGIES = Arrays.asList("none", "on-load", "on-find");
    private final byte strategy;
    private final int pageSize;
    private final String eagerLoadGroup;
    private final List leftJoinList;

    private JDBCReadAheadMetaData() {
        this.strategy = 1;
        this.pageSize = 255;
        this.eagerLoadGroup = "*";
        this.leftJoinList = Collections.EMPTY_LIST;
    }

    public JDBCReadAheadMetaData(String strategy, int pageSize, String eagerLoadGroup) {
        this(strategy, pageSize, eagerLoadGroup, Collections.EMPTY_LIST);
    }

    public JDBCReadAheadMetaData(String strategy, int pageSize, String eagerLoadGroup, List leftJoins) {
        this.strategy = (byte)STRATEGIES.indexOf(strategy);
        if (this.strategy < 0) {
            throw new IllegalArgumentException("Unknown read ahead strategy '" + strategy + "'.");
        }
        this.pageSize = pageSize;
        this.eagerLoadGroup = eagerLoadGroup;
        this.leftJoinList = leftJoins;
    }

    public JDBCReadAheadMetaData(Element element, JDBCReadAheadMetaData defaultValue) throws DeploymentException {
        Element eagerLoadGroupElement;
        String strategyStr = MetaData.getUniqueChildContent(element, "strategy");
        this.strategy = (byte)STRATEGIES.indexOf(strategyStr);
        if (this.strategy < 0) {
            throw new DeploymentException("Unknown read ahead strategy '" + strategyStr + "'.");
        }
        String pageSizeStr = MetaData.getOptionalChildContent(element, "page-size");
        if (pageSizeStr != null) {
            try {
                this.pageSize = Integer.parseInt(pageSizeStr);
            }
            catch (NumberFormatException ex) {
                throw new DeploymentException("Invalid number format in read-ahead page-size '" + pageSizeStr + "': " + ex);
            }
            if (this.pageSize < 0) {
                throw new DeploymentException("Negative value for read ahead page-size '" + pageSizeStr + "'.");
            }
        } else {
            this.pageSize = defaultValue.getPageSize();
        }
        this.eagerLoadGroup = (eagerLoadGroupElement = MetaData.getOptionalChild(element, "eager-load-group")) != null ? MetaData.getElementContent(eagerLoadGroupElement) : defaultValue.getEagerLoadGroup();
        Iterator iter = MetaData.getChildrenByTagName(element, "left-join");
        this.leftJoinList = JDBCLeftJoinMetaData.readLeftJoinList(iter);
    }

    public boolean isNone() {
        return this.strategy == 0;
    }

    public boolean isOnLoad() {
        return this.strategy == 1;
    }

    public boolean isOnFind() {
        return this.strategy == 2;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public String getEagerLoadGroup() {
        return this.eagerLoadGroup;
    }

    public Iterator getLeftJoins() {
        return this.leftJoinList.iterator();
    }

    public String toString() {
        return "[JDBCReadAheadMetaData : strategy=" + STRATEGIES.get(this.strategy) + ", pageSize=" + this.pageSize + ", eagerLoadGroup=" + this.eagerLoadGroup + ", left-join" + this.leftJoinList + "]";
    }
}

