/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import org.jboss.ejb.StatefulSessionEnterpriseContext;
import org.jboss.ejb.plugins.HandleWrapper;
import org.jboss.ejb.plugins.SecurityActions;
import org.jboss.ejb.plugins.StatefulSessionBeanField;

public class SessionObjectInputStream
extends ObjectInputStream {
    private StatefulSessionEnterpriseContext ctx;
    private ClassLoader appCl;

    public SessionObjectInputStream(StatefulSessionEnterpriseContext ctx, InputStream in) throws IOException {
        super(in);
        EnableResolveObjectAction.enableResolveObject(this);
        this.ctx = ctx;
        this.appCl = SecurityActions.getContextClassLoader();
    }

    protected Object resolveObject(Object obj) throws IOException {
        Object resolved = obj;
        if (obj instanceof Handle) {
            resolved = ((Handle)obj).getEJBObject();
        } else if (obj instanceof HomeHandle) {
            resolved = ((HomeHandle)obj).getEJBHome();
        } else if (obj instanceof HandleWrapper) {
            HandleWrapper wrapper = (HandleWrapper)obj;
            try {
                resolved = wrapper.get();
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Failed to find class: " + e.getMessage());
            }
        } else if (obj instanceof StatefulSessionBeanField) {
            byte type = ((StatefulSessionBeanField)obj).type;
            if (type == 0) {
                resolved = this.ctx.getSessionContext();
            } else if (type == 1) {
                resolved = this.ctx.getSessionContext().getUserTransaction();
            }
        }
        return resolved;
    }

    protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
        try {
            return this.appCl.loadClass(v.getName());
        }
        catch (ClassNotFoundException e) {
            return super.resolveClass(v);
        }
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        Class<?> clazz = null;
        Class[] ifaceClasses = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            ifaceClasses[i] = Class.forName(interfaces[i], false, this.appCl);
        }
        try {
            clazz = Proxy.getProxyClass(this.appCl, ifaceClasses);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException("Failed to resolve proxy class", e);
        }
        return clazz;
    }

    private static class EnableResolveObjectAction
    implements PrivilegedAction {
        SessionObjectInputStream is;

        EnableResolveObjectAction(SessionObjectInputStream is) {
            this.is = is;
        }

        public Object run() {
            this.is.enableResolveObject(true);
            return null;
        }

        static void enableResolveObject(SessionObjectInputStream is) {
            EnableResolveObjectAction action = new EnableResolveObjectAction(is);
            AccessController.doPrivileged(action);
        }
    }
}

