/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SecurityContext;
import org.jboss.security.SubjectInfo;
import org.jboss.security.plugins.SecurityContextAssociation;
import org.jboss.security.plugins.SecurityContextFactory;

class SecurityActions {
    SecurityActions() {
    }

    static ClassLoader getContextClassLoader() {
        return TCLAction.UTIL.getContextClassLoader();
    }

    static void setContextClassLoader(ClassLoader loader) {
        TCLAction.UTIL.setContextClassLoader(loader);
    }

    static void pushSubjectContext(Principal principal, Object credential, Subject subject) {
        if (System.getSecurityManager() == null) {
            PrincipalInfoAction.NON_PRIVILEGED.push(principal, credential, subject);
        } else {
            PrincipalInfoAction.PRIVILEGED.push(principal, credential, subject);
        }
    }

    static void dupSubjectContext() {
        if (System.getSecurityManager() == null) {
            PrincipalInfoAction.NON_PRIVILEGED.dup();
        } else {
            PrincipalInfoAction.PRIVILEGED.dup();
        }
    }

    static void popSubjectContext() {
        if (System.getSecurityManager() == null) {
            PrincipalInfoAction.NON_PRIVILEGED.pop();
        } else {
            PrincipalInfoAction.PRIVILEGED.pop();
        }
    }

    static RunAsIdentity peekRunAsIdentity() {
        if (System.getSecurityManager() == null) {
            return RunAsIdentityActions.NON_PRIVILEGED.peek();
        }
        return RunAsIdentityActions.PRIVILEGED.peek();
    }

    static void pushRunAsIdentity(RunAsIdentity principal) {
        if (System.getSecurityManager() == null) {
            RunAsIdentityActions.NON_PRIVILEGED.push(principal);
        } else {
            RunAsIdentityActions.PRIVILEGED.push(principal);
        }
    }

    static RunAsIdentity popRunAsIdentity() {
        if (System.getSecurityManager() == null) {
            return RunAsIdentityActions.NON_PRIVILEGED.pop();
        }
        return RunAsIdentityActions.PRIVILEGED.pop();
    }

    static Exception getContextException() {
        if (System.getSecurityManager() == null) {
            return ContextInfoActions.NON_PRIVILEGED.getContextException();
        }
        return ContextInfoActions.PRIVILEGED.getContextException();
    }

    static Subject getContextSubject() throws PolicyContextException {
        if (System.getSecurityManager() == null) {
            return PolicyContextActions.NON_PRIVILEGED.getContextSubject();
        }
        return PolicyContextActions.PRIVILEGED.getContextSubject();
    }

    static void createAndSetSecurityContext(final Principal p, final Object cred, final String domain) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SecurityContext sc = SecurityContextFactory.createSecurityContext(p, cred, null, domain);
                SecurityContextAssociation.setSecurityContext(sc);
                return null;
            }
        });
    }

    static void createAndSetSecurityContext(final Principal p, final Object cred, final String domain, final Subject subject) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SecurityContext sc = SecurityContextFactory.createSecurityContext(domain);
                SubjectInfo si = SecurityContextFactory.createSubjectInfo(p, cred, subject);
                sc.setSubjectInfo(si);
                SecurityContextAssociation.setSecurityContext(sc);
                return null;
            }
        });
    }

    static void clearSecurityContext(String securityDomain) {
        ClearSecurityContextAction action = new ClearSecurityContextAction(securityDomain);
        AccessController.doPrivileged(action);
    }

    static SecurityContext getSecurityContext() {
        return (SecurityContext)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return SecurityContextAssociation.getSecurityContext();
            }
        });
    }

    static SecurityContext getSecurityContext(String securityDomain) {
        GetSecurityContextAction action = new GetSecurityContextAction(securityDomain);
        return (SecurityContext)AccessController.doPrivileged(action);
    }

    static void setSecurityContext(SecurityContext sc, String securityDomain) {
        SetSecurityContextAction action = new SetSecurityContextAction(sc, securityDomain);
        AccessController.doPrivileged(action);
    }

    private static class ClearSecurityContextAction
    implements PrivilegedAction {
        private String securityDomain;

        ClearSecurityContextAction(String sd) {
            this.securityDomain = sd;
        }

        public Object run() {
            String sc = "SecurityContext";
            HashMap map = (HashMap)SecurityAssociation.getContextInfo(sc);
            if (map == null) {
                map = new HashMap();
                SecurityAssociation.setContextInfo(sc, map);
            }
            if (map.containsKey(this.securityDomain)) {
                map.remove(this.securityDomain);
            }
            SecurityAssociation.setContextInfo(sc, map);
            return null;
        }
    }

    private static class SetSecurityContextAction
    implements PrivilegedAction {
        private SecurityContext securityContext;
        private String securityDomain;

        SetSecurityContextAction(SecurityContext sc, String sd) {
            this.securityContext = sc;
            this.securityDomain = sd;
        }

        public Object run() {
            String sc = "SecurityContext";
            HashMap<String, SecurityContext> map = (HashMap<String, SecurityContext>)SecurityAssociation.getContextInfo(sc);
            if (map == null) {
                map = new HashMap<String, SecurityContext>();
                SecurityAssociation.setContextInfo(sc, map);
            }
            map.put(this.securityDomain, this.securityContext);
            SecurityAssociation.setContextInfo(sc, map);
            SecurityContextAssociation.setSecurityContext(this.securityContext);
            return null;
        }
    }

    private static class GetSecurityContextAction
    implements PrivilegedAction {
        private String securityDomain;

        GetSecurityContextAction(String sd) {
            this.securityDomain = sd;
        }

        public Object run() {
            String sc = "SecurityContext";
            HashMap map = (HashMap)SecurityAssociation.getContextInfo(sc);
            if (map == null) {
                map = new HashMap();
                SecurityAssociation.setContextInfo(sc, map);
            }
            SecurityAssociation.setContextInfo(sc, map);
            return SecurityContextAssociation.getSecurityContext();
        }
    }

    static interface TCLAction {
        public static final TCLAction NON_PRIVILEGED = new TCLAction(){

            public ClassLoader getContextClassLoader() {
                return Thread.currentThread().getContextClassLoader();
            }

            public ClassLoader getContextClassLoader(Thread thread) {
                return thread.getContextClassLoader();
            }

            public void setContextClassLoader(ClassLoader cl) {
                Thread.currentThread().setContextClassLoader(cl);
            }

            public void setContextClassLoader(Thread thread, ClassLoader cl) {
                thread.setContextClassLoader(cl);
            }
        };
        public static final TCLAction PRIVILEGED = new TCLAction(){
            private final PrivilegedAction getTCLPrivilegedAction = new PrivilegedAction(){

                public Object run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            };

            public ClassLoader getContextClassLoader() {
                return (ClassLoader)AccessController.doPrivileged(this.getTCLPrivilegedAction);
            }

            public ClassLoader getContextClassLoader(final Thread thread) {
                return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return thread.getContextClassLoader();
                    }
                });
            }

            public void setContextClassLoader(final ClassLoader cl) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(cl);
                        return null;
                    }
                });
            }

            public void setContextClassLoader(final Thread thread, final ClassLoader cl) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        thread.setContextClassLoader(cl);
                        return null;
                    }
                });
            }
        };

        public ClassLoader getContextClassLoader();

        public ClassLoader getContextClassLoader(Thread var1);

        public void setContextClassLoader(ClassLoader var1);

        public void setContextClassLoader(Thread var1, ClassLoader var2);

        public static class UTIL {
            static TCLAction getTCLAction() {
                return System.getSecurityManager() == null ? NON_PRIVILEGED : PRIVILEGED;
            }

            static ClassLoader getContextClassLoader() {
                return UTIL.getTCLAction().getContextClassLoader();
            }

            static ClassLoader getContextClassLoader(Thread thread) {
                return UTIL.getTCLAction().getContextClassLoader(thread);
            }

            static void setContextClassLoader(ClassLoader cl) {
                UTIL.getTCLAction().setContextClassLoader(cl);
            }

            static void setContextClassLoader(Thread thread, ClassLoader cl) {
                UTIL.getTCLAction().setContextClassLoader(thread, cl);
            }
        }
    }

    static interface PolicyContextActions {
        public static final String SUBJECT_CONTEXT_KEY = "javax.security.auth.Subject.container";
        public static final PolicyContextActions PRIVILEGED = new PolicyContextActions(){
            private final PrivilegedExceptionAction exAction = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return (Subject)PolicyContext.getContext(PolicyContextActions.SUBJECT_CONTEXT_KEY);
                }
            };

            public Subject getContextSubject() throws PolicyContextException {
                try {
                    return (Subject)AccessController.doPrivileged(this.exAction);
                }
                catch (PrivilegedActionException e) {
                    Exception ex = e.getException();
                    if (ex instanceof PolicyContextException) {
                        throw (PolicyContextException)ex;
                    }
                    throw new UndeclaredThrowableException(ex);
                }
            }
        };
        public static final PolicyContextActions NON_PRIVILEGED = new PolicyContextActions(){

            public Subject getContextSubject() throws PolicyContextException {
                return (Subject)PolicyContext.getContext(PolicyContextActions.SUBJECT_CONTEXT_KEY);
            }
        };

        public Subject getContextSubject() throws PolicyContextException;
    }

    static interface ContextInfoActions {
        public static final String EX_KEY = "org.jboss.security.exception";
        public static final ContextInfoActions PRIVILEGED = new ContextInfoActions(){
            private final PrivilegedAction exAction = new PrivilegedAction(){

                public Object run() {
                    return SecurityAssociation.getContextInfo(ContextInfoActions.EX_KEY);
                }
            };

            public Exception getContextException() {
                return (Exception)AccessController.doPrivileged(this.exAction);
            }
        };
        public static final ContextInfoActions NON_PRIVILEGED = new ContextInfoActions(){

            public Exception getContextException() {
                return (Exception)SecurityAssociation.getContextInfo(ContextInfoActions.EX_KEY);
            }
        };

        public Exception getContextException();
    }

    static interface RunAsIdentityActions {
        public static final RunAsIdentityActions PRIVILEGED = new RunAsIdentityActions(){
            private final PrivilegedAction peekAction = new PrivilegedAction(){

                public Object run() {
                    return SecurityAssociation.peekRunAsIdentity();
                }
            };
            private final PrivilegedAction popAction = new PrivilegedAction(){

                public Object run() {
                    SecurityContext sc = SecurityContextAssociation.getSecurityContext();
                    return sc.getUtil().remove(sc, "RunAsIdentity");
                }
            };

            public RunAsIdentity peek() {
                return (RunAsIdentity)AccessController.doPrivileged(this.peekAction);
            }

            public void push(final RunAsIdentity id) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        SecurityAssociation.pushRunAsIdentity(id);
                        return null;
                    }
                });
            }

            public RunAsIdentity pop() {
                return (RunAsIdentity)AccessController.doPrivileged(this.popAction);
            }
        };
        public static final RunAsIdentityActions NON_PRIVILEGED = new RunAsIdentityActions(){

            public RunAsIdentity peek() {
                return SecurityAssociation.peekRunAsIdentity();
            }

            public void push(RunAsIdentity id) {
                SecurityContext sc = SecurityContextAssociation.getSecurityContext();
                if (sc == null) {
                    throw new IllegalStateException("Security Context is null to push runas");
                }
                sc.getUtil().set(sc, "RunAsIdentity", id);
            }

            public RunAsIdentity pop() {
                SecurityContext sc = SecurityContextAssociation.getSecurityContext();
                return (RunAsIdentity)sc.getUtil().remove(sc, "RunAsIdentity");
            }
        };

        public RunAsIdentity peek();

        public void push(RunAsIdentity var1);

        public RunAsIdentity pop();
    }

    static interface PrincipalInfoAction {
        public static final PrincipalInfoAction PRIVILEGED = new PrincipalInfoAction(){

            public void push(final Principal principal, final Object credential, final Subject subject) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        SecurityAssociation.pushSubjectContext(subject, principal, credential);
                        return null;
                    }
                });
            }

            public void dup() {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        SecurityAssociation.dupSubjectContext();
                        return null;
                    }
                });
            }

            public void pop() {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        SecurityAssociation.popSubjectContext();
                        return null;
                    }
                });
            }
        };
        public static final PrincipalInfoAction NON_PRIVILEGED = new PrincipalInfoAction(){

            public void push(Principal principal, Object credential, Subject subject) {
                SecurityAssociation.pushSubjectContext(subject, principal, credential);
            }

            public void dup() {
                SecurityAssociation.dupSubjectContext();
            }

            public void pop() {
                SecurityAssociation.popSubjectContext();
            }
        };

        public void push(Principal var1, Object var2, Subject var3);

        public void dup();

        public void pop();
    }
}

