/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb;

import java.security.Permission;
import java.util.Iterator;
import java.util.Set;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContextException;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.MethodMetaData;
import org.jboss.metadata.SecurityRoleRefMetaData;
import org.jboss.metadata.SessionMetaData;

public class EJBPermissionMapping {
    public static void createPermissions(BeanMetaData bean, PolicyConfiguration pc) throws PolicyContextException {
        SessionMetaData smd;
        Permission p;
        String[] params;
        MethodMetaData mmd;
        Iterator iter = bean.getPermissionMethods();
        while (iter.hasNext()) {
            String methodName;
            mmd = (MethodMetaData)iter.next();
            params = null;
            if (mmd.isParamGiven()) {
                params = mmd.getMethodParams();
            }
            if ((methodName = mmd.getMethodName()) != null && methodName.equals("*")) {
                methodName = null;
            }
            EJBMethodPermission p2 = new EJBMethodPermission(mmd.getEjbName(), methodName, mmd.getInterfaceType(), params);
            if (mmd.isUnchecked()) {
                pc.addToUncheckedPolicy(p2);
                continue;
            }
            Set roles = mmd.getRoles();
            for (String role : roles) {
                pc.addToRole(role, p2);
            }
        }
        iter = bean.getExcludedMethods();
        while (iter.hasNext()) {
            mmd = (MethodMetaData)iter.next();
            params = null;
            if (mmd.isParamGiven()) {
                params = mmd.getMethodParams();
            }
            EJBMethodPermission p3 = new EJBMethodPermission(mmd.getEjbName(), mmd.getMethodName(), mmd.getInterfaceType(), params);
            pc.addToExcludedPolicy(p3);
        }
        iter = bean.getSecurityRoleReferences();
        while (iter.hasNext()) {
            SecurityRoleRefMetaData srrmd = (SecurityRoleRefMetaData)iter.next();
            p = new EJBRoleRefPermission(bean.getEjbName(), srrmd.getName());
            pc.addToRole(srrmd.getLink(), p);
        }
        if (bean instanceof SessionMetaData && (smd = (SessionMetaData)bean).isStateful()) {
            p = new EJBMethodPermission(bean.getEjbName(), "getEJBObject", "Home", null);
            pc.addToUncheckedPolicy(p);
        }
    }
}

