/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.deployers.plugins.structure.ContextInfoImpl;
import org.jboss.deployers.plugins.structure.vfs.AbstractStructureDeployer;
import org.jboss.deployers.spi.structure.vfs.ContextInfo;
import org.jboss.deployers.spi.structure.vfs.StructureMetaData;
import org.jboss.deployers.spi.structure.vfs.StructuredDeployers;
import org.jboss.deployment.J2eeApplicationMetaData;
import org.jboss.deployment.J2eeModuleMetaData;
import org.jboss.metadata.XmlFileLoader;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;
import org.jboss.virtual.plugins.vfs.helpers.SuffixMatchFilter;
import org.w3c.dom.Element;

public class EARStructure
extends AbstractStructureDeployer {
    public static final VirtualFileFilter DEFAULT_EAR_LIB_FILTER = new SuffixMatchFilter(".jar");
    private VirtualFileFilter earLibFilter = DEFAULT_EAR_LIB_FILTER;

    public EARStructure() {
        this.setRelativeOrder(1000);
    }

    public VirtualFileFilter getEarLibFilter() {
        return this.earLibFilter;
    }

    public void setEarLibFilter(VirtualFileFilter earLibFilter) {
        if (earLibFilter == null) {
            throw new IllegalArgumentException("Null filter");
        }
        this.earLibFilter = earLibFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean determineStructure(VirtualFile root, StructureMetaData metaData, StructuredDeployers deployers) {
        boolean valid;
        try {
            String libDir;
            XmlFileLoader xfl;
            InputStream in;
            if (root.isLeaf() || !root.getName().endsWith(".ear")) {
                return false;
            }
            ContextInfoImpl context = new ContextInfoImpl(root.getPathName());
            context.setMetaDataPath("META-INF");
            VirtualFile applicationXml = this.getMetaDataFile(root, "META-INF/application.xml");
            VirtualFile jbossAppXml = this.getMetaDataFile(root, "META-INF/jboss-app.xml");
            J2eeApplicationMetaData j2eeMetaData = new J2eeApplicationMetaData();
            boolean scan = true;
            if (applicationXml != null) {
                in = applicationXml.openStream();
                try {
                    xfl = new XmlFileLoader(false);
                    Element application = xfl.getDocument(in, "META-INF/application.xml").getDocumentElement();
                    j2eeMetaData.importXml(application);
                }
                finally {
                    in.close();
                }
                scan = false;
            }
            if (jbossAppXml != null) {
                in = jbossAppXml.openStream();
                try {
                    xfl = new XmlFileLoader(false);
                    Element jbossApp = xfl.getDocument(in, "META-INF/jboss-app.xml").getDocumentElement();
                    j2eeMetaData.importXml(jbossApp);
                }
                finally {
                    in.close();
                }
            }
            metaData.addContext((ContextInfo)context);
            String string = libDir = j2eeMetaData.getLibraryDirectory() == null ? "lib" : j2eeMetaData.getLibraryDirectory();
            if (j2eeMetaData.getLibraryDirectory() != null) {
                try {
                    VirtualFile lib = root.findChild(libDir);
                    if (lib != null) {
                        List<VirtualFile> archives = lib.getChildren(this.earLibFilter);
                        for (VirtualFile archive : archives) {
                            super.addClassPath(root, archive, true, true, (ContextInfo)context);
                            if (archive.findChild("META-INF/persistence.xml") == null) continue;
                            this.log.trace(archive.getName() + " in ear lib directory has persistence units");
                            if (deployers.determineStructure(archive, metaData)) continue;
                            throw new RuntimeException(archive.getName() + " in lib directory has persistence.xml but is not a recognized deployment, .ear: " + root.getName());
                        }
                    }
                }
                catch (IOException ignored) {
                    // empty catch block
                }
            }
            super.addClassPath(root, root, false, true, (ContextInfo)context);
            if (scan) {
                this.scanEar(root, j2eeMetaData);
            }
            Iterator<J2eeModuleMetaData> iter = j2eeMetaData.getModules();
            while (iter.hasNext()) {
                J2eeModuleMetaData mod = iter.next();
                String fileName = mod.getFileName();
                if (fileName == null || (fileName = fileName.trim()).length() <= 0) continue;
                try {
                    VirtualFile module = root.findChild(fileName);
                    if (module == null) {
                        throw new RuntimeException(fileName + " module listed in application.xml does not exist within .ear " + root.getName());
                    }
                    if (deployers.determineStructure(module, metaData)) continue;
                    throw new RuntimeException(fileName + " module listed in application.xml is not a recognized deployment, .ear: " + root.getName());
                }
                catch (IOException ignored) {
                    throw new RuntimeException(fileName + " module listed in application.xml does not exist within .ear " + root.getName(), ignored);
                }
            }
            valid = true;
        }
        catch (Exception e) {
            throw new RuntimeException("Error determining structure: " + root.getName(), e);
        }
        return valid;
    }

    private void scanEar(VirtualFile root, J2eeApplicationMetaData j2eeMetaData) throws IOException {
        List<VirtualFile> archives = root.getChildren();
        if (archives != null) {
            String earPath = root.getPathName();
            for (VirtualFile vfArchive : archives) {
                String filename = this.earRelativePath(earPath, vfArchive.getPathName());
                J2eeModuleMetaData moduleMetaData = j2eeMetaData.getModule(filename);
                int type = this.typeFromSuffix(filename, vfArchive);
                if (type < 0 || moduleMetaData != null) continue;
                moduleMetaData = new J2eeModuleMetaData(type, filename);
                j2eeMetaData.addModule(moduleMetaData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int typeFromSuffix(String path, VirtualFile archive) throws IOException {
        int type = -1;
        if (path.endsWith(".war")) {
            type = 1;
        } else if (path.endsWith(".rar")) {
            type = 3;
        } else if (path.endsWith(".har")) {
            type = 5;
        } else if (path.endsWith(".sar")) {
            type = 4;
        } else if (path.endsWith(".jar")) {
            VirtualFile mfFile = this.getMetaDataFile(archive, "META-INF/MANIFEST.MF");
            VirtualFile clientXml = this.getMetaDataFile(archive, "META-INF/application-client.xml");
            VirtualFile ejbXml = this.getMetaDataFile(archive, "META-INF/ejb-jar.xml");
            VirtualFile jbossXml = this.getMetaDataFile(archive, "META-INF/jboss.xml");
            if (clientXml != null) {
                type = 2;
            } else if (mfFile != null) {
                Manifest mf;
                InputStream is = mfFile.openStream();
                try {
                    mf = new Manifest(is);
                }
                finally {
                    is.close();
                }
                Attributes attrs = mf.getMainAttributes();
                type = attrs.containsKey(Attributes.Name.MAIN_CLASS) ? 2 : 0;
            } else {
                type = ejbXml != null || jbossXml != null ? 0 : 0;
            }
        }
        return type;
    }

    private String earRelativePath(String earPath, String pathName) {
        StringBuilder tmp = new StringBuilder(pathName);
        tmp.delete(0, earPath.length());
        return tmp.toString();
    }

    private VirtualFile getMetaDataFile(VirtualFile file, String path) {
        VirtualFile metaFile = null;
        try {
            metaFile = file.findChild(path);
        }
        catch (IOException e) {
            // empty catch block
        }
        return metaFile;
    }
}

