/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.NamingException;
import org.jboss.deployers.plugins.deployer.AbstractSimpleDeployer;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.classloader.ClassLoaderFactory;
import org.jboss.deployers.spi.deployer.DeploymentUnit;
import org.jboss.deployers.spi.deployment.MainDeployer;
import org.jboss.deployers.spi.structure.DeploymentContext;
import org.jboss.ejb.EjbUtil50;
import org.jboss.metadata.ClientMetaData;
import org.jboss.metadata.EjbRefMetaData;
import org.jboss.metadata.EnvEntryMetaData;
import org.jboss.metadata.ResourceEnvRefMetaData;
import org.jboss.metadata.ResourceRefMetaData;
import org.jboss.metadata.XmlFileLoader;
import org.jboss.metadata.serviceref.ServiceRefDelegate;
import org.jboss.metadata.serviceref.VirtualFileAdaptor;
import org.jboss.naming.Util;
import org.jboss.util.xml.DOMUtils;
import org.jboss.virtual.VirtualFile;
import org.jboss.ws.integration.ServiceRefMetaData;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

public class ClientDeployer
extends AbstractSimpleDeployer {
    private static final String APPLICATION_CLIENT_XML = "application-client.xml";
    private static final String JBOSS_CLIENT_XML = "jboss-client.xml";
    private MainDeployer mainDeployer;

    public MainDeployer getMainDeployer() {
        return this.mainDeployer;
    }

    public void setMainDeployer(MainDeployer mainDeployer) {
        this.mainDeployer = mainDeployer;
    }

    private boolean accepts(DeploymentUnit unit) throws DeploymentException {
        Element root;
        boolean accepts = false;
        VirtualFile dd = unit.getMetaDataFile(APPLICATION_CLIENT_XML);
        if (dd != null) {
            this.log.debug("Found application-client.xml file: " + unit.getName());
            try {
                root = DOMUtils.parse(dd.openStream());
                String namespaceURI = root.getNamespaceURI();
                boolean bl = accepts = !"http://java.sun.com/xml/ns/javaee".equals(namespaceURI);
                if (!accepts) {
                    this.log.debug("Ignore application-client.xml with namespace: " + namespaceURI);
                }
            }
            catch (IOException ex) {
                DeploymentException.rethrowAsDeploymentException((String)"Cannot parse application-client.xml", (Throwable)ex);
            }
        }
        if (!accepts && (dd = unit.getMetaDataFile(JBOSS_CLIENT_XML)) != null) {
            this.log.debug("Found jboss-client.xml file: " + unit.getName());
            try {
                root = DOMUtils.parse(dd.openStream());
                DocumentType doctype = root.getOwnerDocument().getDoctype();
                String publicId = doctype != null ? doctype.getPublicId() : null;
                accepts = "-//JBoss//DTD Application Client 4.0//EN".equals(publicId);
                if (!accepts) {
                    this.log.debug("Ignore jboss-client.xml with publicId: " + publicId);
                }
            }
            catch (IOException ex) {
                DeploymentException.rethrowAsDeploymentException((String)"Cannot parse jboss-client.xml", (Throwable)ex);
            }
        }
        return accepts;
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        boolean isComponent = unit.getDeploymentContext().isComponent();
        if (!isComponent && this.accepts(unit)) {
            unit.createClassLoader((ClassLoaderFactory)new RootURLClassLoaderFactory(unit));
            ClientMetaData metaData = this.buildClientMetaData(unit);
            unit.addAttachment(ClientMetaData.class, (Object)metaData);
            try {
                this.setupEnvironment(unit, metaData);
            }
            catch (Exception ex) {
                DeploymentException.rethrowAsDeploymentException((String)"Failed to setup client ENC", (Throwable)ex);
            }
        }
    }

    public void undeploy(DeploymentUnit unit) {
        boolean isComponent = unit.getDeploymentContext().isComponent();
        ClientMetaData metaData = (ClientMetaData)unit.getAttachment(ClientMetaData.class);
        if (!isComponent && metaData != null) {
            String appClientName = metaData.getJndiName();
            this.log.info("Removing client ENC from: " + appClientName);
            try {
                InitialContext iniCtx = new InitialContext();
                Util.unbind((Context)iniCtx, appClientName);
            }
            catch (NamingException ex) {
                this.log.error("Failed to remove client ENC", ex);
            }
        }
    }

    private ClientMetaData buildClientMetaData(DeploymentUnit unit) throws DeploymentException {
        ClientMetaData metaData = null;
        try {
            VirtualFile appClientVF = unit.getMetaDataFile(APPLICATION_CLIENT_XML);
            if (appClientVF == null) {
                throw new DeploymentException("No application-client.xml found");
            }
            InputStream in = appClientVF.openStream();
            XmlFileLoader xfl = new XmlFileLoader(true);
            Element appClient = xfl.getDocument(in, APPLICATION_CLIENT_XML).getDocumentElement();
            in.close();
            metaData = new ClientMetaData();
            metaData.importClientXml(appClient);
            VirtualFile jbossClientVF = unit.getMetaDataFile(JBOSS_CLIENT_XML);
            if (jbossClientVF != null && (in = jbossClientVF.openStream()) != null) {
                xfl = new XmlFileLoader(true);
                Element jbossClient = xfl.getDocument(in, JBOSS_CLIENT_XML).getDocumentElement();
                in.close();
                metaData.importJbossClientXml(jbossClient);
            }
        }
        catch (IOException e) {
            throw new DeploymentException("Failed to parse metadata", (Throwable)e);
        }
        return metaData;
    }

    private void setupEnvironment(DeploymentUnit unit, ClientMetaData metaData) throws Exception {
        String refName;
        String appClientName = metaData.getJndiName();
        InitialContext iniCtx = new InitialContext();
        Context envCtx = Util.createSubcontext((Context)iniCtx, appClientName);
        this.log.debug("Creating client ENC binding under: " + appClientName);
        for (EnvEntryMetaData entry : metaData.getEnvironmentEntries()) {
            this.log.debug("Binding env-entry: " + entry.getName() + " of type: " + entry.getType() + " to value:" + entry.getValue());
            EnvEntryMetaData.bindEnvEntry(envCtx, entry);
        }
        HashMap ejbRefs = metaData.getEjbReferences();
        for (EjbRefMetaData ref : ejbRefs.values()) {
            this.log.debug("Binding an EJBReference " + ref.getName());
            if (ref.getLink() != null) {
                String linkName = ref.getLink();
                String jndiName = EjbUtil50.findEjbLink(this.mainDeployer, unit, linkName);
                this.log.debug("Binding " + ref.getName() + " to ejb-link: " + linkName + " -> " + jndiName);
                if (jndiName == null) {
                    String msg = "Failed to resolve ejb-link: " + linkName + " make by ejb-name: " + ref.getName();
                    throw new DeploymentException(msg);
                }
                this.log.debug("Link resolved to:" + jndiName);
                Util.bind(envCtx, ref.getName(), (Object)new LinkRef(jndiName));
                continue;
            }
            if (ref.getJndiName() == null) {
                throw new DeploymentException("ejb-ref " + ref.getName() + ", expected either ejb-link in ejb-jar.xml " + "or jndi-name in jboss.xml");
            }
            this.log.debug("Binding " + ref.getName() + " to : " + ref.getJndiName());
            Util.bind(envCtx, ref.getName(), (Object)new LinkRef(ref.getJndiName()));
        }
        ClassLoader loader = unit.getClassLoader();
        VirtualFileAdaptor vfsRoot = new VirtualFileAdaptor(unit.getDeploymentContext().getRoot());
        for (ServiceRefMetaData sref : metaData.getServiceRefs().values()) {
            refName = sref.getServiceRefName();
            new ServiceRefDelegate().bindServiceRef(envCtx, refName, vfsRoot, loader, sref);
        }
        HashMap resRefs = metaData.getResourceReferences();
        for (ResourceRefMetaData ref : resRefs.values()) {
            refName = ref.getRefName();
            String jndiName = ref.getJndiName();
            if (ref.getType().equals("java.net.URL")) {
                String resURL = ref.getResURL();
                if (resURL != null) {
                    this.log.debug("Binding '" + refName + "' to URL: " + resURL);
                    URL url = new URL(resURL);
                    Util.bind(envCtx, refName, (Object)url);
                    continue;
                }
                this.log.debug("Linking '" + refName + "' to URL: " + resURL);
                LinkRef urlLink = new LinkRef(jndiName);
                Util.bind(envCtx, refName, (Object)urlLink);
                continue;
            }
            this.log.debug("Binding resource: " + refName + " to JDNI as: " + jndiName);
            Util.bind(envCtx, refName, (Object)new LinkRef(jndiName));
        }
        HashMap envRefs = metaData.getResourceEnvReferences();
        for (ResourceEnvRefMetaData resRef : envRefs.values()) {
            String encName = resRef.getRefName();
            String jndiName = resRef.getJndiName();
            this.log.debug("Binding env resource: " + encName + " to JDNI as: " + jndiName);
            Util.bind(envCtx, encName, (Object)new LinkRef(jndiName));
        }
        this.log.info("Client ENC bound under: " + appClientName);
    }

    static class RootURLClassLoaderFactory
    implements ClassLoaderFactory {
        URL rootURL;

        RootURLClassLoaderFactory(DeploymentUnit unit) {
            try {
                this.rootURL = unit.getDeploymentContext().getRoot().toURL();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public ClassLoader createClassLoader(DeploymentContext context) throws Exception {
            return new URLClassLoader(new URL[]{this.rootURL});
        }

        public void removeClassLoader(DeploymentContext context) throws Exception {
        }
    }
}

