/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.lang.reflect.Method;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import org.jboss.aop.GeneratedClassAdvisor;
import org.jboss.aop.JoinPointInfo;
import org.jboss.aop.MethodByMethodInfo;
import org.jboss.aop.advice.AdviceMethodProperties;
import org.jboss.aop.instrument.CallerTransformer;
import org.jboss.aop.instrument.GeneratedAdvisorInstrumentor;
import org.jboss.aop.instrument.JoinPointGenerator;
import org.jboss.aop.instrument.MethodExecutionTransformer;
import org.jboss.aop.instrument.OptimizedBehaviourInvocations;
import org.jboss.aop.instrument.OptimizedMethodInvocations;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.aop.joinpoint.MethodCalledByMethodInvocation;
import org.jboss.aop.util.ReflectToJavassist;

public class MethodByMethodJoinPointGenerator
extends JoinPointGenerator {
    public static final String GENERATOR_PREFIX = "generator_MByM_";
    public static final String JOINPOINT_CLASS_PREFIX = "JoinPoint_MByM_";
    public static final String JOINPOINT_FIELD_PREFIX = "joinpoint_MByM_";
    private static final Class INVOCATION_TYPE = MethodCalledByMethodInvocation.class;
    private static final CtClass INVOCATION_CT_TYPE;

    public MethodByMethodJoinPointGenerator(GeneratedClassAdvisor advisor, JoinPointInfo info) {
        super(advisor, info, MethodByMethodJoinPointGenerator.getParameters((MethodByMethodInfo)info), ((MethodByMethodInfo)info).getMethod().getParameterTypes().length);
    }

    private static JoinPointGenerator.JoinPointParameters getParameters(MethodByMethodInfo info) {
        if (Modifier.isStatic((int)info.getCallingMethod().getModifiers())) {
            if (Modifier.isStatic((int)info.getMethod().getModifiers())) {
                return JoinPointGenerator.JoinPointParameters.ONLY_ARGS;
            }
            return JoinPointGenerator.JoinPointParameters.TARGET_ARGS;
        }
        if (Modifier.isStatic((int)info.getMethod().getModifiers())) {
            return JoinPointGenerator.JoinPointParameters.CALLER_ARGS;
        }
        return JoinPointGenerator.JoinPointParameters.TARGET_CALLER_ARGS;
    }

    protected void initialiseJoinPointNames() {
        this.joinpointClassName = MethodByMethodJoinPointGenerator.getInfoClassName(this.callingMethodHash(), this.calledClass(), this.calledMethodHash());
        this.joinpointFieldName = MethodByMethodJoinPointGenerator.getInfoFieldName(this.callingMethodHash(), this.calledClass(), this.calledMethodHash());
    }

    private long callingMethodHash() {
        return ((MethodByMethodInfo)this.info).getCallingMethodHash();
    }

    private String calledClass() {
        return ((MethodByMethodInfo)this.info).getCalledClass().getName();
    }

    private long calledMethodHash() {
        return ((MethodByMethodInfo)this.info).getCalledMethodHash();
    }

    protected boolean isVoid() {
        return ((MethodByMethodInfo)this.info).getMethod().getReturnType().equals(Void.TYPE);
    }

    protected Class getReturnType() {
        if (this.isVoid()) {
            return null;
        }
        return ((MethodByMethodInfo)this.info).getMethod().getReturnType();
    }

    protected AdviceMethodProperties getAdviceMethodProperties(JoinPointGenerator.AdviceSetup setup) {
        Method method = ((MethodByMethodInfo)this.info).getMethod();
        return new AdviceMethodProperties(setup.getAspectClass(), setup.getAdviceName(), this.info.getClass(), INVOCATION_TYPE, method.getReturnType(), method.getParameterTypes(), method.getExceptionTypes(), method.getDeclaringClass(), this.hasTargetObject(), ((MethodByMethodInfo)this.info).getCallingClass(), this.hasCallingObject());
    }

    protected boolean isCaller() {
        return true;
    }

    protected boolean hasCallingObject() {
        return !java.lang.reflect.Modifier.isStatic(((MethodByMethodInfo)this.info).getCallingMethod().getModifiers());
    }

    protected boolean hasTargetObject() {
        return !java.lang.reflect.Modifier.isStatic(((MethodByMethodInfo)this.info).getMethod().getModifiers());
    }

    protected static CtClass createJoinpointBaseClass(GeneratedAdvisorInstrumentor instrumentor, long callingHash, boolean hasCallingObject, CtClass callingClass, CtMethod targetMethod, String classname, long calledHash, String ciname) throws NotFoundException, CannotCompileException {
        instrumentor.addJoinPointGeneratorFieldToGenAdvisor(MethodByMethodJoinPointGenerator.getJoinPointGeneratorFieldName(callingHash, classname, calledHash));
        BaseClassGenerator generator = new BaseClassGenerator(instrumentor, callingClass, callingHash, hasCallingObject, classname, targetMethod, calledHash, ciname);
        return generator.generate();
    }

    protected String getJoinPointGeneratorFieldName() {
        return MethodByMethodJoinPointGenerator.getJoinPointGeneratorFieldName(this.callingMethodHash(), this.calledClass(), this.calledMethodHash());
    }

    protected static String getInfoClassName(long callingHash, String classname, long calledHash) {
        return JOINPOINT_CLASS_PREFIX + CallerTransformer.getUniqueInvocationFieldname(callingHash, classname, calledHash);
    }

    protected static String getInfoFieldName(long callingHash, String classname, long calledHash) {
        return JOINPOINT_FIELD_PREFIX + CallerTransformer.getUniqueInvocationFieldname(callingHash, classname, calledHash);
    }

    protected static String getJoinPointGeneratorFieldName(long callingHash, String classname, long calledHash) {
        return GENERATOR_PREFIX + CallerTransformer.getUniqueInvocationFieldname(callingHash, classname, calledHash);
    }

    static {
        try {
            INVOCATION_CT_TYPE = ReflectToJavassist.classToJavassist(INVOCATION_TYPE);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static class BaseClassGenerator {
        GeneratedAdvisorInstrumentor instrumentor;
        CtClass callingClass;
        long callingHash;
        boolean hasCallingObject;
        String classname;
        CtClass targetClass;
        CtMethod targetMethod;
        long calledHash;
        String ciname;
        boolean hasTargetObject;
        CtClass jp;
        CtClass[] params;
        CtClass methodInfoClass;

        BaseClassGenerator(GeneratedAdvisorInstrumentor instrumentor, CtClass callingClass, long callingHash, boolean hasCallingObject, String classname, CtMethod targetMethod, long calledHash, String ciname) throws NotFoundException {
            this.instrumentor = instrumentor;
            this.callingClass = callingClass;
            this.callingHash = callingHash;
            this.classname = classname;
            this.hasCallingObject = hasCallingObject;
            this.targetClass = instrumentor.forName(classname);
            this.targetMethod = targetMethod;
            this.calledHash = calledHash;
            this.ciname = ciname;
            this.params = targetMethod.getParameterTypes();
            this.methodInfoClass = instrumentor.forName(CallerTransformer.METHOD_BY_METHOD_INFO_CLASS_NAME);
            this.hasTargetObject = !Modifier.isStatic((int)targetMethod.getModifiers());
        }

        protected CtClass generate() throws CannotCompileException, NotFoundException {
            this.jp = this.setupClass();
            OptimizedBehaviourInvocations.addArgumentFieldsAndAccessors(this.instrumentor.getClassPool(), this.jp, this.params, false);
            if (this.hasTargetObject) {
                this.addTypedTargetField();
            }
            this.addInvokeJoinpointMethod();
            this.addMethodInfoField();
            this.addPublicConstructor();
            this.addProtectedConstructors();
            this.addDispatchMethods();
            TransformerCommon.compileOrLoadClass(this.callingClass, this.jp);
            return this.jp;
        }

        private CtClass setupClass() throws NotFoundException, CannotCompileException {
            String className = MethodByMethodJoinPointGenerator.getInfoClassName(this.callingHash, this.targetClass.getName(), this.calledHash);
            this.jp = TransformerCommon.makeNestedClass(this.callingClass, className, true);
            int mod = this.jp.getModifiers();
            this.jp.setModifiers(mod | 1);
            CtClass invocation = INVOCATION_CT_TYPE;
            this.jp.setSuperclass(invocation);
            JoinPointGenerator.addUntransformableInterface(this.instrumentor, this.jp);
            return this.jp;
        }

        private void addTypedTargetField() throws CannotCompileException {
            CtField targetField = new CtField(this.targetClass, "typedTargetObject", this.jp);
            this.jp.addField(targetField);
            targetField.setModifiers(4);
        }

        private void addPublicConstructor() throws CannotCompileException {
            CtConstructor publicConstructor = CtNewConstructor.make((CtClass[])new CtClass[]{this.methodInfoClass}, (CtClass[])new CtClass[0], (String)"{super($1, null, null, $1.getInterceptors()); this.info = $1;}", (CtClass)this.jp);
            this.jp.addConstructor(publicConstructor);
        }

        protected void addProtectedConstructors() throws CannotCompileException {
            int index;
            int offset = 1;
            if (this.hasTargetObject) {
                ++offset;
            }
            if (this.hasCallingObject) {
                ++offset;
            }
            CtClass[] ctorParams1 = new CtClass[this.params.length + offset];
            CtClass[] ctorParams2 = new CtClass[offset];
            int n = index = 0;
            int n2 = index++;
            CtClass ctClass = this.jp;
            ctorParams2[n2] = ctClass;
            ctorParams1[n] = ctClass;
            if (this.hasTargetObject) {
                int n3 = index;
                int n4 = index++;
                CtClass ctClass2 = this.targetClass;
                ctorParams2[n4] = ctClass2;
                ctorParams1[n3] = ctClass2;
            }
            if (this.hasCallingObject) {
                int n5 = index;
                int n6 = index++;
                CtClass ctClass3 = this.callingClass;
                ctorParams2[n6] = ctClass3;
                ctorParams1[n5] = ctClass3;
            }
            System.arraycopy(this.params, 0, ctorParams1, offset, this.params.length);
            StringBuffer body = new StringBuffer();
            body.append("{");
            body.append("   this($1.info);");
            if (this.hasTargetObject) {
                body.append("   super.targetObject=$2;");
                body.append("   this.").append("typedTargetObject").append("=$2;");
            }
            if (this.hasCallingObject) {
                body.append("   super.callingObject=$" + (this.hasTargetObject ? 3 : 2) + ";");
            }
            StringBuffer setArguments = new StringBuffer();
            for (int i = offset; i < ctorParams1.length; ++i) {
                setArguments.append("   arg" + (i - offset) + " = $" + (i + 1) + ";");
            }
            setArguments.append("}");
            CtConstructor protectedConstructor = CtNewConstructor.make((CtClass[])ctorParams1, (CtClass[])new CtClass[0], (String)(body.toString() + setArguments.toString()), (CtClass)this.jp);
            protectedConstructor.setModifiers(4);
            this.jp.addConstructor(protectedConstructor);
            if (this.params.length > 0) {
                protectedConstructor = CtNewConstructor.make((CtClass[])ctorParams2, (CtClass[])new CtClass[0], (String)(body.toString() + "}"), (CtClass)this.jp);
                protectedConstructor.setModifiers(4);
                this.jp.addConstructor(protectedConstructor);
            }
        }

        private CtClass[] getInvokeJoinpointParameters() {
            if (!this.hasCallingObject && !this.hasTargetObject) {
                return this.params;
            }
            int offset = 0;
            if (this.hasTargetObject) {
                ++offset;
            }
            if (this.hasCallingObject) {
                ++offset;
            }
            CtClass[] invokeParams = new CtClass[this.params.length + offset];
            int index = 0;
            if (this.hasTargetObject) {
                invokeParams[index++] = this.targetClass;
            }
            if (this.hasCallingObject) {
                invokeParams[index++] = this.callingClass;
            }
            System.arraycopy(this.params, 0, invokeParams, offset, this.params.length);
            return invokeParams;
        }

        private CtMethod addInvokeJoinpointMethod() throws CannotCompileException, NotFoundException {
            CtMethod invokeJoinpointMethod = CtNewMethod.make((CtClass)this.targetMethod.getReturnType(), (String)"invokeJoinpoint", (CtClass[])this.getInvokeJoinpointParameters(), (CtClass[])this.targetMethod.getExceptionTypes(), null, (CtClass)this.jp);
            invokeJoinpointMethod.setModifiers(4);
            this.jp.addMethod(invokeJoinpointMethod);
            return invokeJoinpointMethod;
        }

        private void addMethodInfoField() throws CannotCompileException {
            CtField infoField = new CtField(this.methodInfoClass, "info", this.jp);
            infoField.setModifiers(4);
            this.jp.addField(infoField);
        }

        private void addDispatchMethods() throws CannotCompileException, NotFoundException {
            OptimizedMethodInvocations.addDispatch(this.jp, "dispatch", this.targetMethod, !this.hasTargetObject);
            if (this.hasCallingObject || this.hasTargetObject || this.params.length > 0) {
                this.addInvokeJoinPointDispatchMethod();
            }
            this.addInvokeTargetMethod();
        }

        private void addInvokeJoinPointDispatchMethod() throws CannotCompileException, NotFoundException {
            boolean isVoid = this.targetMethod.getReturnType().equals(CtClass.voidType);
            CtClass[] invokeParams = this.getInvokeJoinpointParameters();
            int offset = invokeParams.length - this.params.length;
            StringBuffer parameters = new StringBuffer();
            for (int i = 0; i < this.params.length; ++i) {
                if (i > 0) {
                    parameters.append(", ");
                }
                parameters.append("$" + (i + offset + 1));
            }
            StringBuffer body = new StringBuffer("{");
            if (this.hasTargetObject) {
                body.append(MethodExecutionTransformer.getAopReturnStr(isVoid) + "$1." + this.targetMethod.getName() + "(" + parameters + ");");
            } else {
                body.append(MethodExecutionTransformer.getReturnStr(isVoid) + this.targetClass.getName() + "." + this.targetMethod.getName() + "(" + parameters + ");");
            }
            body.append("}");
            try {
                CtMethod dispatch = CtNewMethod.make((CtClass)(isVoid ? CtClass.voidType : this.targetMethod.getReturnType()), (String)"dispatch", (CtClass[])invokeParams, (CtClass[])this.targetMethod.getExceptionTypes(), (String)body.toString(), (CtClass)this.jp);
                dispatch.setModifiers(4);
                this.jp.addMethod(dispatch);
            }
            catch (CannotCompileException e) {
                throw new RuntimeException("Could not compile code " + body + " for method " + JoinPointGenerator.getMethodString(this.jp, "dispatch", invokeParams), e);
            }
        }

        private void addInvokeTargetMethod() throws CannotCompileException, NotFoundException {
            CtMethod template = INVOCATION_CT_TYPE.getDeclaredMethod("invokeTarget");
            boolean isVoid = this.targetMethod.getReturnType().equals(CtClass.voidType);
            String body = isVoid ? "{dispatch(); return null;}" : "{return ($w)dispatch();}";
            CtMethod invokeTarget = CtNewMethod.make((CtClass)template.getReturnType(), (String)template.getName(), (CtClass[])template.getParameterTypes(), (CtClass[])template.getExceptionTypes(), (String)body, (CtClass)this.jp);
            this.jp.addMethod(invokeTarget);
        }
    }
}

