/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.WeakHashMap;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AdviceMethodProperties;
import org.jboss.aop.advice.annotation.AdviceInfo;
import org.jboss.aop.advice.annotation.AnnotatedParameterAdviceInfo;
import org.jboss.aop.advice.annotation.ParameterAnnotationRule;
import org.jboss.aop.advice.annotation.ParameterAnnotationRuleException;
import org.jboss.aop.util.ReflectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdviceMethodFactory {
    public static final AdviceMethodFactory BEFORE = new AdviceMethodFactory(null, new ParameterAnnotationRule[]{ParameterAnnotationRule.JOIN_POINT}, ReturnType.VOID);
    public static final AdviceMethodFactory AFTER = new AdviceMethodFactory(null, new ParameterAnnotationRule[]{ParameterAnnotationRule.JOIN_POINT, ParameterAnnotationRule.RETURN}, ReturnType.ANY);
    public static final AdviceMethodFactory THROWING = new AdviceMethodFactory(null, new ParameterAnnotationRule[]{ParameterAnnotationRule.JOIN_POINT, ParameterAnnotationRule.THROWABLE}, ReturnType.VOID);
    public static final AdviceMethodFactory AROUND = new AdviceMethodFactory(new AdviceSignatureRule(){

        public boolean applies(Method method) {
            Annotation[][] annotations = method.getParameterAnnotations();
            if (annotations.length != 1) {
                return false;
            }
            for (Annotation annotation : annotations[0]) {
                if (annotation.annotationType().getPackage() != AdviceMethodFactory.class.getPackage()) continue;
                return false;
            }
            if (method.getReturnType() != Object.class) {
                if (AspectManager.verbose) {
                    adviceMatchingMessage.append("\n[warn] - method ");
                    adviceMatchingMessage.append(method);
                    adviceMatchingMessage.append(" does not match default around signature because it returns ");
                    adviceMatchingMessage.append(method.getReturnType());
                    adviceMatchingMessage.append(" intead of java.lang.Object");
                }
                return false;
            }
            for (Class<?> exceptionType : method.getExceptionTypes()) {
                if (exceptionType != Throwable.class) continue;
                return true;
            }
            if (AspectManager.verbose) {
                adviceMatchingMessage.append("\n[warn] - method ");
                adviceMatchingMessage.append(method);
                adviceMatchingMessage.append(" does not match default around signature because it does not throw Throwable");
            }
            return false;
        }

        public AdviceInfo getAdviceInfo(Method method) {
            return new AdviceInfo(method, 2000){

                public boolean validate(AdviceMethodProperties properties, ReturnType adviceReturn) {
                    if (this.parameterTypes[0].isAssignableFrom(properties.getInvocationType())) {
                        return true;
                    }
                    if (AspectManager.verbose) {
                        adviceMatchingMessage.append("\n[warn] - argument 0 of method ");
                        adviceMatchingMessage.append(this.method);
                        adviceMatchingMessage.append(" is not assignable from ");
                        adviceMatchingMessage.append(properties.getInvocationType());
                    }
                    return false;
                }

                public void resetValidation() {
                }

                public short getAssignabilityDegree(int typeIndex, boolean isContextRule, AdviceMethodProperties properties) {
                    return this.getAssignabilityDegree(this.parameterTypes[0], properties.getInvocationType());
                }

                public void assignAdviceInfo(AdviceMethodProperties properties) {
                    properties.setFoundProperties(this.method, new int[]{-2});
                }
            };
        }
    }, new ParameterAnnotationRule[]{ParameterAnnotationRule.INVOCATION}, ReturnType.NOT_VOID);
    static final short NOT_ASSIGNABLE_DEGREE = Short.MAX_VALUE;
    static final short MAX_DEGREE = 32766;
    static final ParameterAnnotationRule[] FULLY_STATIC = new ParameterAnnotationRule[]{ParameterAnnotationRule.ARGS, ParameterAnnotationRule.ARG};
    static final int[][] FS_INCOMPATIBILITY = new int[][]{{0, 1}};
    static final ParameterAnnotationRule[] CALLER_AVAILABLE = new ParameterAnnotationRule[]{ParameterAnnotationRule.CALLER, ParameterAnnotationRule.ARGS, ParameterAnnotationRule.ARG};
    static final int[][] CA_INCOMPATIBILITY = new int[][]{{1, 2}};
    static final ParameterAnnotationRule[] TARGET_AVAILABLE = new ParameterAnnotationRule[]{ParameterAnnotationRule.TARGET, ParameterAnnotationRule.ARGS, ParameterAnnotationRule.ARG};
    static final int[][] TA_INCOMPATIBILITY = CA_INCOMPATIBILITY;
    static final ParameterAnnotationRule[] TARGET_CALLER_AVAILABLE = new ParameterAnnotationRule[]{ParameterAnnotationRule.TARGET, ParameterAnnotationRule.CALLER, ParameterAnnotationRule.ARGS, ParameterAnnotationRule.ARG};
    static final int[][] TCA_INCOMPATIBILITY = new int[][]{{2, 3}};
    static StringBuffer adviceMatchingMessage;
    private HashMap<String, WeakHashMap<ParameterAnnotationRule[], Collection<AdviceInfo>>> adviceInfoCache;
    private ReturnType returnType;
    private AdviceSignatureRule adviceSignatureRule;
    private ParameterAnnotationRule[] rules;

    public static final String getAdviceMatchingMessage() {
        String message = adviceMatchingMessage.toString();
        return message;
    }

    private AdviceMethodFactory(AdviceSignatureRule adviceSignatureRule, ParameterAnnotationRule[] rules, ReturnType returnType) {
        this.adviceSignatureRule = adviceSignatureRule;
        this.rules = rules;
        this.returnType = returnType;
        this.adviceInfoCache = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AdviceMethodProperties findAdviceMethod(AdviceMethodProperties properties) {
        if (AspectManager.verbose) {
            adviceMatchingMessage = new StringBuffer();
        }
        ParameterAnnotationRule[] contextRules = null;
        int[][] mutuallyExclusive = null;
        switch (properties.getOptionalParameters()) {
            case NONE: {
                contextRules = FULLY_STATIC;
                mutuallyExclusive = FS_INCOMPATIBILITY;
                break;
            }
            case TARGET: {
                contextRules = TARGET_AVAILABLE;
                mutuallyExclusive = TA_INCOMPATIBILITY;
                break;
            }
            case CALLER: {
                contextRules = CALLER_AVAILABLE;
                mutuallyExclusive = CA_INCOMPATIBILITY;
                break;
            }
            case TARGET_CALLER: {
                contextRules = TARGET_CALLER_AVAILABLE;
                mutuallyExclusive = TCA_INCOMPATIBILITY;
                break;
            }
            default: {
                throw new RuntimeException("Unexpected Optional Parameters Option" + (Object)((Object)properties.getOptionalParameters()));
            }
        }
        Collection<AdviceInfo> cacheCollection = this.getRankedAdvices(properties, contextRules, mutuallyExclusive);
        if (cacheCollection == null || cacheCollection.isEmpty()) {
            return null;
        }
        Collection<AdviceInfo> collection = cacheCollection;
        synchronized (collection) {
            LinkedList<AdviceInfo> rankedAdvices = new LinkedList<AdviceInfo>(cacheCollection);
            AdviceInfo bestAdvice = this.bestValidAdvice(rankedAdvices, properties, contextRules);
            if (bestAdvice == null) {
                return null;
            }
            bestAdvice.assignAdviceInfo(properties);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<AdviceInfo> getRankedAdvices(AdviceMethodProperties properties, ParameterAnnotationRule[] contextRules, int[][] mutuallyExclusive) {
        WeakHashMap<Object, Collection<AdviceInfo>> map;
        AbstractMap abstractMap = this.adviceInfoCache;
        synchronized (abstractMap) {
            String key = properties.getAspectClass().getName() + properties.getAdviceName();
            map = this.adviceInfoCache.get(key);
            if (map == null) {
                map = new WeakHashMap();
                this.adviceInfoCache.put(key, map);
            }
        }
        abstractMap = map;
        synchronized (abstractMap) {
            if (map.containsKey(contextRules)) {
                Collection<AdviceInfo> advices = map.get(contextRules);
                for (AdviceInfo adviceInfo : advices) {
                    adviceInfo.resetValidation();
                }
                return advices;
            }
            Method[] methods = ReflectUtils.getMethodsWithName(properties.getAspectClass(), properties.getAdviceName());
            ArrayList<AdviceInfo> rankedAdvices = new ArrayList<AdviceInfo>(methods.length);
            map.put(contextRules, rankedAdvices);
            if (methods.length == 0) {
                if (AspectManager.verbose) {
                    adviceMatchingMessage.append("\n[warn] - advice method ");
                    adviceMatchingMessage.append(properties.getAspectClass());
                    adviceMatchingMessage.append(".");
                    adviceMatchingMessage.append(properties.getAdviceName());
                    adviceMatchingMessage.append(" not found");
                }
                return null;
            }
            for (int i = 0; i < methods.length; ++i) {
                if (this.adviceSignatureRule != null && this.adviceSignatureRule.applies(methods[i])) {
                    rankedAdvices.add(this.adviceSignatureRule.getAdviceInfo(methods[i]));
                    continue;
                }
                try {
                    rankedAdvices.add(new AnnotatedParameterAdviceInfo(properties, methods[i], this.rules, contextRules, mutuallyExclusive));
                    continue;
                }
                catch (ParameterAnnotationRuleException pare) {
                    // empty catch block
                }
            }
            Collections.sort(rankedAdvices);
            return rankedAdvices;
        }
    }

    private AdviceInfo bestValidAdvice(LinkedList<AdviceInfo> rankedAdvices, AdviceMethodProperties properties, ParameterAnnotationRule[] contextRules) {
        AdviceInfo advice;
        AdviceInfo bestAdvice = null;
        ListIterator iterator = rankedAdvices.listIterator();
        while (iterator.hasNext()) {
            advice = (AdviceInfo)iterator.next();
            if (advice.validate(properties, this.returnType)) {
                bestAdvice = advice;
                break;
            }
            iterator.remove();
        }
        switch (rankedAdvices.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return bestAdvice;
            }
        }
        while (iterator.hasNext()) {
            advice = (AdviceInfo)iterator.next();
            if (advice.getRank() == bestAdvice.getRank()) {
                if (advice.validate(properties, this.returnType)) continue;
                iterator.remove();
                continue;
            }
            iterator.previous();
            break;
        }
        if (iterator.previous() == bestAdvice) {
            return bestAdvice;
        }
        iterator.next();
        List<AdviceInfo> bestAdvices = rankedAdvices.subList(0, iterator.nextIndex());
        return this.bestMatch(bestAdvices, properties, contextRules);
    }

    AdviceInfo bestMatch(Collection<AdviceInfo> greatestRank, AdviceMethodProperties properties, ParameterAnnotationRule[] contextRules) {
        AdviceInfo bestAdvice = this.selectBestRuleMatch(greatestRank, properties, this.rules.length, false);
        if (bestAdvice != null) {
            return bestAdvice;
        }
        bestAdvice = this.selectBestRuleMatch(greatestRank, properties, contextRules.length, true);
        if (bestAdvice != null) {
            return bestAdvice;
        }
        short bestDegree = Short.MAX_VALUE;
        if (this.returnType == ReturnType.ANY || this.returnType == ReturnType.NOT_VOID) {
            for (AdviceInfo currentAdvice : greatestRank) {
                short currentDegree = currentAdvice.getReturnAssignabilityDegree(properties);
                if (currentDegree >= bestDegree) continue;
                bestAdvice = currentAdvice;
                bestDegree = currentDegree;
            }
            return bestAdvice;
        }
        return greatestRank.iterator().next();
    }

    private AdviceInfo selectBestRuleMatch(Collection<AdviceInfo> greatestRank, AdviceMethodProperties properties, int totalRules, boolean isContextRule) {
        int bestDegree = Short.MAX_VALUE;
        AdviceInfo bestAdvice = null;
        ArrayList<AdviceInfo> removeList = new ArrayList<AdviceInfo>();
        for (int i = 0; i < totalRules; ++i) {
            Iterator<AdviceInfo> iterator = greatestRank.iterator();
            while (iterator.hasNext()) {
                AdviceInfo currentAdvice = iterator.next();
                int currentDegree = currentAdvice.getAssignabilityDegree(i, isContextRule, properties);
                if (currentDegree < bestDegree) {
                    if (bestAdvice != null) {
                        removeList.add(bestAdvice);
                    }
                    bestAdvice = currentAdvice;
                    bestDegree = currentDegree;
                    continue;
                }
                if (currentDegree <= bestDegree) continue;
                iterator.remove();
            }
            if (greatestRank.size() - removeList.size() == 1) {
                return bestAdvice;
            }
            greatestRank.removeAll(removeList);
            removeList.clear();
            bestAdvice = null;
            bestDegree = Short.MAX_VALUE;
        }
        return null;
    }

    static interface AdviceSignatureRule {
        public boolean applies(Method var1);

        public AdviceInfo getAdviceInfo(Method var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ReturnType {
        VOID,
        ANY,
        NOT_VOID;

    }
}

