/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import gnu.trove.TLongObjectHashMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.aop.Advisor;
import org.jboss.aop.advice.AdviceBinding;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.introduction.AnnotationIntroduction;
import org.jboss.aop.microcontainer.lifecycle.LifecycleCallbackBinding;
import org.jboss.aop.microcontainer.lifecycle.LifecycleCallbackDefinition;
import org.jboss.aop.pointcut.AnnotationMatcher;
import org.jboss.aop.pointcut.PointcutMethodMatch;
import org.jboss.aop.proxy.container.InstanceProxyContainer;
import org.jboss.aop.util.Advisable;
import org.jboss.util.MethodHashing;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectiveAspectBinder {
    protected Class clazz;
    protected HashSet aspects = new HashSet();
    protected HashMap methodAdvices = new HashMap();
    protected HashMap constructorAdvices = new HashMap();
    protected HashMap fieldReadAdvices = new HashMap();
    protected HashMap fieldWriteAdvices = new HashMap();
    protected Advisor advisor;
    protected boolean isInstanceContainer;
    TLongObjectHashMap methodMap = new TLongObjectHashMap();
    protected Map<Object, Set<LifecycleCallbackDefinition>> lifecycleCallbacks = new HashMap<Object, Set<LifecycleCallbackDefinition>>();
    boolean initialisedAspects;
    boolean intitialisedLifecycleCallbacks;

    public ReflectiveAspectBinder(Class clazz, Advisor advisor) {
        this.clazz = clazz;
        this.advisor = advisor;
        this.isInstanceContainer = InstanceProxyContainer.class == advisor.getClass();
    }

    public Class getClazz() {
        return this.clazz;
    }

    public HashSet getAspects() {
        if (!this.initialisedAspects) {
            this.bindMethodAdvices(this.clazz);
            this.bindConstructorAdvices();
            this.bindFieldAdvices();
        }
        return this.aspects;
    }

    public Map<Object, Set<LifecycleCallbackDefinition>> getLifecycleCallbacks() {
        if (!this.intitialisedLifecycleCallbacks) {
            this.bindLifecycles();
        }
        return this.lifecycleCallbacks;
    }

    public HashMap getMethodAdvices() {
        return this.methodAdvices;
    }

    public HashMap getConstructorAdvices() {
        return this.constructorAdvices;
    }

    public HashMap getFieldReadAdvices() {
        return this.fieldReadAdvices;
    }

    public HashMap getFieldWriteAdvices() {
        return this.fieldWriteAdvices;
    }

    public void createMethodMap(final Class superClass) {
        try {
            if (superClass == null || superClass == Object.class && !this.isInstanceContainer) {
                return;
            }
            this.createMethodMap(superClass.getSuperclass());
            Method[] methods = (Method[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return superClass.getDeclaredMethods();
                }
            });
            for (int i = 0; i < methods.length; ++i) {
                if (!Advisable.isAdvisable(methods[i])) continue;
                long hash = MethodHashing.methodHash(methods[i]);
                this.methodMap.put(hash, (Object)methods[i]);
            }
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(e.getException());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void bindMethodAdvices(Class superClass) {
        this.createMethodMap(superClass);
        if (this.methodMap != null) {
            Object[] methods = this.methodMap.getValues();
            for (int i = 0; i < methods.length; ++i) {
                this.bindMethodAdvice((Method)methods[i]);
            }
        }
    }

    protected void bindConstructorAdvices() {
        Constructor[] cons = (Constructor[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ReflectiveAspectBinder.this.clazz.getDeclaredConstructors();
            }
        });
        for (int i = 0; i < cons.length; ++i) {
            this.bindConstructorAdvice(cons[i]);
        }
    }

    protected void bindFieldAdvices() {
        Field[] fields = (Field[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ReflectiveAspectBinder.this.clazz.getDeclaredFields();
            }
        });
        for (int i = 0; i < fields.length; ++i) {
            this.bindFieldGetAdvice(fields[i]);
            this.bindFieldSetAdvice(fields[i]);
        }
    }

    protected boolean matches(AnnotationIntroduction ai, Object element) {
        AnnotationMatcher matcher = new AnnotationMatcher(this.advisor, element);
        return (Boolean)ai.getTarget().jjtAccept(matcher, null);
    }

    protected void bindMethodAdvice(Method mi) {
        LinkedHashMap repositoryBindings = this.advisor.getManager().getBindings();
        Iterator it = repositoryBindings.values().iterator();
        ArrayList<InterceptorFactory> advices = (ArrayList<InterceptorFactory>)this.methodAdvices.get(mi);
        while (it.hasNext()) {
            AdviceBinding binding = (AdviceBinding)it.next();
            PointcutMethodMatch pmatch = binding.getPointcut().matchesExecution(this.advisor, mi);
            if (pmatch == null || !pmatch.isMatch()) continue;
            if (advices == null) {
                advices = new ArrayList<InterceptorFactory>();
                this.methodAdvices.put(mi, advices);
            }
            advices.addAll(Arrays.asList(binding.getInterceptorFactories()));
            for (int i = 0; i < binding.getInterceptorFactories().length; ++i) {
                this.aspects.add(binding.getInterceptorFactories()[i].getAspect());
            }
        }
    }

    protected void bindConstructorAdvice(Constructor mi) {
        LinkedHashMap repositoryBindings = this.advisor.getManager().getBindings();
        Iterator it = repositoryBindings.values().iterator();
        ArrayList<InterceptorFactory> advices = (ArrayList<InterceptorFactory>)this.constructorAdvices.get(mi);
        while (it.hasNext()) {
            AdviceBinding binding = (AdviceBinding)it.next();
            if (!binding.getPointcut().matchesExecution(this.advisor, mi)) continue;
            if (advices == null) {
                advices = new ArrayList<InterceptorFactory>();
                this.constructorAdvices.put(mi, advices);
            }
            advices.addAll(Arrays.asList(binding.getInterceptorFactories()));
            for (int i = 0; i < binding.getInterceptorFactories().length; ++i) {
                this.aspects.add(binding.getInterceptorFactories()[i].getAspect());
            }
        }
    }

    protected void bindFieldGetAdvice(Field mi) {
        LinkedHashMap repositoryBindings = this.advisor.getManager().getBindings();
        Iterator it = repositoryBindings.values().iterator();
        ArrayList<InterceptorFactory> advices = (ArrayList<InterceptorFactory>)this.fieldReadAdvices.get(mi);
        while (it.hasNext()) {
            AdviceBinding binding = (AdviceBinding)it.next();
            if (!binding.getPointcut().matchesGet(this.advisor, mi)) continue;
            if (advices == null) {
                advices = new ArrayList<InterceptorFactory>();
                this.fieldReadAdvices.put(mi, advices);
            }
            advices.addAll(Arrays.asList(binding.getInterceptorFactories()));
            for (int i = 0; i < binding.getInterceptorFactories().length; ++i) {
                this.aspects.add(binding.getInterceptorFactories()[i].getAspect());
            }
        }
    }

    protected void bindFieldSetAdvice(Field mi) {
        LinkedHashMap repositoryBindings = this.advisor.getManager().getBindings();
        Iterator it = repositoryBindings.values().iterator();
        ArrayList<InterceptorFactory> advices = (ArrayList<InterceptorFactory>)this.fieldWriteAdvices.get(mi);
        while (it.hasNext()) {
            AdviceBinding binding = (AdviceBinding)it.next();
            if (!binding.getPointcut().matchesSet(this.advisor, mi)) continue;
            if (advices == null) {
                advices = new ArrayList<InterceptorFactory>();
                this.fieldWriteAdvices.put(mi, advices);
            }
            advices.addAll(Arrays.asList(binding.getInterceptorFactories()));
            for (int i = 0; i < binding.getInterceptorFactories().length; ++i) {
                this.aspects.add(binding.getInterceptorFactories()[i].getAspect());
            }
        }
    }

    protected void bindLifecycles() {
        for (LifecycleCallbackBinding binding : this.advisor.getManager().getLifecycleBindings().values()) {
            if (!binding.matches(this.advisor, this.clazz)) continue;
            Object state = binding.getControllerState();
            Set<LifecycleCallbackDefinition> callbacks = this.lifecycleCallbacks.get(state);
            if (callbacks == null) {
                callbacks = new HashSet<LifecycleCallbackDefinition>();
                this.lifecycleCallbacks.put(state, callbacks);
            }
            List<LifecycleCallbackDefinition> boundCallbacks = binding.getLifecycleCallbacks();
            for (LifecycleCallbackDefinition callback : boundCallbacks) {
                System.out.println("=====> Adding lifecycle " + callback + ":" + state);
                callbacks.add(callback);
            }
        }
    }
}

