/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.tools;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.arjuna.objectstore.ObjectStore;
import com.arjuna.ats.arjuna.state.InputObjectState;

public class TransactionMonitor {
    public static void main(String[] args) {
        block15: {
            String root = null;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].compareTo("-help") == 0) {
                    TransactionMonitor.usage();
                    System.exit(0);
                    continue;
                }
                if (args[i].compareTo("-root") == 0) {
                    root = args[i + 1];
                    ++i;
                    continue;
                }
                System.out.println("Unknown option " + args[i]);
                TransactionMonitor.usage();
                System.exit(0);
            }
            BasicAction ba = new BasicAction();
            String baType = ba.type();
            if (baType.charAt(0) == '/') {
                baType = baType.substring(1);
            }
            try {
                TxControl txc = new TxControl();
                ObjectStore imple = txc.getStore();
                InputObjectState types = new InputObjectState();
                if (!imple.allTypes(types)) break block15;
                String theName = null;
                int count = 0;
                try {
                    boolean endOfList = false;
                    while (!endOfList) {
                        theName = types.unpackString();
                        if (theName.compareTo("") == 0) {
                            endOfList = true;
                            continue;
                        }
                        if (!theName.startsWith(baType)) continue;
                        System.out.println(++count + ": " + theName);
                        InputObjectState uids = new InputObjectState();
                        if (imple.allObjUids(theName, uids)) {
                            Uid theUid = new Uid(Uid.nullUid());
                            try {
                                boolean endOfUids = false;
                                while (!endOfUids) {
                                    theUid.unpack(uids);
                                    if (theUid.equals(Uid.nullUid())) {
                                        endOfUids = true;
                                        continue;
                                    }
                                    System.out.print("\t" + theUid + " state is ");
                                    System.out.print(ObjectStore.stateStatusString(imple.currentState(theUid, theName)));
                                    System.out.println();
                                }
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        System.out.println();
                    }
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            }
            catch (Exception e) {
                System.err.println("Caught unexpected exception: " + e);
            }
        }
    }

    private static void usage() {
        System.out.println("Usage: TransactionMonitor [-root <store root>] [-help]");
    }
}

