/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.structure.vfs.explicit;

import java.io.IOException;
import java.net.URL;
import org.jboss.deployers.plugins.structure.vfs.AbstractStructureDeployer;
import org.jboss.deployers.plugins.structure.vfs.explicit.SecurityActions;
import org.jboss.deployers.plugins.structure.vfs.explicit.StructureMetaDataObjectFactory;
import org.jboss.deployers.spi.structure.vfs.StructureMetaData;
import org.jboss.deployers.spi.structure.vfs.StructuredDeployers;
import org.jboss.virtual.VirtualFile;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;

public class DeclaredStructure
extends AbstractStructureDeployer {
    private static ThreadLocal<StructureMetaData> activeMetaData = new ThreadLocal();

    public DeclaredStructure() {
        this.setRelativeOrder(0);
    }

    public boolean determineStructure(VirtualFile root, StructureMetaData metaData, StructuredDeployers deployers) {
        block6: {
            try {
                boolean isJBossStructure;
                boolean trace;
                block7: {
                    trace = this.log.isTraceEnabled();
                    if (SecurityActions.isLeaf(root)) break block6;
                    isJBossStructure = false;
                    if (trace) {
                        this.log.trace((Object)(root + " is not a leaf"));
                    }
                    try {
                        VirtualFile jbossStructure = root.findChild("META-INF/jboss-structure.xml");
                        this.log.trace((Object)"... context has a META-INF subdirectory");
                        URL url = jbossStructure.toURL();
                        UnmarshallerFactory factory = UnmarshallerFactory.newInstance();
                        Unmarshaller unmarshaller = factory.newUnmarshaller();
                        StructureMetaDataObjectFactory ofactory = new StructureMetaDataObjectFactory();
                        unmarshaller.unmarshal(url.toString(), (ObjectModelFactory)ofactory, (Object)metaData);
                        activeMetaData.set(metaData);
                        isJBossStructure = true;
                    }
                    catch (IOException e) {
                        if (!trace) break block7;
                        this.log.trace((Object)"... no META-INF subdirectory.");
                    }
                }
                if (trace) {
                    this.log.trace((Object)(root + " isJBossStructure: " + isJBossStructure));
                }
                return isJBossStructure;
            }
            catch (Exception e) {
                this.log.warn((Object)("Error determining structure: " + root.getName()), (Throwable)e);
            }
        }
        return false;
    }
}

