/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.deployers.helpers;

import java.util.Set;
import org.jboss.deployers.plugins.deployer.AbstractSimpleDeployer;
import org.jboss.deployers.plugins.deployers.helpers.SimpleDeploymentVisitor;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRealDeployer<T>
extends AbstractSimpleDeployer {
    private SimpleDeploymentVisitor<T> visitor;
    private Class<T> deploymentType;
    private boolean warned;

    public AbstractRealDeployer() {
        this.setRelativeOrder(10000);
    }

    protected void setDeploymentVisitor(SimpleDeploymentVisitor<T> visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Null visitor");
        }
        this.visitor = visitor;
        this.deploymentType = visitor.getVisitorType();
        if (this.deploymentType == null) {
            throw new IllegalArgumentException("Null visitor type");
        }
    }

    @Override
    public void deploy(DeploymentUnit unit) throws DeploymentException {
        if (this.visitor == null) {
            if (!this.warned) {
                this.log.error((Object)("INTERNAL ERROR: Visitor is null for " + this.getClass().getName()));
                this.warned = true;
            }
            return;
        }
        try {
            Set<T> deployments = unit.getAllMetaData(this.deploymentType);
            for (T deployment : deployments) {
                this.visitor.deploy(unit, deployment);
            }
        }
        catch (Throwable t) {
            this.undeploy(unit);
            throw DeploymentException.rethrowAsDeploymentException("Error deploying: " + unit.getName(), t);
        }
    }

    @Override
    public void undeploy(DeploymentUnit unit) {
        if (this.visitor == null) {
            return;
        }
        Set<T> deployments = unit.getAllMetaData(this.deploymentType);
        for (T deployment : deployments) {
            this.visitor.undeploy(unit, deployment);
        }
    }
}

