/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.tools.content;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.jboss.elasticsearch.tools.content.PreprocessChainContext;
import org.jboss.elasticsearch.tools.content.StructureUtils;
import org.jboss.elasticsearch.tools.content.StructuredContentPreprocessorWithSourceBasesBase;
import org.jboss.elasticsearch.tools.content.ValueUtils;

public class RegExpCapturingGroupPreprocessor
extends StructuredContentPreprocessorWithSourceBasesBase<Object> {
    protected static final String CFG_SOURCE_FIELD = "source_field";
    protected static final String CFG_PATTERN = "pattern";
    protected static final String CFG_RESULT_MAPPING = "result_mapping";
    protected String fieldSource;
    protected Pattern patternCompiled;
    protected Map<Object, String> resultMapping;

    @Override
    public void init(Map<String, Object> settings) throws SettingsException {
        super.init(settings);
        this.fieldSource = XContentMapValues.nodeStringValue((Object)settings.get(CFG_SOURCE_FIELD), null);
        this.validateConfigurationStringNotEmpty(this.fieldSource, CFG_SOURCE_FIELD);
        String pattern = XContentMapValues.nodeStringValue((Object)settings.get(CFG_PATTERN), null);
        this.validateConfigurationStringNotEmpty(pattern, CFG_PATTERN);
        try {
            this.patternCompiled = Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            throw new SettingsException("'settings/pattern' configuration value for '" + this.name + "' preprocessor is invalid: " + e.getMessage());
        }
        try {
            this.resultMapping = (Map)settings.get(CFG_RESULT_MAPPING);
            this.validateResultMappingConfiguration(this.resultMapping, CFG_RESULT_MAPPING);
        }
        catch (ClassCastException e) {
            throw new SettingsException("'settings/result_mapping' configuration value for '" + this.name + "' preprocessor is invalid");
        }
    }

    protected void validateResultMappingConfiguration(Map<Object, String> value, String configFieldName) throws SettingsException {
        if (value == null || value.isEmpty()) {
            throw new SettingsException("Missing or empty 'settings/" + configFieldName + "' configuration object for '" + this.name + "' preprocessor");
        }
        for (Object index : value.keySet()) {
            if (ValueUtils.isEmpty(index)) {
                throw new SettingsException("Missing or empty index in 'settings/" + configFieldName + "' configuration for '" + this.name + "' preprocessor");
            }
            boolean isnumber = false;
            if (index instanceof Number) {
                isnumber = true;
            } else if (index instanceof String) {
                try {
                    new Integer((String)index);
                    isnumber = true;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (!isnumber) {
                throw new SettingsException("Index must be a number in 'settings/" + configFieldName + "' configuration for '" + this.name + "' preprocessor");
            }
            try {
                if (!ValueUtils.isEmpty(value.get(index))) continue;
                throw new SettingsException("Missing or empty value in 'settings/" + configFieldName + "/" + index + "' configuration for '" + this.name + "' preprocessor");
            }
            catch (ClassCastException e) {
                throw new SettingsException("Value for 'settings/" + configFieldName + "/" + index + "' configuration for '" + this.name + "' preprocessor must be String");
            }
        }
    }

    @Override
    protected void processOneSourceValue(Map<String, Object> data, Object context, String base, PreprocessChainContext chainContext) {
        Object v = null;
        v = this.fieldSource.contains(".") ? XContentMapValues.extractValue((String)this.fieldSource, data) : data.get(this.fieldSource);
        if (v != null) {
            if (v instanceof String) {
                String vs = (String)v;
                Matcher m = this.patternCompiled.matcher(vs);
                if (m.matches()) {
                    for (Object index : this.resultMapping.keySet()) {
                        int i = -1;
                        i = index instanceof Number ? ((Number)index).intValue() : Integer.parseInt(index.toString());
                        if (i < 0 || i > m.groupCount()) continue;
                        try {
                            StructureUtils.putValueIntoMapOfMaps(data, this.resultMapping.get(index), m.group(i));
                        }
                        catch (IllegalStateException e) {
                            String warningMessage = "No match found for Capturing group " + i + " in value '" + vs + "' from field '" + this.fieldSource + "'";
                            this.addDataWarning(chainContext, warningMessage);
                            this.logger.debug(warningMessage, new Object[0]);
                        }
                    }
                } else {
                    String warningMessage = "value '" + vs + "' for field '" + this.fieldSource + "' do not match pattern, so can't be processed";
                    this.addDataWarning(chainContext, warningMessage);
                    this.logger.debug(warningMessage, new Object[0]);
                }
            } else {
                String warningMessage = "value for field '" + this.fieldSource + "' is not String but is " + v.getClass().getName() + ", so can't be processed";
                this.addDataWarning(chainContext, warningMessage);
                this.logger.debug(warningMessage, new Object[0]);
            }
        }
    }

    @Override
    protected Object createContext(Map<String, Object> data) {
        return null;
    }

    public String getFieldSource() {
        return this.fieldSource;
    }

    public Map<Object, String> getResultMapping() {
        return this.resultMapping;
    }

    public String getPattern() {
        return this.patternCompiled != null ? this.patternCompiled.pattern() : null;
    }
}

