/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.tools.content;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.common.jackson.core.io.JsonStringEncoder;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.jboss.elasticsearch.tools.content.HttpCallException;
import org.jboss.elasticsearch.tools.content.PreprocessChainContext;
import org.jboss.elasticsearch.tools.content.StructureUtils;
import org.jboss.elasticsearch.tools.content.StructuredContentPreprocessorBase;
import org.jboss.elasticsearch.tools.content.ValueUtils;

public class RESTCallPreprocessor
extends StructuredContentPreprocessorBase {
    protected static final String CFG_REQUEST_METHOD = "request_method";
    protected static final String CFG_REQUEST_URL = "request_url";
    protected static final String CFG_REQUEST_TIMEOUT = "request_timeout";
    protected static final String CFG_REQUEST_MAX_PARALLEL = "request_max_parallel";
    protected static final String CFG_REQUEST_ACCEPT_HEADER = "request_accept_header";
    protected static final String CFG_REQUEST_USER_AGENT_HEADER = "request_user_agent_header";
    protected static final String CFG_REQUEST_CONTENT_TYPE_HEADER = "request_content_type_header";
    protected static final String CFG_REQUEST_CONTENT = "request_content";
    protected static final String CFG_RETRY_MAX_NUM_OF_ATTEMPTS = "retry_max_num_of_attempts";
    protected static final String CFG_RETRY_DELAY = "retry_delay";
    protected static final String CFG_RESPONSE_MAPPING = "response_mapping";
    protected static final String CFG_rest_response_field = "rest_response_field";
    protected static final String CFG_target_field = "target_field";
    protected static final String CFG_value_default = "value_default";
    protected HttpMethodType request_method;
    protected String request_url;
    protected String request_content_template;
    protected Map<String, String> headers = new HashMap<String, String>();
    protected List<Map<String, String>> responseMapping;
    protected long retry_max_num_of_attempts;
    protected long retry_delay;
    protected CloseableHttpClient httpclient;
    protected static final ValueUtils.IValueEncoder jsonValueEncoder = new ValueUtils.IValueEncoder(){

        @Override
        public String encode(Object value) {
            if (value == null) {
                return "";
            }
            try {
                return new String(JsonStringEncoder.getInstance().quoteAsUTF8(value.toString()), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    };
    protected static final ValueUtils.IValueEncoder urlValueEncoder = new ValueUtils.IValueEncoder(){

        @Override
        public String encode(Object value) {
            if (value == null) {
                return "";
            }
            try {
                return URLEncoder.encode(value.toString(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    };

    @Override
    public void init(Map<String, Object> settings) throws SettingsException {
        if (settings == null) {
            throw new SettingsException("'settings' section is not defined for preprocessor " + this.name);
        }
        String httpMethodStr = ValueUtils.trimToNull(XContentMapValues.nodeStringValue((Object)settings.get(CFG_REQUEST_METHOD), null));
        this.request_method = httpMethodStr == null ? HttpMethodType.GET : HttpMethodType.valueOf(httpMethodStr);
        this.request_url = XContentMapValues.nodeStringValue((Object)settings.get(CFG_REQUEST_URL), null);
        this.validateConfigurationStringNotEmpty(this.request_url, CFG_REQUEST_URL);
        this.responseMapping = (List)settings.get(CFG_RESPONSE_MAPPING);
        this.validateResultMappingConfiguration(this.responseMapping, CFG_RESPONSE_MAPPING);
        this.request_content_template = XContentMapValues.nodeStringValue((Object)settings.get(CFG_REQUEST_CONTENT), null);
        this.retry_max_num_of_attempts = XContentMapValues.nodeLongValue((Object)settings.get(CFG_RETRY_MAX_NUM_OF_ATTEMPTS), (long)1L);
        if (this.retry_max_num_of_attempts < 1L) {
            this.retry_max_num_of_attempts = 1L;
        }
        this.retry_delay = XContentMapValues.nodeLongValue((Object)settings.get(CFG_RETRY_DELAY), (long)10000L);
        if (this.retry_delay < 1L) {
            this.retry_delay = 1L;
        }
        this.headers.put("Accept", XContentMapValues.nodeStringValue((Object)settings.get(CFG_REQUEST_ACCEPT_HEADER), (String)"application/json"));
        this.headers.put("Content-Type", XContentMapValues.nodeStringValue((Object)settings.get(CFG_REQUEST_CONTENT_TYPE_HEADER), (String)"application/json"));
        this.headers.put("User-Agent", XContentMapValues.nodeStringValue((Object)settings.get(CFG_REQUEST_USER_AGENT_HEADER), (String)("SearchiskoContenPreprocessor (" + this.getName() + ")")));
        this.initHttpClient(settings);
    }

    protected void validateResultMappingConfiguration(List<Map<String, String>> value, String configFieldName) throws SettingsException {
        if (value == null || value.isEmpty()) {
            throw new SettingsException("Missing or empty 'settings/" + configFieldName + "' configuration array for '" + this.name + "' preprocessor");
        }
        for (Map<String, String> mappingRecord : value) {
            if (ValueUtils.isEmpty(mappingRecord.get(CFG_rest_response_field))) {
                throw new SettingsException("Missing or empty 'settings/" + configFieldName + "/" + CFG_rest_response_field + "' configuration value for '" + this.name + "' preprocessor");
            }
            if (!ValueUtils.isEmpty(mappingRecord.get(CFG_target_field))) continue;
            throw new SettingsException("Missing or empty 'settings/" + configFieldName + "/" + CFG_target_field + "' configuration value for '" + this.name + "' preprocessor");
        }
    }

    @Override
    public Map<String, Object> preprocessData(Map<String, Object> data, PreprocessChainContext context) {
        if (data == null) {
            return null;
        }
        String url = this.prepareUrl(data);
        String content = this.prepareContent(data);
        long attempt = 0L;
        while (attempt < this.retry_max_num_of_attempts) {
            ++attempt;
            try {
                HttpResponseContent resp = this.performHttpCall(url, content, this.headers, this.request_method);
                this.processResponse(data, resp);
                return data;
            }
            catch (Exception e) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("REST request attempt " + attempt + "/" + this.retry_max_num_of_attempts + " failed: {}", (Throwable)e, new Object[]{e.getMessage()});
                }
                if (context != null) {
                    context.addDataWarning(this.getName(), "REST request attempt " + attempt + "/" + this.retry_max_num_of_attempts + " failed due to: " + e.getMessage());
                }
                try {
                    Thread.sleep(this.retry_delay);
                }
                catch (InterruptedException e2) {
                    return data;
                }
            }
        }
        return data;
    }

    protected void processResponse(Map<String, Object> data, HttpResponseContent response) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ResponseData: {}", new Object[]{response});
        }
        Map<String, Object> responseParsed = ValueUtils.parseJSON(response.content);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Parsed ResponseData: {}", new Object[]{responseParsed});
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Data before processing: {}", new Object[]{data});
        }
        for (Map<String, String> mappingRecord : this.responseMapping) {
            String restResponseField = mappingRecord.get(CFG_rest_response_field);
            Object v = null;
            v = "_source".equals(restResponseField) ? responseParsed : (restResponseField.contains(".") ? XContentMapValues.extractValue((String)restResponseField, responseParsed) : responseParsed.get(restResponseField));
            if (v == null && mappingRecord.get(CFG_value_default) != null) {
                v = ValueUtils.processStringValuePatternReplacement(mappingRecord.get(CFG_value_default), data, null);
            }
            StructureUtils.putValueIntoMapOfMaps(data, mappingRecord.get(CFG_target_field), v);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Data after processing: {}", new Object[]{data});
        }
    }

    protected String prepareContent(Map<String, Object> data) {
        if (HttpMethodType.POST.equals((Object)this.request_method) && this.request_content_template != null) {
            return ValueUtils.processStringValuePatternReplacement(this.request_content_template, data, null, '$', '$', jsonValueEncoder);
        }
        return null;
    }

    protected String prepareUrl(Map<String, Object> data) {
        return ValueUtils.processStringValuePatternReplacement(this.request_url, data, null, urlValueEncoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpResponseContent performHttpCall(String url, String content, Map<String, String> headers, HttpMethodType methodType) throws Exception, HttpCallException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Going to perform {} REST request to url {} with content: {} ", new Object[]{methodType, url, content});
        }
        HttpGet method = null;
        URIBuilder builder = new URIBuilder(url);
        if (methodType.equals((Object)HttpMethodType.POST)) {
            HttpPost postMethod = new HttpPost(url);
            postMethod.setEntity((HttpEntity)new StringEntity(content));
            method = postMethod;
        } else {
            method = new HttpGet(builder.build());
        }
        if (headers != null) {
            for (String headerName : headers.keySet()) {
                method.addHeader(headerName, headers.get(headerName));
            }
        }
        CloseableHttpResponse response = null;
        try {
            HttpHost targetHost = new HttpHost(builder.getHost(), builder.getPort(), builder.getScheme());
            HttpClientContext localcontext = HttpClientContext.create();
            response = this.httpclient.execute(targetHost, (HttpRequest)method, (HttpContext)localcontext);
            int statusCode = response.getStatusLine().getStatusCode();
            byte[] responseContent = null;
            if (response.getEntity() != null) {
                responseContent = EntityUtils.toByteArray((HttpEntity)response.getEntity());
            }
            if (statusCode != 200) {
                throw new HttpCallException(url, statusCode, responseContent != null ? new String(responseContent) : "");
            }
            Header h = response.getFirstHeader("Content-Type");
            HttpResponseContent httpResponseContent = new HttpResponseContent(h != null ? h.getValue() : null, responseContent);
            return httpResponseContent;
        }
        finally {
            if (response != null) {
                response.close();
            }
            method.releaseConnection();
        }
    }

    protected void initHttpClient(Map<String, Object> settings) {
        int maxParallel = XContentMapValues.nodeIntegerValue((Object)settings.get(CFG_REQUEST_MAX_PARALLEL), (int)10);
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager();
        connManager.setDefaultMaxPerRoute(maxParallel);
        connManager.setMaxTotal(maxParallel);
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setCharset(Consts.UTF_8).build();
        connManager.setDefaultConnectionConfig(connectionConfig);
        HttpClientBuilder clientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager);
        int timeout = XContentMapValues.nodeIntegerValue((Object)settings.get(CFG_REQUEST_TIMEOUT), (int)10000);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(timeout).setConnectTimeout(timeout).build();
        clientBuilder.setDefaultRequestConfig(requestConfig);
        this.httpclient = clientBuilder.build();
        this.logger.info("http client initialized", new Object[0]);
    }

    protected void finalize() throws Throwable {
        if (this.httpclient != null) {
            this.httpclient.close();
        }
        this.httpclient = null;
    }

    public static final class HttpResponseContent {
        public String contentType;
        public byte[] content;

        public HttpResponseContent(String contentType, byte[] content) {
            this.contentType = contentType;
            this.content = content;
        }

        public String toString() {
            return "HttpResponseContent [contentType=" + this.contentType + ", content=" + this.content != null ? new String(this.content) : "]";
        }
    }

    public static enum HttpMethodType {
        GET,
        POST;

    }
}

