/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.impl.objectfactory;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aspects.remoting.InvokeRemoteInterceptor;
import org.jboss.aspects.remoting.PojiProxy;
import org.jboss.ejb3.common.registrar.spi.Ejb3Registrar;
import org.jboss.ejb3.common.registrar.spi.Ejb3RegistrarLocator;
import org.jboss.ejb3.common.registrar.spi.NotBoundException;
import org.jboss.ejb3.proxy.impl.factory.ProxyFactory;
import org.jboss.ejb3.proxy.impl.io.ObjectInputStream;
import org.jboss.ejb3.proxy.impl.remoting.IsLocalProxyFactoryInterceptor;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProxyObjectFactory
implements ObjectFactory,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger((String)ProxyObjectFactory.class.getName());

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        log.debug((Object)(ProxyObjectFactory.class.getName() + " servicing request for " + name.toString()));
        assert (Reference.class.isAssignableFrom(obj.getClass())) : "Object bound at " + name.toString() + " was not of expected type " + Reference.class.getName();
        Reference ref = (Reference)obj;
        Map<String, List<String>> refAddrs = this.getReferenceAddresses(ref);
        String proxyFactoryRegistryKey = this.getSingleRequiredReferenceAddressValue(name, refAddrs, "ProxyFactoryKey");
        ProxyFactory proxyFactory = null;
        String isLocalStringFromRefAddr = this.getSingleRequiredReferenceAddressValue(name, refAddrs, "Proxy Factory is Local");
        assert (isLocalStringFromRefAddr != null && isLocalStringFromRefAddr.trim().length() > 0) : "Required " + RefAddr.class.getSimpleName() + " \"" + "Proxy Factory is Local" + "\" was not found at JNDI Name " + name;
        boolean isLocal = new Boolean(isLocalStringFromRefAddr);
        if (isLocal) {
            try {
                Ejb3Registrar registrar = Ejb3RegistrarLocator.locateRegistrar();
                Object pfObj = registrar.lookup((Object)proxyFactoryRegistryKey);
                assert (pfObj != null) : ProxyFactory.class.getName() + " from key " + proxyFactoryRegistryKey + " was null";
                assert (pfObj instanceof ProxyFactory) : " Object obtained from key " + proxyFactoryRegistryKey + " was expected to be of type " + ProxyFactory.class.getName() + " but was instead " + pfObj;
                proxyFactory = (ProxyFactory)pfObj;
            }
            catch (NotBoundException nbe) {
                throw new RuntimeException("Could not find proxyfactory at " + proxyFactoryRegistryKey + " -looking up local Proxy from Remote JVM?", nbe);
            }
        } else {
            proxyFactory = this.getProxyFactoryFromJNDI(proxyFactoryRegistryKey, nameCtx, environment);
        }
        Object proxy = this.getProxy(proxyFactory, name, refAddrs);
        assert (proxy != null) : "Proxy returned from " + proxyFactory + " was null.";
        if (!isLocal) {
            ClassLoader tcl = Thread.currentThread().getContextClassLoader();
            proxy = this.redefineObjectInClassLoader(proxy, tcl);
        }
        return proxy;
    }

    @Deprecated
    protected ProxyFactory createProxyFactoryProxy(Name name, Map<String, List<String>> refAddrs, String proxyFactoryRegistryKey) throws Exception {
        String url = this.getSingleReferenceAddressValue(name, refAddrs, "Remoting Host URL");
        assert (url != null && url.trim().length() != 0) : InvokerLocator.class.getSimpleName() + " URL is required, but is not specified; improperly bound reference " + "in JNDI or looking up local Proxy from Remote JVM";
        if (url == null || url.trim().length() == 0) {
            throw new RuntimeException("Could not find " + InvokerLocator.class.getSimpleName() + " URL at JNDI address \"" + name + "\"; looking up local Proxy from Remote JVM?");
        }
        InvokerLocator locator = new InvokerLocator(url);
        Interceptor[] interceptors = new Interceptor[]{IsLocalProxyFactoryInterceptor.singleton, InvokeRemoteInterceptor.singleton};
        PojiProxy handler = new PojiProxy((Object)proxyFactoryRegistryKey, locator, interceptors);
        Class[] interfaces = new Class[]{this.getProxyFactoryClass()};
        return (ProxyFactory)Proxy.newProxyInstance(interfaces[0].getClassLoader(), interfaces, (InvocationHandler)handler);
    }

    protected ProxyFactory getProxyFactoryFromJNDI(String proxyFactoryKey, Context context, Hashtable<?, ?> environment) {
        try {
            Object factory = context.lookup(proxyFactoryKey);
            assert (factory instanceof ProxyFactory) : "Unexpected object of type " + factory.getClass() + " in JNDI, at key " + proxyFactoryKey + " Expected type " + ProxyFactory.class;
            return (ProxyFactory)factory;
        }
        catch (NamingException e) {
            throw new RuntimeException("Exception while trying to locate proxy factory in JNDI, at key " + proxyFactoryKey, e);
        }
    }

    protected String getSingleRequiredReferenceAddressValue(Name name, Map<String, List<String>> referenceAddresses, String refAddrType) {
        String value = this.getSingleReferenceAddressValue(name, referenceAddresses, refAddrType);
        assert (value != null && !value.trim().equals("")) : "Exactly one " + RefAddr.class.getSimpleName() + " of type " + refAddrType + " must be defined for Name " + name.toString() + ", none found";
        return value;
    }

    protected String getSingleReferenceAddressValue(Name name, Map<String, List<String>> referenceAddresses, String refAddrType) {
        List<String> values = referenceAddresses.get(refAddrType);
        assert (values == null || values.size() == 1) : "Only one " + RefAddr.class.getSimpleName() + " of type " + refAddrType + " may be defined, instead found: " + values;
        String value = null;
        if (values != null) {
            value = values.get(0).trim();
        }
        return value;
    }

    protected boolean hasBusiness(Name name, Map<String, List<String>> referenceAddresses) {
        boolean hasBusiness = false;
        boolean hasLocalBusiness = this.hasLocalBusiness(referenceAddresses);
        boolean hasRemoteBusiness = this.hasRemoteBusiness(referenceAddresses);
        String errorMessage = "ObjectFactory at JNDI \"" + name.toString() + "\" contains references to both local and remote business interfaces";
        assert (!hasLocalBusiness || !hasRemoteBusiness) : errorMessage;
        if (hasLocalBusiness && hasRemoteBusiness) {
            throw new RuntimeException(errorMessage);
        }
        hasBusiness = hasLocalBusiness || hasRemoteBusiness;
        return hasBusiness;
    }

    private Object redefineObjectInClassLoader(Object obj, ClassLoader target) throws ClassNotFoundException, IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bout);
        out.writeObject(obj);
        out.flush();
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(bin, target);
        Object result = in.readObject();
        in.close();
        return result;
    }

    protected Object redefineProxyInTcl(Object proxy) {
        ClassLoader proxyCl;
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        if (tcl != (proxyCl = proxy.getClass().getClassLoader())) {
            Class<?> proxyClass = proxy.getClass();
            assert (Proxy.isProxyClass(proxyClass)) : "Assumed Proxy is not an instance of " + Proxy.class.getName();
            InvocationHandler handler = Proxy.getInvocationHandler(proxy);
            Class<?>[] proxyInterfaces = proxyClass.getInterfaces();
            HashSet ourClInterfaces = new HashSet();
            for (Class<?> proxyInterface : proxyInterfaces) {
                String proxyInterfaceName = proxyInterface.getName();
                Class<?> ourDefinedProxyInterface = null;
                try {
                    ourDefinedProxyInterface = Class.forName(proxyInterfaceName, false, tcl);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Can not find interface declared by Proxy in our CL + " + tcl, e);
                }
                ourClInterfaces.add(ourDefinedProxyInterface);
            }
            proxy = Proxy.newProxyInstance(tcl, ourClInterfaces.toArray(new Class[0]), handler);
            return proxy;
        }
        return proxy;
    }

    protected boolean hasLocalBusiness(Map<String, List<String>> referenceAddresses) {
        return referenceAddresses.containsKey("Local Business Interface");
    }

    protected boolean hasRemoteBusiness(Map<String, List<String>> referenceAddresses) {
        return referenceAddresses.containsKey("Remote Business Interface");
    }

    protected abstract Object getProxy(ProxyFactory var1, Name var2, Map<String, List<String>> var3);

    protected abstract Class<?> getProxyFactoryClass();

    private Map<String, List<String>> getReferenceAddresses(Reference ref) {
        HashMap<String, List<String>> referenceAddresses = new HashMap<String, List<String>>();
        int count = 0;
        Enumeration<RefAddr> refAddrs = ref.getAll();
        while (refAddrs.hasMoreElements()) {
            RefAddr refAddr = refAddrs.nextElement();
            String type = refAddr.getType();
            Class<String> expectedContentsType = String.class;
            Object refAddrContent = refAddr.getContent();
            assert (refAddrContent != null) : "Encountered Reference Address of type " + type + " but with null Content";
            assert (expectedContentsType.isAssignableFrom(refAddrContent.getClass())) : "Content of Reference Address of type \"" + type + "\" at index " + count + " was not of expected Java type " + expectedContentsType.getName();
            String content = (String)refAddr.getContent();
            if (!referenceAddresses.containsKey(type)) {
                referenceAddresses.put(type, new ArrayList());
            }
            ((List)referenceAddresses.get(type)).add(content);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Found reference type \"" + type + "\" with content \"" + content + "\""));
            }
            ++count;
        }
        return referenceAddresses;
    }
}

