/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.impl.handler.session;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.jboss.aop.Advisor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.util.MethodHashing;
import org.jboss.ejb3.common.lang.SerializableMethod;
import org.jboss.ejb3.common.registrar.spi.Ejb3Registrar;
import org.jboss.ejb3.common.registrar.spi.Ejb3RegistrarLocator;
import org.jboss.ejb3.proxy.impl.handler.session.SessionProxyInvocationHandlerBase;
import org.jboss.ejb3.proxy.impl.invocation.StatefulRemoteInvocation;
import org.jboss.ejb3.proxy.spi.container.InvokableContext;

public class SessionLocalProxyInvocationHandler
extends SessionProxyInvocationHandlerBase
implements Serializable {
    private static final long serialVersionUID = 1L;

    public SessionLocalProxyInvocationHandler(String containerName, String containerGuid, Interceptor[] interceptors) {
        super(containerName, containerGuid, interceptors, null, null);
    }

    public SessionLocalProxyInvocationHandler(String containerName, String containerGuid, Interceptor[] interceptors, String businessInterfaceType, Serializable sessionId) {
        super(containerName, containerGuid, interceptors, businessInterfaceType, sessionId);
    }

    protected InvokableContext getContainer(Method method, Object[] args) {
        Object obj = Ejb3RegistrarLocator.locateRegistrar().lookup((Object)this.getContainerName());
        assert (obj instanceof InvokableContext) : "Container retrieved from " + Ejb3Registrar.class.getSimpleName() + " was not of expected type " + InvokableContext.class.getName() + " but was instead " + obj;
        InvokableContext container = (InvokableContext)obj;
        InvokableContext proxyToContainer = (InvokableContext)Proxy.newProxyInstance(InvokableContext.class.getClassLoader(), new Class[]{InvokableContext.class}, (InvocationHandler)new LocalInvokableContextHandler(method, args, this.getTarget(), this.getInterceptors(), container));
        return proxyToContainer;
    }

    private static class LocalContainerInvocation
    extends StatefulRemoteInvocation {
        public LocalContainerInvocation(Interceptor[] interceptors, long methodHash, Method advisedMethod, Method unadvisedMethod, Advisor advisor, Object id) {
            super(interceptors, methodHash, advisedMethod, unadvisedMethod, advisor, id);
        }

        public Object invokeTarget() throws Throwable {
            try {
                Method methodToInvoke = InvokableContext.class.getMethod("invoke", Object.class, SerializableMethod.class, Object[].class);
                return methodToInvoke.invoke(this.getTargetObject(), this.arguments);
            }
            catch (Throwable t) {
                throw LocalContainerInvocation.handleErrors((Object)this.getTargetObject(), (Method)this.getMethod(), (Object[])this.arguments, (Throwable)t);
            }
        }

        public Invocation copy() {
            LocalContainerInvocation copy = new LocalContainerInvocation(this.interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor, this.id);
            copy.setMetaData(this.getMetaData());
            copy.setArguments(this.getArguments());
            copy.setTargetObject(this.targetObject);
            return copy;
        }
    }

    private static final class LocalInvokableContextHandler
    implements InvocationHandler {
        private final Method realMethod;
        private final Object[] realArgs;
        private final Object session;
        private final Interceptor[] interceptors;
        final InvokableContext container;

        LocalInvokableContextHandler(Method realMethod, Object[] realArgs, Object session, Interceptor[] interceptors, InvokableContext container) {
            assert (realMethod != null) : "method must be specified";
            assert (realArgs != null) : "realArgs must be specified";
            assert (interceptors != null) : "interceptors must be specified";
            assert (container != null) : "container must be specified";
            this.realMethod = realMethod;
            this.realArgs = realArgs;
            this.session = session;
            this.interceptors = interceptors;
            this.container = container;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            long hash = MethodHashing.calculateHash((Method)this.realMethod);
            LocalContainerInvocation invocation = new LocalContainerInvocation(this.interceptors, hash, this.realMethod, this.realMethod, null, this.session);
            invocation.setTargetObject(this.container);
            invocation.setArguments(args);
            return invocation.invokeNext();
        }
    }
}

