/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.sort;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.deployers.plugins.sort.DeployerSorter;
import org.jboss.deployers.spi.Ordered;
import org.jboss.deployers.spi.deployer.Deployer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KahnDeployerSorter
implements DeployerSorter {
    protected int compare(Deployer one, Deployer two) {
        int relation = one.getRelativeOrder() - two.getRelativeOrder();
        if (relation == 0) {
            relation = one.hashCode() - two.hashCode();
        }
        assert (relation != 0);
        return relation;
    }

    protected Collection<Edge> createEdges(Deployer from, Map<String, Collection<Deployer>> inputCache, Set<String> outputs) {
        ArrayList<Edge> result = new ArrayList<Edge>();
        for (String output : outputs) {
            Collection<Deployer> deployers = inputCache.get(output);
            if (deployers == null) continue;
            for (Deployer to : deployers) {
                if (from == to) continue;
                result.add(new Edge(from, output, to));
            }
        }
        return result;
    }

    protected Collection<Edge> createEdges(Map<String, Collection<Deployer>> outputCache, Set<String> inputs, Deployer to) {
        ArrayList<Edge> result = new ArrayList<Edge>();
        for (String input : inputs) {
            Collection<Deployer> deployers = outputCache.get(input);
            if (deployers == null) continue;
            for (Deployer from : deployers) {
                result.add(new Edge(from, input, to));
            }
        }
        return result;
    }

    protected Collection<Edge> findInputs(Map<Deployer, Set<Edge>> edgeCache, Deployer from, Map<String, Collection<Deployer>> cache, Set<String> inputs) {
        ArrayList<Edge> result = new ArrayList<Edge>();
        for (String input : inputs) {
            Collection<Deployer> deployers = cache.get(input);
            if (deployers == null) continue;
            for (Deployer d : deployers) {
                if (d == from) continue;
                Edge potential = new Edge(from, input, d);
                Set<Edge> edges = edgeCache.get(d);
                if (!edges.contains(potential)) continue;
                result.add(potential);
            }
        }
        return result;
    }

    protected boolean isInputMaster(Collection<Deployer> deployers, Deployer deployer, String input) {
        for (Deployer other : deployers) {
            if (!this.isTransient(other, input) || this.compare(other, deployer) <= 0) continue;
            return false;
        }
        return true;
    }

    protected boolean isTransient(Deployer deployer, String input) {
        return deployer.getInputs().contains(input) && deployer.getOutputs().contains(input);
    }

    protected void process(Deployer deployer, Collection<Deployer> s, Map<String, Collection<Deployer>> inputCache, Map<Deployer, Set<Edge>> edgeCache, Set<String> outputs, Map<String, Collection<Deployer>> outputCache) {
        Collection<Edge> edges;
        outputs.addAll(deployer.getOutputs());
        if (deployer.getInputs() == null || deployer.getInputs().size() == 0) {
            s.add(deployer);
        } else {
            edges = edgeCache.get(deployer);
            assert (edges == null);
            edges = new HashSet<Edge>();
            edgeCache.put(deployer, (Set<Edge>)edges);
            for (String input : deployer.getInputs()) {
                Collection<Deployer> c = inputCache.get(input);
                if (c == null) {
                    c = new ArrayList<Deployer>();
                    inputCache.put(input, c);
                }
                c.add(deployer);
            }
            Collection<Edge> c = this.createEdges(outputCache, deployer.getInputs(), deployer);
            if (c.isEmpty()) {
                s.add(deployer);
            } else {
                edges.addAll(c);
            }
        }
        for (String output : deployer.getOutputs()) {
            Collection<Deployer> c = outputCache.get(output);
            if (c == null) {
                c = new ArrayList<Deployer>();
                outputCache.put(output, c);
            }
            c.add(deployer);
        }
        edges = this.createEdges(deployer, inputCache, deployer.getOutputs());
        for (Edge e : edges) {
            Set<Edge> cachedEdges = edgeCache.get(e.to);
            if (cachedEdges == null) {
                cachedEdges = new HashSet<Edge>();
                edgeCache.put(e.to, cachedEdges);
            }
            cachedEdges.add(e);
            s.remove(e.to);
        }
    }

    public void processTransientDeployers(List<Deployer> s, Map<String, Collection<Deployer>> inputCache, Map<String, Collection<Deployer>> outputCache, Map<Deployer, Set<Edge>> edgeCache) {
        for (String input : inputCache.keySet()) {
            Collection<Deployer> others = outputCache.get(input);
            if (others == null) continue;
            ArrayList<Deployer> deployers = new ArrayList<Deployer>(inputCache.get(input));
            deployers.retainAll(others);
            if (deployers.isEmpty() || deployers.size() == 1) continue;
            ArrayList<ScoredDeployer> scoredDeployers = new ArrayList<ScoredDeployer>();
            for (Deployer d : deployers) {
                ScoredDeployer scoredDeployer = new ScoredDeployer(d);
                scoredDeployers.add(scoredDeployer);
                Set<Edge> edges = edgeCache.get(d);
                for (Edge e : new HashSet<Edge>(edges)) {
                    if (deployers.contains(e.from) && input.equals(e.input)) {
                        edges.remove(e);
                        continue;
                    }
                    if (!deployers.contains(e.from)) continue;
                    ++scoredDeployer.score;
                }
            }
            Comparator<ScoredDeployer> comparator = new Comparator<ScoredDeployer>(){

                @Override
                public int compare(ScoredDeployer o1, ScoredDeployer o2) {
                    int relation = o1.score - o2.score;
                    if (relation == 0) {
                        relation = Ordered.COMPARATOR.compare(o1.deployer, o2.deployer);
                    }
                    return relation;
                }
            };
            Collections.sort(scoredDeployers, comparator);
            for (int i = 1; i < scoredDeployers.size(); ++i) {
                Set<Edge> edges = edgeCache.get(((ScoredDeployer)scoredDeployers.get((int)i)).deployer);
                edges.add(new Edge(((ScoredDeployer)scoredDeployers.get((int)0)).deployer, input, ((ScoredDeployer)scoredDeployers.get((int)i)).deployer));
            }
            Deployer deployer = ((ScoredDeployer)scoredDeployers.get((int)0)).deployer;
            if (!edgeCache.get(deployer).isEmpty() || s.contains(deployer)) continue;
            s.add(deployer);
        }
    }

    @Override
    public List<Deployer> sortDeployers(List<Deployer> original, Deployer newDeployer) {
        ArrayList<Deployer> result = new ArrayList<Deployer>();
        ArrayList<Deployer> s = new ArrayList<Deployer>();
        HashMap<String, Collection<Deployer>> inputCache = new HashMap<String, Collection<Deployer>>();
        IdentityHashMap<Deployer, Set<Edge>> edgeCache = new IdentityHashMap<Deployer, Set<Edge>>();
        HashSet<String> outputs = new HashSet<String>();
        HashMap<String, Collection<Deployer>> outputCache = new HashMap<String, Collection<Deployer>>();
        for (Deployer deployer : original) {
            this.process(deployer, s, inputCache, edgeCache, outputs, outputCache);
        }
        this.process(newDeployer, s, inputCache, edgeCache, outputs, outputCache);
        this.processTransientDeployers(s, inputCache, outputCache, edgeCache);
        Collections.sort(s, Ordered.COMPARATOR);
        while (!s.isEmpty()) {
            Deployer deployer = (Deployer)s.remove(0);
            result.add(deployer);
            TreeSet<Deployer> nextLevel = new TreeSet<Deployer>(Ordered.COMPARATOR);
            for (Edge e : this.findInputs(edgeCache, deployer, inputCache, deployer.getOutputs())) {
                Set edges = (Set)edgeCache.get(e.to);
                edges.remove(e);
                if (!edges.isEmpty()) continue;
                nextLevel.add(e.to);
            }
            s.addAll(nextLevel);
        }
        String message = "";
        for (Set edges : edgeCache.values()) {
            if (edges.isEmpty()) continue;
            message = message + "edges: " + edges;
        }
        if (message.length() > 0) {
            throw new IllegalStateException(message);
        }
        assert (result.size() == original.size() + 1) : "not all deployers made it";
        return result;
    }

    private static class ScoredDeployer {
        Deployer deployer;
        int score;

        ScoredDeployer(Deployer deployer) {
            this.deployer = deployer;
            this.score = deployer.getRelativeOrder();
        }

        public String toString() {
            return "ScoredDeployer{deployer=" + this.deployer + ", score=" + this.score + '}';
        }
    }

    private static class Edge {
        Deployer from;
        String input;
        Deployer to;

        Edge(Deployer from, String input, Deployer to) {
            if (from.equals(to)) {
                throw new IllegalArgumentException("cyclic edge");
            }
            this.from = from;
            this.input = input;
            this.to = to;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Edge edge = (Edge)o;
            if (this.from != null ? !this.from.equals(edge.from) : edge.from != null) {
                return false;
            }
            if (!this.input.equals(edge.input)) {
                return false;
            }
            return this.to.equals(edge.to);
        }

        public int hashCode() {
            int result = this.from != null ? this.from.hashCode() : 0;
            result = 31 * result + this.input.hashCode();
            result = 31 * result + this.to.hashCode();
            return result;
        }

        public String toString() {
            return "Edge{from=" + this.from + ", input='" + this.input + '\'' + ", to=" + this.to + '}';
        }
    }
}

