/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.classloading;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.classloader.spi.ClassLoaderPolicy;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.dependency.policy.ClassLoaderPolicyModule;
import org.jboss.classloading.spi.metadata.ClassLoadingTranslatorMetaData;
import org.jboss.classloading.spi.metadata.ClassLoadingTranslatorsMetaData;
import org.jboss.classloading.spi.metadata.TranslatorScope;
import org.jboss.classloading.spi.metadata.helpers.ReflectionTranslator;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.spi.deployer.helpers.AttachmentLocator;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.util.loading.Translator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractTranslatorsDeployer
extends AbstractSimpleRealDeployer<ClassLoadingTranslatorsMetaData> {
    public static final String TRANSLATORS_KEY = "TRANSLATORS_KEY";
    private ClassLoaderSystem system;

    public AbstractTranslatorsDeployer() {
        super(ClassLoadingTranslatorsMetaData.class);
        this.addInput(ClassLoader.class);
        this.addOutput(Translator.class);
        this.setStage(DeploymentStages.CLASSLOADER);
    }

    public void create() {
        if (this.system == null) {
            throw new IllegalStateException("The system has not been set");
        }
    }

    public void deploy(DeploymentUnit unit, ClassLoadingTranslatorsMetaData deployment) throws DeploymentException {
        Module module = (Module)AttachmentLocator.searchAncestors((DeploymentUnit)unit, Module.class);
        if (module == null || !(module instanceof ClassLoaderPolicyModule)) {
            return;
        }
        HashMap<Translator, TranslatorScope> added = new HashMap<Translator, TranslatorScope>();
        try {
            List translators = deployment.getTranslators();
            if (translators != null) {
                ClassLoaderPolicyModule clpm = (ClassLoaderPolicyModule)module;
                ClassLoaderDomain domain = this.system.getDomain(module.getDeterminedDomainName());
                ClassLoaderPolicy policy = clpm.getPolicy();
                ClassLoader cl = unit.getClassLoader();
                for (ClassLoadingTranslatorMetaData cltmd : translators) {
                    TranslatorScope scope = cltmd.getScope();
                    if (scope == null) {
                        throw new IllegalArgumentException("Null scope for: " + cltmd);
                    }
                    String className = cltmd.getClassName();
                    Object instance = cl.loadClass(className).newInstance();
                    String methodName = cltmd.getMethod();
                    Object translator = methodName != null ? new ReflectionTranslator(instance, methodName) : (Translator)Translator.class.cast(instance);
                    scope.addTranslator(this.system, domain, policy, translator);
                    added.put((Translator)translator, scope);
                }
                unit.addAttachment(TRANSLATORS_KEY, added);
            }
        }
        catch (Exception e) {
            ClassLoaderPolicyModule clpm = (ClassLoaderPolicyModule)module;
            ClassLoaderDomain domain = this.system.getDomain(module.getDeterminedDomainName());
            ClassLoaderPolicy policy = clpm.getPolicy();
            for (Map.Entry entry : added.entrySet()) {
                ((TranslatorScope)entry.getValue()).removeTranslator(this.system, domain, policy, (Translator)entry.getKey());
            }
            throw DeploymentException.rethrowAsDeploymentException((String)"Error adding translators.", (Throwable)e);
        }
    }

    public void undeploy(DeploymentUnit unit, ClassLoadingTranslatorsMetaData deployment) {
        Module module = (Module)AttachmentLocator.searchAncestors((DeploymentUnit)unit, Module.class);
        if (module == null || !(module instanceof ClassLoaderPolicyModule)) {
            return;
        }
        Map added = (Map)unit.getAttachment(TRANSLATORS_KEY, Map.class);
        if (added != null) {
            ClassLoaderPolicyModule clpm = (ClassLoaderPolicyModule)module;
            ClassLoaderDomain domain = this.system.getDomain(module.getDeterminedDomainName());
            ClassLoaderPolicy policy = clpm.getPolicy();
            for (Map.Entry entry : added.entrySet()) {
                ((TranslatorScope)entry.getValue()).removeTranslator(this.system, domain, policy, (Translator)entry.getKey());
            }
        }
    }

    public ClassLoaderSystem getSystem() {
        return this.system;
    }

    public void setSystem(ClassLoaderSystem system) {
        this.system = system;
    }
}

