/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.classloading;

import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.classloading.spi.visitor.ResourceVisitor;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractResourceVisitorDeployer
extends AbstractSimpleRealDeployer<Module> {
    private ResourceVisitor visitor;
    private ResourceFilter filter;

    public AbstractResourceVisitorDeployer() {
        super(Module.class);
        this.setStage(DeploymentStages.POST_CLASSLOADER);
    }

    public AbstractResourceVisitorDeployer(ResourceVisitor visitor) {
        this();
        this.visitor = visitor;
    }

    public AbstractResourceVisitorDeployer(ResourceVisitor visitor, ResourceFilter filter) {
        this(visitor);
        this.filter = filter;
    }

    public void deploy(DeploymentUnit unit, Module module) throws DeploymentException {
        ResourceFilter currentFilter;
        ResourceVisitor currentVisitor = this.visitor;
        if (currentVisitor == null) {
            currentVisitor = this.createVisitor(unit);
        }
        if ((currentFilter = this.filter) == null) {
            currentFilter = this.createFilter(unit);
        }
        if (currentFilter != null) {
            module.visit(currentVisitor, currentFilter);
        } else {
            module.visit(currentVisitor);
        }
    }

    protected ResourceVisitor createVisitor(DeploymentUnit unit) {
        throw new UnsupportedOperationException("Missing resource visitor");
    }

    protected ResourceFilter createFilter(DeploymentUnit unit) {
        return null;
    }
}

