/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.annotations;

import java.lang.ref.WeakReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class WeakClassLoaderHolder {
    private transient WeakReference<ClassLoader> clRef;

    public WeakClassLoaderHolder(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException("Null classloader");
        }
        this.clRef = new WeakReference<ClassLoader>(classLoader);
    }

    protected ClassLoader getClassLoader() {
        if (this.clRef == null) {
            throw new IllegalArgumentException("Null classloader ref, previously serialized?");
        }
        ClassLoader classLoader = (ClassLoader)this.clRef.get();
        if (classLoader == null) {
            throw new IllegalArgumentException("ClassLoader was already garbage collected.");
        }
        return classLoader;
    }

    protected Class<?> loadClass(String className) {
        try {
            return Class.forName(className, false, this.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

