/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.annotations;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMember;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.jboss.classloading.spi.visitor.ClassFilter;
import org.jboss.classloading.spi.visitor.ResourceContext;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.classloading.spi.visitor.ResourceVisitor;
import org.jboss.deployers.plugins.annotations.DefaultAnnotationEnvironment;
import org.jboss.deployers.spi.annotations.AnnotationEnvironment;
import org.jboss.logging.Logger;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.metadata.spi.signature.javassist.JavassistConstructorParametersSignature;
import org.jboss.metadata.spi.signature.javassist.JavassistMethodParametersSignature;
import org.jboss.metadata.spi.signature.javassist.JavassistSignatureFactory;

public class GenericAnnotationResourceVisitor
implements ResourceVisitor {
    private static final Logger log = Logger.getLogger(GenericAnnotationResourceVisitor.class);
    private ClassPool pool;
    private boolean forceAnnotations;
    private DefaultAnnotationEnvironment env;
    private CtClass objectCtClass;

    public GenericAnnotationResourceVisitor(ClassLoader classLoader) {
        this(ClassPool.getDefault(), classLoader);
    }

    public GenericAnnotationResourceVisitor(ClassPool pool, ClassLoader classLoader) {
        if (pool == null) {
            throw new IllegalArgumentException("Null pool");
        }
        if (classLoader == null) {
            throw new IllegalArgumentException("Null classloader");
        }
        this.pool = pool;
        this.env = new DefaultAnnotationEnvironment(classLoader);
        this.objectCtClass = pool.makeClass(Object.class.getName());
    }

    public ResourceFilter getFilter() {
        return ClassFilter.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(ResourceContext resource) {
        try {
            CtClass ctClass = this.pool.makeClass(resource.getInputStream());
            try {
                this.handleCtClass(ctClass, resource);
            }
            finally {
                ctClass.detach();
            }
        }
        catch (ClassNotFoundException e) {
            if (this.forceAnnotations) {
                throw new RuntimeException(e);
            }
            this.logThrowable(resource, e);
        }
        catch (Throwable t) {
            this.logThrowable(resource, t);
        }
    }

    protected void logThrowable(ResourceContext resource, Throwable t) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Exception reading resource: " + resource.getResourceName()), t);
        }
    }

    protected void handleCtClass(CtClass ctClass, ResourceContext resource) throws ClassNotFoundException, NotFoundException {
        if (ctClass == null || this.objectCtClass.equals(ctClass)) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Scanning class " + ctClass + " for annotations, resource url: " + resource.getUrl()));
        }
        Object[] annotations = this.forceAnnotations ? ctClass.getAnnotations() : ctClass.getAvailableAnnotations();
        this.handleAnnotations(ElementType.TYPE, (Signature)null, annotations, resource);
        this.handleCtMembers(ElementType.CONSTRUCTOR, (CtMember[])ctClass.getDeclaredConstructors(), resource);
        this.handleCtMembers(ElementType.METHOD, (CtMember[])ctClass.getDeclaredMethods(), resource);
        this.handleCtMembers(ElementType.FIELD, (CtMember[])ctClass.getDeclaredFields(), resource);
        CtClass[] interfaces = ctClass.getInterfaces();
        if (interfaces != null && interfaces.length > 0) {
            for (CtClass intf : interfaces) {
                this.handleCtClass(intf, resource);
            }
        }
        this.handleCtClass(ctClass.getSuperclass(), resource);
    }

    protected void handleCtMembers(ElementType type, CtMember[] members, ResourceContext resource) throws ClassNotFoundException {
        if (members != null && members.length > 0) {
            for (CtMember member : members) {
                Object[] annotations = this.forceAnnotations ? member.getAnnotations() : member.getAvailableAnnotations();
                this.handleAnnotations(type, member, annotations, resource);
                if (!(member instanceof CtBehavior)) continue;
                CtBehavior behavior = (CtBehavior)member;
                Object[][] paramAnnotations = this.forceAnnotations ? behavior.getParameterAnnotations() : behavior.getAvailableParameterAnnotations();
                for (int index = 0; index < paramAnnotations.length; ++index) {
                    this.handleAnnotations(ElementType.PARAMETER, this.getBehaviorSignature(behavior, index), paramAnnotations[index], resource);
                }
            }
        }
    }

    protected Signature getBehaviorSignature(CtBehavior behavior, int index) throws ClassNotFoundException {
        try {
            if (behavior instanceof CtConstructor) {
                return new JavassistConstructorParametersSignature((CtConstructor)behavior, index);
            }
            if (behavior instanceof CtMethod) {
                return new JavassistMethodParametersSignature((CtMethod)behavior, index);
            }
            throw new IllegalArgumentException("Unknown ct behavior: " + behavior);
        }
        catch (NotFoundException e) {
            throw new ClassNotFoundException("Exception creating signature: " + behavior, e);
        }
    }

    protected void handleAnnotations(ElementType type, CtMember member, Object[] annotations, ResourceContext resource) {
        Signature signature = null;
        if (member != null) {
            signature = JavassistSignatureFactory.getSignature((CtMember)member);
        }
        this.handleAnnotations(type, signature, annotations, resource);
    }

    protected void handleAnnotations(ElementType type, Signature signature, Object[] annotations, ResourceContext resource) {
        if (annotations != null && annotations.length > 0) {
            for (Object annObject : annotations) {
                Annotation annotation = (Annotation)Annotation.class.cast(annObject);
                this.env.putAnnotation(annotation.annotationType(), type, resource.getClassName(), signature);
            }
        }
    }

    public void setForceAnnotations(boolean forceAnnotations) {
        this.forceAnnotations = forceAnnotations;
    }

    public AnnotationEnvironment getEnv() {
        return this.env;
    }
}

