/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.annotations;

import org.jboss.metadata.spi.signature.Signature;
import org.jboss.util.JBossObject;

public class ClassSignaturePair
extends JBossObject {
    private String className;
    private Signature signature;

    public ClassSignaturePair(String className, Signature signature) {
        if (className == null) {
            throw new IllegalArgumentException("Null class name");
        }
        this.className = className;
        this.signature = signature;
    }

    public String getClassName() {
        return this.className;
    }

    public Signature getSignature() {
        return this.signature;
    }

    protected int getHashCode() {
        int hash = this.className.hashCode();
        if (this.signature != null) {
            hash += 7 * this.signature.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ClassSignaturePair)) {
            return false;
        }
        ClassSignaturePair csPair = (ClassSignaturePair)((Object)obj);
        if (this.className.equals(csPair.getClassName())) {
            return ClassSignaturePair.equals((Object)this.signature, (Object)csPair.getSignature());
        }
        return false;
    }
}

