/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.security;

import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.jboss.dashboard.security.DefaultPermission;

final class DefaultPermissionCollection
extends PermissionCollection
implements Serializable {
    private Hashtable permissionMap = new Hashtable(11);
    private Vector permissionList = new Vector();

    @Override
    public void add(Permission permission) {
        if (!(permission instanceof DefaultPermission)) {
            throw new IllegalArgumentException("Invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("Attempt to add a Permission to a readonly PermissionCollection");
        }
        DefaultPermission bp = (DefaultPermission)permission;
        if (!this.permissionMap.containsKey(bp.getName())) {
            this.permissionMap.put(bp.getName(), new Vector());
        }
        Vector permInstances = (Vector)this.permissionMap.get(bp.getName());
        this.addPermissionToVector(permInstances, permission);
        this.addPermissionToVector(this.permissionList, permission);
    }

    private boolean addPermissionToVector(Vector list, Permission permission) {
        return list.add(permission);
    }

    @Override
    public boolean implies(Permission permission) {
        try {
            DefaultPermission dp = (DefaultPermission)permission;
            for (DefaultPermission simplePerm : dp.toSimplePermissionList()) {
                int result = this.impliesOrDenies(simplePerm);
                if (result == -1) {
                    return false;
                }
                if (result != 0) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    private int impliesOrDenies(DefaultPermission simplePerm) {
        int last;
        String path = simplePerm.getName();
        int result = this.impliesOrDenies(simplePerm, path);
        if (result == -1) {
            return -1;
        }
        if (result == 1) {
            return 1;
        }
        int offset = path.length() - 1;
        while ((last = path.lastIndexOf(".", offset)) != -1) {
            result = this.impliesOrDenies(simplePerm, path = path.substring(0, last + 1) + "*");
            if (result == -1) {
                return -1;
            }
            if (result == 1) {
                return 1;
            }
            offset = last - 1;
        }
        result = this.impliesOrDenies(simplePerm, "*");
        if (result == -1) {
            return -1;
        }
        if (result == 1) {
            return 1;
        }
        return 0;
    }

    private int impliesOrDenies(DefaultPermission simplePerm, String path) {
        List permInstances = (List)this.permissionMap.get(path);
        if (permInstances == null) {
            return 0;
        }
        boolean permissionGranted = false;
        for (DefaultPermission x : permInstances) {
            if (x == null) continue;
            int result = x.impliesOrDenies(simplePerm);
            if (result == -1) {
                return -1;
            }
            if (result != 1) continue;
            permissionGranted = true;
        }
        if (permissionGranted) {
            return 1;
        }
        return 0;
    }

    public Enumeration elements() {
        return this.permissionList.elements();
    }
}

