/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.security;

import java.lang.reflect.Constructor;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.jboss.dashboard.security.BasicPermissionImpl;
import org.jboss.dashboard.security.DefaultPermissionCollection;

public class DefaultPermission
extends Permission {
    public static final int PERMISSION_GRANTED = 1;
    public static final int PERMISSION_NOT_GRANTED = 0;
    public static final int PERMISSION_DENIED = -1;
    private Permission basicPerm;
    private List<String> actionGrantedList;
    private List<String> actionDeniedList;
    private BasicPermission lnkBasicPermission;

    public DefaultPermission(String resourceName, String actions) {
        super(resourceName);
        this.basicPerm = new BasicPermissionImpl(resourceName);
        this.actionGrantedList = new ArrayList<String>();
        this.actionDeniedList = new ArrayList<String>();
        this.setActions(actions);
    }

    public void setResourceName(String resourceName) {
        this.basicPerm = new BasicPermissionImpl(resourceName);
    }

    public String getResourcePath() {
        if (this.basicPerm == null) {
            return "";
        }
        return this.basicPerm.getName();
    }

    public void setActions(String actions) {
        if (actions == null) {
            return;
        }
        this.actionGrantedList = this.toActionGrantedList(actions);
        this.actionDeniedList = this.toActionDeniedList(actions);
    }

    public void grantAction(String action) {
        if (!this.actionGrantedList.contains(action)) {
            this.actionGrantedList.add(action);
        }
        this.actionDeniedList.remove(action);
    }

    public void denyAction(String action) {
        if (!this.actionDeniedList.contains(action)) {
            this.actionDeniedList.add(action);
        }
        this.actionGrantedList.remove(action);
    }

    public void removeAction(String action) {
        this.actionGrantedList.remove(action);
        this.actionDeniedList.remove(action);
    }

    public boolean isActionGranted(String action) {
        return this.actionGrantedList.contains(action);
    }

    public boolean isActionDenied(String action) {
        return this.actionDeniedList.contains(action);
    }

    public boolean isActionUndefined(String action) {
        return !this.actionGrantedList.contains(action) && !this.actionDeniedList.contains(action);
    }

    public boolean isEmpty() {
        return this.actionGrantedList.isEmpty() && this.actionDeniedList.isEmpty();
    }

    public int impliesOrDenies(Permission p) {
        if (p == null || !(p instanceof DefaultPermission)) {
            return 0;
        }
        DefaultPermission that = (DefaultPermission)p;
        if (!this.basicPerm.implies(that.basicPerm)) {
            return 0;
        }
        for (String thatAction : that.actionGrantedList) {
            if (this.isActionDenied(thatAction)) {
                return -1;
            }
            if (!this.isActionUndefined(thatAction)) continue;
            return 0;
        }
        for (String thatAction : that.actionDeniedList) {
            if (this.isActionGranted(thatAction)) {
                return -1;
            }
            if (!this.isActionUndefined(thatAction)) continue;
            return 0;
        }
        return 1;
    }

    @Override
    public boolean implies(Permission p) {
        switch (this.impliesOrDenies(p)) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new DefaultPermissionCollection();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultPermission bp = (DefaultPermission)obj;
        return this.getName().equals(bp.getName());
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public String getActions() {
        return this.toActionListString();
    }

    protected String toActionListString() {
        StringBuffer buf = new StringBuffer();
        for (String action : this.actionGrantedList) {
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append(action);
        }
        for (String action : this.actionDeniedList) {
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append("!").append(action);
        }
        return buf.toString();
    }

    protected List<String> toActionGrantedList(String actionsString) {
        ArrayList<String> l = new ArrayList<String>();
        StringTokenizer strtok = new StringTokenizer(actionsString, ",");
        while (strtok.hasMoreTokens()) {
            String action = strtok.nextToken().trim();
            if (action.startsWith("!")) continue;
            l.add(action);
        }
        return l;
    }

    protected List<String> toActionDeniedList(String actionsString) {
        ArrayList<String> l = new ArrayList<String>();
        StringTokenizer strtok = new StringTokenizer(actionsString, ",");
        while (strtok.hasMoreTokens()) {
            String action = strtok.nextToken().trim();
            if (!action.startsWith("!")) continue;
            l.add(action.substring(1));
        }
        return l;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + " " + this.getName() + " " + this.toActionListString();
    }

    List<DefaultPermission> toSimplePermissionList() {
        ArrayList<DefaultPermission> l = new ArrayList<DefaultPermission>();
        try {
            DefaultPermission dp;
            Constructor<?> constr;
            for (String action : this.actionGrantedList) {
                constr = this.getClass().getConstructors()[0];
                dp = (DefaultPermission)constr.newInstance(this.getName(), null);
                dp.grantAction(action);
                l.add(dp);
            }
            for (String action : this.actionDeniedList) {
                constr = this.getClass().getConstructors()[0];
                dp = (DefaultPermission)constr.newInstance(this.getName(), null);
                dp.denyAction(action);
                l.add(dp);
            }
        }
        catch (Exception e) {
            System.out.println("Can't split permission into a simple permission list.");
            System.out.println("Empty permission list is returned and full access is gained.");
            e.printStackTrace();
        }
        return l;
    }
}

