/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.profiler;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.jboss.dashboard.profiler.CodeBlockTrace;
import org.jboss.dashboard.profiler.CodeBlockTraces;
import org.jboss.dashboard.profiler.StackTrace;

public class TimeTrace
extends StackTrace {
    protected TimeTrace parent = null;
    protected List<StackTrace> stackTraces;
    protected List<TimeTrace> children;
    protected CodeBlockTraces codeBlockTraces = new CodeBlockTraces();
    protected int level = 0;

    public TimeTrace(StackTraceElement[] stackTrace, List<StackTrace> samples, List<TimeTrace> children, CodeBlockTrace context) {
        super(stackTrace, context);
        this.setStackTraces(samples);
        this.setChildren(children);
    }

    public TimeTrace getParent() {
        return this.parent;
    }

    public void setParent(TimeTrace parent) {
        this.parent = parent;
    }

    public List<TimeTrace> getChildren() {
        return this.children;
    }

    public void setChildren(List<TimeTrace> children) {
        this.children = children;
        for (TimeTrace child : children) {
            child.setParent(this);
            child.setLevel(this.level + 1);
        }
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public List<StackTrace> getStackTraces() {
        return this.stackTraces;
    }

    public void setStackTraces(List<StackTrace> stackTraces) {
        this.stackTraces = stackTraces;
    }

    public CodeBlockTraces getCodeBlockTraces() {
        return this.codeBlockTraces;
    }

    public long getBeginTimeMillis() {
        StackTrace first = this.stackTraces.get(0);
        return first.getCreationTimeMillis();
    }

    public long getEndTimeMillis() {
        StackTrace last = this.stackTraces.get(this.stackTraces.size() - 1);
        return last.getCreationTimeMillis();
    }

    public long getElapsedTimeMillis() {
        return this.getEndTimeMillis() - this.getBeginTimeMillis();
    }

    public long getSampleAverageTimeMillis() {
        return this.getElapsedTimeMillis() / (long)this.stackTraces.size();
    }

    public long getSelfTimeMillis() {
        long total = this.getElapsedTimeMillis();
        for (TimeTrace child : this.children) {
            total -= child.getElapsedTimeMillis();
        }
        return total;
    }

    public String printChildStackTrace() {
        if (this.parent == null) {
            return this.printStackTrace();
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println(this.stackTrace[0]);
        int shortLength = this.length() - this.parent.length();
        for (int i = 1; i <= shortLength; ++i) {
            StackTraceElement trace = this.stackTrace[i];
            pw.println("\tat " + trace);
        }
        pw.println("\t(... see the parent's stack trace)");
        return sw.toString();
    }
}

