/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.cachemanager;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.parsing.CacheConfigsXmlParser;
import org.jboss.cache.config.parsing.RootElementBuilder;
import org.jboss.cache.config.parsing.XmlConfigurationParser;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CacheConfigsParser
extends CacheConfigsXmlParser {
    CacheConfigsParser() {
    }

    public Map<String, Configuration> parseConfigs(InputStream stream, String fileName) throws CloneNotSupportedException {
        Element root = this.getDocumentRoot(stream);
        NodeList list = root.getElementsByTagName("cache-config");
        if (!(list != null && list.getLength() != 0 || (list = root.getElementsByTagName("registry:cache-config")) != null && list.getLength() != 0)) {
            throw new ConfigurationException("Can't find cache-config or registry:cache-config tag");
        }
        HashMap<String, Configuration> result = new HashMap<String, Configuration>();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String name = element.getAttribute("name");
            if (name == null || name.trim().length() == 0) {
                throw new ConfigurationException("Element " + element + " has no name attribute");
            }
            XmlConfigurationParser parser = new XmlConfigurationParser();
            Configuration c = parser.parseElementIgnoringRoot(element);
            c = c.clone();
            result.put(name.trim(), c);
        }
        return result;
    }

    private Element getDocumentRoot(InputStream stream) {
        RootElementBuilder rootElementBuilder = new RootElementBuilder(false);
        return rootElementBuilder.readRoot(stream);
    }
}

