/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.remoting;

import java.util.ArrayList;
import java.util.Map;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aspects.remoting.ClusterConstants;
import org.jboss.ha.framework.server.HATarget;

public class ReplicantsManagerInterceptor
implements Interceptor,
ClusterConstants {
    private final Map families;

    public ReplicantsManagerInterceptor(Map families) {
        this.families = families;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Object response = invocation.invokeNext();
        String clientFamily = (String)invocation.getMetaData((Object)"CLUSTERED_REMOTING", (Object)"CLUSTER_FAMILY");
        HATarget target = (HATarget)this.families.get(clientFamily);
        if (target == null) {
            return response;
        }
        Long clientViewId = (Long)invocation.getMetaData((Object)"CLUSTERED_REMOTING", (Object)"CLUSTER_VIEW_ID");
        if (clientViewId == null) {
            return response;
        }
        if (clientViewId.longValue() != target.getCurrentViewId()) {
            invocation.addResponseAttachment((Object)"replicants", new ArrayList(target.getReplicants()));
            invocation.addResponseAttachment((Object)"viewId", (Object)new Long(target.getCurrentViewId()));
        }
        return response;
    }
}

