/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.persistence;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanInfo;
import org.jboss.mx.modelmbean.ModelMBeanInvoker;
import org.jboss.mx.modelmbean.RequiredModelMBeanInstantiator;
import org.jboss.mx.persistence.MBeanInfoOdb;
import org.jboss.mx.persistence.PersistenceManager;
import org.jboss.mx.server.registry.MbeanInfoDb;

public class MbeanInfoDbPm
extends MBeanInfoOdb
implements PersistenceManager {
    protected boolean fLoadedFromFs;
    protected Vector fNamesToRestore;
    protected Vector fInfosToRestore;
    protected MBeanServer fMbeanServer;
    protected MbeanInfoDb fMbeanInfoDb;
    protected File fMbiDbRoot;

    public void load(ModelMBeanInvoker mbean, MBeanInfo info) throws MBeanException {
        this.logger().debug("Loading the MBI DB");
        this.setMbeanInfoDb((MbeanInfoDb)mbean.getResource());
        if (!this.loadedFromFs()) {
            Descriptor d = ((ModelMBeanInfo)((Object)info)).getMBeanDescriptor();
            String dir = (String)d.getFieldValue("persistLocation");
            if (dir != null && !dir.equals("")) {
                this.setMbiDbRoot(new File(dir));
            }
            String message = "Loading the MBI DB from the filesystem.  location: ";
            message = message + this.mbiDbRoot();
            this.logger().debug(message);
            File[] mbiFiles = this.mbiDbRoot().listFiles();
            if (mbiFiles == null) {
                return;
            }
            for (int index = 0; index < mbiFiles.length; ++index) {
                File curFile = mbiFiles[index];
                ObjectName nameToRestore = null;
                try {
                    nameToRestore = this.objectName(curFile);
                }
                catch (MalformedObjectNameException cause) {
                    throw new MBeanException(cause, "Object Name was stored incorrectly.");
                }
                MBeanInfo infoToRestore = null;
                try {
                    infoToRestore = this.load(curFile);
                }
                catch (IOException cause) {
                    throw new MBeanException(cause, "Couldn't read the MBeanInfo file.");
                }
                catch (ClassNotFoundException cause2) {
                    String message2 = "Couldn't find the Class specified in the object file.";
                    throw new MBeanException(cause2, message2);
                }
                if (infoToRestore == null) {
                    throw new MBeanException(new Exception("Null loaded MBean info.  Error on load."), "Could not load");
                }
                this.namesToRestore().add(nameToRestore);
                this.infosToRestore().add(infoToRestore);
            }
            this.setLoadedFromFs(true);
        }
        try {
            this.register();
        }
        catch (Exception cause) {
            throw new MBeanException(cause, "Error trying to register loaded MBeans");
        }
    }

    public void store(MBeanInfo info) throws MBeanException {
        this.logger().debug("storing MBI DB State");
        Enumeration queue = this.mbeanInfoDb().mbiPersistenceQueue();
        while (queue.hasMoreElements()) {
            ObjectName curName = (ObjectName)queue.nextElement();
            this.logger().debug("queue elem: " + curName);
            MBeanInfo curInfo = null;
            try {
                curInfo = this.getMBeanServer().getMBeanInfo(curName);
            }
            catch (InstanceNotFoundException cause) {
                throw new MBeanException(cause);
            }
            catch (JMException cause3) {
                throw new MBeanException(cause3);
            }
            if (curInfo == null) {
                throw new MBeanException(new Exception("Current MBean Info object is null."), "Could not store null object.");
            }
            try {
                this.store(curName, curInfo);
            }
            catch (IOException cause2) {
                throw new MBeanException(cause2);
            }
            this.mbeanInfoDb().removeFromMbiQueue(curName);
            this.logger().info("Successfully stored mbi for " + curName);
        }
    }

    protected void store(ObjectName name, MBeanInfo info) throws IOException {
        File location = new File(this.mbiDbRoot(), this.fileName(name));
        this.logger().debug("Storing mbi at: " + location);
        this.mbiDbRoot().mkdirs();
        this.store(info, location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void register() throws JMException, InvalidTargetObjectTypeException {
        this.logger().debug("registering...");
        Enumeration names = this.namesToRestore().elements();
        Enumeration infos = this.infosToRestore().elements();
        try {
            while (names.hasMoreElements() && infos.hasMoreElements()) {
                ObjectName curName = (ObjectName)names.nextElement();
                this.logger().debug("curName: " + curName);
                ModelMBeanInfo curInfo = (ModelMBeanInfo)infos.nextElement();
                Descriptor mbeanDescriptor = curInfo.getMBeanDescriptor();
                String fieldName = "resourceClass";
                String className = (String)mbeanDescriptor.getFieldValue(fieldName);
                this.logger().debug("className: " + className);
                Object resource = this.getMBeanServer().instantiate(className);
                ModelMBean modelmbean = RequiredModelMBeanInstantiator.instantiate();
                modelmbean.setModelMBeanInfo(curInfo);
                modelmbean.setManagedResource(resource, "ObjectReference");
                this.getMBeanServer().registerMBean(modelmbean, curName);
            }
            Object var11_10 = null;
            this.namesToRestore().removeAllElements();
            this.infosToRestore().removeAllElements();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.namesToRestore().removeAllElements();
            this.infosToRestore().removeAllElements();
            throw throwable;
        }
    }

    protected MBeanServer getMBeanServer() throws JMException {
        if (this.fMbeanServer == null) {
            ArrayList col = MBeanServerFactory.findMBeanServer(null);
            if (col.isEmpty()) {
                throw new JMException("No MBeanServer found");
            }
            this.fMbeanServer = (MBeanServer)col.iterator().next();
        }
        return this.fMbeanServer;
    }

    protected String replaceAll(String object, String target, String replacement) {
        return this.replaceAll(object, target, replacement, 0);
    }

    protected String replaceAll(String object, String target, String replacement, int curIndex) {
        int indexOfMatch = object.indexOf(target, curIndex);
        if (indexOfMatch < curIndex) {
            return object;
        }
        String prefix = "";
        if (indexOfMatch > 0) {
            prefix = object.substring(0, indexOfMatch);
        }
        String tail = object.substring(indexOfMatch + target.length());
        String newObject = prefix + replacement + tail;
        return this.replaceAll(newObject, target, replacement, indexOfMatch + replacement.length());
    }

    protected String objNameSeparator() {
        return ":";
    }

    protected String objNameSepRep() {
        return "___";
    }

    protected String fileName(ObjectName name) {
        String fileName = name.getCanonicalName();
        fileName = this.replaceAll(fileName, this.objNameSeparator(), this.objNameSepRep());
        return fileName;
    }

    protected ObjectName objectName(File fileName) throws MalformedObjectNameException {
        String objectName = fileName.getName();
        objectName = this.replaceAll(objectName, this.objNameSepRep(), this.objNameSeparator());
        return new ObjectName(objectName);
    }

    protected boolean loadedFromFs() {
        return this.fLoadedFromFs;
    }

    protected void setLoadedFromFs(boolean newLoadedFromFs) {
        this.fLoadedFromFs = newLoadedFromFs;
    }

    protected Vector namesToRestore() {
        if (this.fNamesToRestore == null) {
            this.fNamesToRestore = new Vector(10);
        }
        return this.fNamesToRestore;
    }

    protected Vector infosToRestore() {
        if (this.fInfosToRestore == null) {
            this.fInfosToRestore = new Vector(10);
        }
        return this.fInfosToRestore;
    }

    protected File mbiDbRoot() {
        if (this.fMbiDbRoot == null) {
            this.fMbiDbRoot = new File("../conf/mbean-info-db/");
        }
        return this.fMbiDbRoot;
    }

    protected void setMbiDbRoot(File newMbiDbRoot) {
        this.fMbiDbRoot = newMbiDbRoot;
    }

    protected MbeanInfoDb mbeanInfoDb() {
        return this.fMbeanInfoDb;
    }

    protected void setMbeanInfoDb(MbeanInfoDb newMbeanInfoDb) {
        this.fMbeanInfoDb = newMbeanInfoDb;
    }
}

