/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.injection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.Context;
import javax.xml.ws.WebServiceRef;
import javax.xml.ws.WebServiceRefs;
import org.jboss.injection.InjectionContainer;
import org.jboss.injection.InjectionHandler;
import org.jboss.injection.InjectionUtil;
import org.jboss.injection.Injector;
import org.jboss.injection.JndiFieldInjector;
import org.jboss.injection.JndiMethodInjector;
import org.jboss.injection.WebServiceRefInjector;
import org.jboss.logging.Logger;
import org.jboss.metadata.serviceref.ServiceRefDelegate;
import org.jboss.metamodel.descriptor.EnvironmentRefGroup;
import org.jboss.wsf.spi.serviceref.ServiceRefMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceRefHandler
implements InjectionHandler {
    private static final Logger log = Logger.getLogger(WebServiceRefHandler.class);
    private Map<String, ServiceRefMetaData> srefMap = new HashMap<String, ServiceRefMetaData>();

    @Override
    public void loadXml(EnvironmentRefGroup xml, InjectionContainer container) {
        if (xml == null) {
            return;
        }
        if (xml.getServiceRefs() == null) {
            return;
        }
        for (ServiceRefMetaData sref : xml.getServiceRefs()) {
            log.debug("@WebServiceRef override: " + sref);
            if (this.srefMap.get(sref.getServiceRefName()) != null) {
                throw new IllegalStateException("Duplicate <service-ref-name> in " + sref);
            }
            this.srefMap.put(sref.getServiceRefName(), sref);
        }
    }

    @Override
    public void handleClassAnnotations(Class type, InjectionContainer container) {
        WebServiceRefs refs;
        WebServiceRef wsref = container.getAnnotation(WebServiceRef.class, type);
        if (wsref != null) {
            this.bindRefOnType(type, container, wsref);
        }
        if ((refs = container.getAnnotation(WebServiceRefs.class, type)) != null) {
            for (WebServiceRef refItem : refs.value()) {
                this.bindRefOnType(type, container, refItem);
            }
        }
    }

    private void bindRefOnType(Class type, InjectionContainer container, WebServiceRef wsref) {
        String name = wsref.name();
        if (name.equals("")) {
            name = InjectionUtil.getEncName(type).substring(4);
        }
        if (!container.getEncInjectors().containsKey(name)) {
            String encName = "env/" + name;
            ServiceRefMetaData sref = this.getServiceRefForName(name);
            container.getEncInjectors().put(name, new WebServiceRefInjector(encName, type, sref));
        }
    }

    @Override
    public void handleMethodAnnotations(Method method, InjectionContainer container, Map<AccessibleObject, Injector> injectors) {
        String serviceRefName = null;
        ServiceRefMetaData tmp = this.getServiceRefForInjectionTarget(method);
        if (tmp != null) {
            serviceRefName = tmp.getServiceRefName();
        } else {
            WebServiceRef wsref = method.getAnnotation(WebServiceRef.class);
            if (wsref != null && (serviceRefName = wsref.name()).equals("")) {
                serviceRefName = InjectionUtil.getEncName(method).substring(4);
            }
        }
        if (null == serviceRefName) {
            return;
        }
        if (!method.getName().startsWith("set")) {
            throw new RuntimeException("@WebServiceRef can only be used with a set method: " + method);
        }
        String encName = "env/" + serviceRefName;
        Context encCtx = container.getEnc();
        if (!container.getEncInjectors().containsKey(serviceRefName)) {
            ServiceRefMetaData sref = this.getServiceRefForName(serviceRefName);
            container.getEncInjectors().put(serviceRefName, new WebServiceRefInjector(encName, method, sref));
        }
        injectors.put(method, new JndiMethodInjector(method, encName, encCtx));
    }

    private ServiceRefMetaData getServiceRefForInjectionTarget(Method method) {
        ServiceRefMetaData match = null;
        Iterator<String> iterator = this.srefMap.keySet().iterator();
        block0: while (iterator.hasNext()) {
            ServiceRefMetaData sref = this.srefMap.get(iterator.next());
            for (String[] injectionTuple : sref.getInjectionTargets()) {
                if (!method.getDeclaringClass().getName().equals(injectionTuple[0]) || !method.getName().equals(injectionTuple[1])) continue;
                match = sref;
                continue block0;
            }
        }
        return match;
    }

    private ServiceRefMetaData getServiceRefForInjectionTarget(Field field) {
        ServiceRefMetaData match = null;
        Iterator<String> iterator = this.srefMap.keySet().iterator();
        block0: while (iterator.hasNext()) {
            ServiceRefMetaData sref = this.srefMap.get(iterator.next());
            for (String[] injectionTuple : sref.getInjectionTargets()) {
                if (!field.getDeclaringClass().getName().equals(injectionTuple[0]) || !field.getName().equals(injectionTuple[1])) continue;
                match = sref;
                continue block0;
            }
        }
        return match;
    }

    @Override
    public void handleFieldAnnotations(Field field, InjectionContainer container, Map<AccessibleObject, Injector> injectors) {
        String serviceRefName = null;
        ServiceRefMetaData tmp = this.getServiceRefForInjectionTarget(field);
        if (tmp != null) {
            serviceRefName = tmp.getServiceRefName();
        } else {
            WebServiceRef wsref = field.getAnnotation(WebServiceRef.class);
            if (wsref != null && (serviceRefName = wsref.name()).equals("")) {
                serviceRefName = InjectionUtil.getEncName(field).substring(4);
            }
        }
        if (null == serviceRefName) {
            return;
        }
        String encName = "env/" + serviceRefName;
        Context encCtx = container.getEnc();
        if (!container.getEncInjectors().containsKey(serviceRefName)) {
            ServiceRefMetaData sref = this.getServiceRefForName(serviceRefName);
            container.getEncInjectors().put(serviceRefName, new WebServiceRefInjector(encName, field, sref));
        }
        injectors.put(field, new JndiFieldInjector(field, encName, encCtx));
    }

    private ServiceRefMetaData getServiceRefForName(String name) {
        ServiceRefMetaData sref = this.srefMap.get(name);
        if (sref == null) {
            log.debug("No override for @WebServiceRef.name: " + name);
            sref = new ServiceRefDelegate().newServiceRefMetaData();
            sref.setServiceRefName(name);
        }
        return sref;
    }
}

