/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.classpool.test;

import java.util.Properties;
import javassist.ClassPool;
import javassist.CtClass;
import junit.framework.TestCase;
import org.jboss.classpool.base.CtClassCache;
import org.jboss.classpool.base.CtClassCacheFactory;
import org.jboss.classpool.spi.AbstractClassPoolFactory;
import org.jboss.util.LRUCachePolicy;
import org.jboss.util.TimedCachePolicy;

public class SimpleCtCacheTestCase
extends TestCase {
    public void testDomainCacheFactoryTimedCacheNoProperties() {
        Properties properties = new Properties();
        properties.put("org.jboss.classpool.policy", TimedCachePolicy.class.getName());
        CtClassCacheFactory factory = CtClassCacheFactory.createFromProperties((Properties)properties);
        SimpleCtCacheTestCase.assertEquals(TimedCachePolicy.class, (Object)factory.getPolicyClass());
        SimpleCtCacheTestCase.assertEquals((int)20, (int)factory.getLifetime());
        SimpleCtCacheTestCase.assertEquals((int)3, (int)factory.getResolution());
        SimpleCtCacheTestCase.assertEquals((int)0, (int)factory.getMin());
        SimpleCtCacheTestCase.assertEquals((int)0, (int)factory.getMax());
    }

    public void testDomainCacheFactoryTimedCacheAndProperties() {
        Properties properties = new Properties();
        properties.put("org.jboss.classpool.policy", TimedCachePolicy.class.getName());
        this.setProperty(properties, "org.jboss.classpool.policy.lifetime", 12);
        this.setProperty(properties, "org.jboss.classpool.policy.resolution", 23);
        this.setProperty(properties, "org.jboss.classpool.policy.min", 34);
        this.setProperty(properties, "org.jboss.classpool.policy.max", 45);
        CtClassCacheFactory factory = CtClassCacheFactory.createFromProperties((Properties)properties);
        SimpleCtCacheTestCase.assertEquals(TimedCachePolicy.class, (Object)factory.getPolicyClass());
        SimpleCtCacheTestCase.assertEquals((int)12, (int)factory.getLifetime());
        SimpleCtCacheTestCase.assertEquals((int)23, (int)factory.getResolution());
        SimpleCtCacheTestCase.assertEquals((int)0, (int)factory.getMin());
        SimpleCtCacheTestCase.assertEquals((int)0, (int)factory.getMax());
    }

    public void testDomainCacheFactoryLruCacheNoProperties() {
        Properties properties = new Properties();
        properties.put("org.jboss.classpool.policy", LRUCachePolicy.class.getName());
        CtClassCacheFactory factory = CtClassCacheFactory.createFromProperties((Properties)properties);
        SimpleCtCacheTestCase.assertEquals(LRUCachePolicy.class, (Object)factory.getPolicyClass());
        SimpleCtCacheTestCase.assertEquals((int)0, (int)factory.getLifetime());
        SimpleCtCacheTestCase.assertEquals((int)0, (int)factory.getResolution());
        SimpleCtCacheTestCase.assertEquals((int)10, (int)factory.getMin());
        SimpleCtCacheTestCase.assertEquals((int)100, (int)factory.getMax());
    }

    public void testDomainCacheFactoryLruCacheAndProperties() {
        Properties properties = new Properties();
        properties.put("org.jboss.classpool.policy", LRUCachePolicy.class.getName());
        this.setProperty(properties, "org.jboss.classpool.policy.lifetime", 12);
        this.setProperty(properties, "org.jboss.classpool.policy.resolution", 23);
        this.setProperty(properties, "org.jboss.classpool.policy.min", 34);
        this.setProperty(properties, "org.jboss.classpool.policy.max", 45);
        CtClassCacheFactory factory = CtClassCacheFactory.createFromProperties((Properties)properties);
        SimpleCtCacheTestCase.assertEquals(LRUCachePolicy.class, (Object)factory.getPolicyClass());
        SimpleCtCacheTestCase.assertEquals((int)0, (int)factory.getLifetime());
        SimpleCtCacheTestCase.assertEquals((int)0, (int)factory.getResolution());
        SimpleCtCacheTestCase.assertEquals((int)34, (int)factory.getMin());
        SimpleCtCacheTestCase.assertEquals((int)45, (int)factory.getMax());
    }

    public void testTimedDomainCache() throws Exception {
        Properties properties = new Properties();
        properties.put("org.jboss.classpool.policy", TimedCachePolicy.class.getName());
        this.setProperty(properties, "org.jboss.classpool.policy.lifetime", 1);
        this.setProperty(properties, "org.jboss.classpool.policy.resolution", 1);
        CtClassCacheFactory factory = CtClassCacheFactory.createFromProperties((Properties)properties);
        CtClassCache cache = factory.createCache();
        SimpleCtCacheTestCase.assertNotNull((Object)cache);
        ClassPool defPool = AbstractClassPoolFactory.getSystemClassPool();
        CtClass clazz = defPool.get(String.class.getName());
        SimpleCtCacheTestCase.assertNull((Object)cache.get(clazz.getName(), 0));
        cache.put(clazz.getName(), clazz);
        SimpleCtCacheTestCase.assertNotNull((Object)cache.get(clazz.getName(), 0));
        Thread.sleep(2000L);
        SimpleCtCacheTestCase.assertNull((Object)cache.get(clazz.getName(), 0));
        cache.put(clazz.getName(), clazz);
    }

    public void testCacheInvalidation() throws Exception {
        Properties properties = new Properties();
        properties.put("org.jboss.classpool.policy", TimedCachePolicy.class.getName());
        this.setProperty(properties, "org.jboss.classpool.policy.lifetime", 100);
        this.setProperty(properties, "org.jboss.classpool.policy.resolution", 10);
        CtClassCacheFactory factory = CtClassCacheFactory.createFromProperties((Properties)properties);
        CtClassCache cache = factory.createCache();
        SimpleCtCacheTestCase.assertNotNull((Object)cache);
        ClassPool defPool = AbstractClassPoolFactory.getSystemClassPool();
        CtClass clazz = defPool.get(String.class.getName());
        SimpleCtCacheTestCase.assertNull((Object)cache.get(clazz.getName(), 0));
        cache.put(clazz.getName(), clazz);
        SimpleCtCacheTestCase.assertNotNull((Object)cache.get(clazz.getName(), 0));
        SimpleCtCacheTestCase.assertNull((Object)cache.get(clazz.getName(), 1));
        cache.put(clazz.getName(), clazz);
        SimpleCtCacheTestCase.assertNotNull((Object)cache.get(clazz.getName(), 1));
    }

    private void setProperty(Properties properties, String key, int value) {
        properties.put(key, String.valueOf(value));
        SimpleCtCacheTestCase.assertEquals((Object)String.valueOf(value), (Object)properties.get(key));
    }
}

