/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.classpool.test;

import java.util.List;
import javassist.ClassPool;
import javassist.CtClass;
import org.jboss.classpool.domain.AbstractClassPoolDomain;
import org.jboss.classpool.domain.ClassPoolDomain;
import org.jboss.classpool.plugins.DelegatingClassPool;
import org.jboss.classpool.scoped.ScopedClassPoolFactory;
import org.jboss.classpool.spi.AbstractClassPoolFactory;
import org.jboss.classpool.spi.ClassPoolRepository;
import org.jboss.classpool.spi.ClassPoolRepositoryCallback;
import org.jboss.test.classpool.support.SupportArchives;
import org.jboss.test.classpool.support.SupportClasses;
import org.jboss.test.classpool.support.TestCallback;
import org.jboss.test.classpool.test.ClassPoolTest;

public class SimpleDelegatingClassPoolTestCase
extends ClassPoolTest {
    public SimpleDelegatingClassPoolTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        ClassPoolRepository.getInstance().setClassPoolFactory((ScopedClassPoolFactory)new AbstractClassPoolFactory());
    }

    public void testAllClassesOnePool() throws Exception {
        AbstractClassPoolDomain domain = SimpleDelegatingClassPoolTestCase.createClassPoolDomain("SIMPLE", null, false);
        DelegatingClassPool pool = SimpleDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)domain, SupportArchives.JAR_A_URL, SupportArchives.JAR_B_URL);
        this.accessAllClassesOnePool((ClassPool)pool);
        this.accessAllClassesOnePool((ClassPool)pool);
    }

    private void accessAllClassesOnePool(ClassPool pool) throws Exception {
        CtClass a = pool.get(SupportClasses.CLASS_A);
        SimpleDelegatingClassPoolTestCase.assertSame((Object)a, (Object)pool.get(SupportClasses.CLASS_A));
        CtClass b = pool.get(SupportClasses.CLASS_B);
        SimpleDelegatingClassPoolTestCase.assertSame((Object)b, (Object)pool.get(SupportClasses.CLASS_B));
        SimpleDelegatingClassPoolTestCase.assertEquals((Object)pool, (Object)a.getClassPool());
        SimpleDelegatingClassPoolTestCase.assertEquals((Object)pool, (Object)b.getClassPool());
        CtClass string = pool.get(String.class.getName());
        SimpleDelegatingClassPoolTestCase.assertNotSame((String)"java.lang.String should be loaded by the parent pool", (Object)pool, (Object)string.getClassPool());
        SimpleDelegatingClassPoolTestCase.assertEquals((Object)AbstractClassPoolFactory.getSystemClassPool(), (Object)string.getClassPool());
    }

    public void testOnePoolPerClassLoadedByA() throws Exception {
        AbstractClassPoolDomain domain = SimpleDelegatingClassPoolTestCase.createClassPoolDomain("SIMPLE", null, false);
        DelegatingClassPool poolA = SimpleDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)domain, SupportArchives.JAR_A_URL);
        DelegatingClassPool poolB = SimpleDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)domain, SupportArchives.JAR_B_URL);
        this.accessOnePoolPerClassLoadedByA((ClassPool)poolA, (ClassPool)poolB);
        this.accessOnePoolPerClassLoadedByA((ClassPool)poolA, (ClassPool)poolB);
    }

    private void accessOnePoolPerClassLoadedByA(ClassPool poolA, ClassPool poolB) throws Exception {
        CtClass a = poolA.get(SupportClasses.CLASS_A);
        SimpleDelegatingClassPoolTestCase.assertEquals((Object)a, (Object)poolA.get(SupportClasses.CLASS_A));
        SimpleDelegatingClassPoolTestCase.assertEquals((Object)a, (Object)poolB.get(SupportClasses.CLASS_A));
        CtClass b = poolA.get(SupportClasses.CLASS_B);
        SimpleDelegatingClassPoolTestCase.assertEquals((Object)b, (Object)poolA.get(SupportClasses.CLASS_B));
        SimpleDelegatingClassPoolTestCase.assertEquals((Object)b, (Object)poolB.get(SupportClasses.CLASS_B));
        SimpleDelegatingClassPoolTestCase.assertNotSame((Object)a.getClassPool(), (Object)b.getClassPool());
        SimpleDelegatingClassPoolTestCase.assertEquals((Object)poolA, (Object)a.getClassPool());
        SimpleDelegatingClassPoolTestCase.assertEquals((Object)poolB, (Object)b.getClassPool());
    }

    public void testOnePoolPerClassLoadedByB() throws Exception {
        AbstractClassPoolDomain domain = SimpleDelegatingClassPoolTestCase.createClassPoolDomain("SIMPLE", null, false);
        DelegatingClassPool poolA = SimpleDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)domain, SupportArchives.JAR_A_URL);
        DelegatingClassPool poolB = SimpleDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)domain, SupportArchives.JAR_B_URL);
        this.accessOnePoolPerClassLoadedByB((ClassPool)poolA, (ClassPool)poolB);
        this.accessOnePoolPerClassLoadedByB((ClassPool)poolA, (ClassPool)poolB);
    }

    public void accessOnePoolPerClassLoadedByB(ClassPool poolA, ClassPool poolB) throws Exception {
        CtClass a = poolB.get(SupportClasses.CLASS_A);
        SimpleDelegatingClassPoolTestCase.assertEquals((Object)a, (Object)poolA.get(SupportClasses.CLASS_A));
        SimpleDelegatingClassPoolTestCase.assertEquals((Object)a, (Object)poolB.get(SupportClasses.CLASS_A));
        CtClass b = poolB.get(SupportClasses.CLASS_B);
        SimpleDelegatingClassPoolTestCase.assertEquals((Object)b, (Object)poolA.get(SupportClasses.CLASS_B));
        SimpleDelegatingClassPoolTestCase.assertEquals((Object)b, (Object)poolB.get(SupportClasses.CLASS_B));
        SimpleDelegatingClassPoolTestCase.assertNotSame((Object)a.getClassPool(), (Object)b.getClassPool());
        SimpleDelegatingClassPoolTestCase.assertEquals((Object)poolA, (Object)a.getClassPool());
        SimpleDelegatingClassPoolTestCase.assertEquals((Object)poolB, (Object)b.getClassPool());
    }

    public void testCanLoadArrrayCtClass() throws Exception {
        AbstractClassPoolDomain domain = SimpleDelegatingClassPoolTestCase.createClassPoolDomain("SIMPLE", null, false);
        DelegatingClassPool poolA = SimpleDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)domain, SupportArchives.JAR_A_URL);
        DelegatingClassPool poolB = SimpleDelegatingClassPoolTestCase.createDelegatingClassPool((ClassPoolDomain)domain, SupportArchives.JAR_B_URL);
        this.accessCanLoadCtArray((ClassPool)poolA, (ClassPool)poolB);
        this.accessCanLoadCtArray((ClassPool)poolA, (ClassPool)poolB);
    }

    private void accessCanLoadCtArray(ClassPool poolA, ClassPool poolB) throws Exception {
        poolA.get(String.class.getName() + "[][]");
        CtClass a = poolA.get(SupportClasses.CLASS_A);
        CtClass aArray = poolA.get(SupportClasses.CLASS_A + "[]");
        CtClass bArray = poolA.get(SupportClasses.CLASS_B + "[][]");
        CtClass b = poolA.get(SupportClasses.CLASS_B);
        CtClass byteClassA = poolA.get("byte");
        CtClass byteClassB = poolB.get("byte");
        SimpleDelegatingClassPoolTestCase.assertSame((Object)byteClassA, (Object)byteClassB);
        SimpleDelegatingClassPoolTestCase.assertNotSame((Object)poolA, (Object)byteClassA.getClassPool());
        SimpleDelegatingClassPoolTestCase.assertNotSame((Object)poolB, (Object)byteClassA.getClassPool());
        CtClass intArrayClass = poolA.get("int[]");
        CtClass intClass = poolB.get("int");
        SimpleDelegatingClassPoolTestCase.assertSame((Object)intClass, (Object)intArrayClass.getComponentType());
        SimpleDelegatingClassPoolTestCase.assertSame((Object)byteClassA.getClassPool(), (Object)intClass.getClassPool());
        SimpleDelegatingClassPoolTestCase.assertTrue((boolean)aArray.isArray());
        SimpleDelegatingClassPoolTestCase.assertSame((Object)a, (Object)aArray.getComponentType());
        SimpleDelegatingClassPoolTestCase.assertTrue((boolean)bArray.isArray());
        SimpleDelegatingClassPoolTestCase.assertTrue((boolean)bArray.getComponentType().isArray());
        SimpleDelegatingClassPoolTestCase.assertSame((Object)b, (Object)bArray.getComponentType().getComponentType());
        SimpleDelegatingClassPoolTestCase.assertNotSame((Object)aArray.getClassPool(), (Object)bArray.getClassPool());
        SimpleDelegatingClassPoolTestCase.assertSame((Object)poolA, (Object)aArray.getClassPool());
        SimpleDelegatingClassPoolTestCase.assertSame((Object)poolB, (Object)bArray.getClassPool());
        SimpleDelegatingClassPoolTestCase.assertSame((Object)a.getClassPool(), (Object)aArray.getClassPool());
        SimpleDelegatingClassPoolTestCase.assertSame((Object)b.getClassPool(), (Object)bArray.getClassPool());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemovingPoolRepositoryCallback() throws Exception {
        ClassPoolRepository repository = ClassPoolRepository.getInstance();
        TestCallback cb1 = new TestCallback();
        TestCallback cb2 = new TestCallback();
        try {
            SimpleDelegatingClassPoolTestCase.createClassPoolDomain("SIMPLE", null, false);
            List callbacks = repository.getClassPoolRepositoryCallbacks();
            SimpleDelegatingClassPoolTestCase.assertNotNull((Object)callbacks);
            SimpleDelegatingClassPoolTestCase.assertTrue((boolean)callbacks.isEmpty());
            repository.addClassPoolRepositoryCallback((ClassPoolRepositoryCallback)cb1);
            callbacks = repository.getClassPoolRepositoryCallbacks();
            SimpleDelegatingClassPoolTestCase.assertNotNull((Object)callbacks);
            SimpleDelegatingClassPoolTestCase.assertEquals((int)1, (int)callbacks.size());
            SimpleDelegatingClassPoolTestCase.assertEquals((Object)cb1, callbacks.get(0));
            repository.addClassPoolRepositoryCallback((ClassPoolRepositoryCallback)cb2);
            callbacks = repository.getClassPoolRepositoryCallbacks();
            SimpleDelegatingClassPoolTestCase.assertNotNull((Object)callbacks);
            SimpleDelegatingClassPoolTestCase.assertEquals((int)2, (int)callbacks.size());
            SimpleDelegatingClassPoolTestCase.assertEquals((Object)cb1, callbacks.get(0));
            SimpleDelegatingClassPoolTestCase.assertEquals((Object)cb2, callbacks.get(1));
            SimpleDelegatingClassPoolTestCase.assertTrue((boolean)repository.removeClassPoolRepositoryCallback((ClassPoolRepositoryCallback)cb1));
            SimpleDelegatingClassPoolTestCase.assertNotNull((Object)callbacks);
            SimpleDelegatingClassPoolTestCase.assertEquals((int)1, (int)callbacks.size());
            SimpleDelegatingClassPoolTestCase.assertEquals((Object)cb2, callbacks.get(0));
            SimpleDelegatingClassPoolTestCase.assertTrue((boolean)repository.removeClassPoolRepositoryCallback((ClassPoolRepositoryCallback)cb2));
            SimpleDelegatingClassPoolTestCase.assertNotNull((Object)callbacks);
            SimpleDelegatingClassPoolTestCase.assertTrue((boolean)callbacks.isEmpty());
        }
        finally {
            SimpleDelegatingClassPoolTestCase.assertFalse((boolean)repository.removeClassPoolRepositoryCallback((ClassPoolRepositoryCallback)cb1));
            SimpleDelegatingClassPoolTestCase.assertFalse((boolean)repository.removeClassPoolRepositoryCallback((ClassPoolRepositoryCallback)cb2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSinglePoolRepositoryCallback() throws Exception {
        ClassPoolRepository repository = ClassPoolRepository.getInstance();
        TestCallback cb1 = new TestCallback();
        try {
            AbstractClassPoolDomain domain = SimpleDelegatingClassPoolTestCase.createClassPoolDomain("SIMPLE", null, false);
            repository.addClassPoolRepositoryCallback((ClassPoolRepositoryCallback)cb1);
            ClassLoader loaderA = SimpleDelegatingClassPoolTestCase.createLoader((ClassPoolDomain)domain, SupportArchives.JAR_A_URL);
            SimpleDelegatingClassPoolTestCase.assertNotNull((Object)loaderA);
            ClassPool poolA = repository.registerClassLoader(loaderA);
            SimpleDelegatingClassPoolTestCase.assertNotNull((Object)poolA);
            SimpleDelegatingClassPoolTestCase.assertNotNull((Object)cb1.getRegister());
            SimpleDelegatingClassPoolTestCase.assertSame((Object)loaderA, (Object)cb1.getRegister());
            SimpleDelegatingClassPoolTestCase.assertNull((Object)cb1.getUnregister());
            cb1.clear();
            repository.unregisterClassLoader(loaderA);
            SimpleDelegatingClassPoolTestCase.assertNull((Object)cb1.getRegister());
            SimpleDelegatingClassPoolTestCase.assertNotNull((Object)cb1.getUnregister());
            SimpleDelegatingClassPoolTestCase.assertSame((Object)loaderA, (Object)cb1.getUnregister());
        }
        finally {
            repository.removeClassPoolRepositoryCallback((ClassPoolRepositoryCallback)cb1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultiplePoolRepositoryCallbacks() throws Exception {
        ClassPoolRepository repository = ClassPoolRepository.getInstance();
        TestCallback cb1 = new TestCallback();
        TestCallback cb2 = new TestCallback();
        try {
            AbstractClassPoolDomain domain = SimpleDelegatingClassPoolTestCase.createClassPoolDomain("SIMPLE", null, false);
            repository.addClassPoolRepositoryCallback((ClassPoolRepositoryCallback)cb1);
            repository.addClassPoolRepositoryCallback((ClassPoolRepositoryCallback)cb2);
            ClassLoader loaderA = SimpleDelegatingClassPoolTestCase.createLoader((ClassPoolDomain)domain, SupportArchives.JAR_A_URL);
            SimpleDelegatingClassPoolTestCase.assertNotNull((Object)loaderA);
            ClassPool poolA = repository.registerClassLoader(loaderA);
            SimpleDelegatingClassPoolTestCase.assertNotNull((Object)poolA);
            SimpleDelegatingClassPoolTestCase.assertNotNull((Object)cb1.getRegister());
            SimpleDelegatingClassPoolTestCase.assertSame((Object)loaderA, (Object)cb1.getRegister());
            SimpleDelegatingClassPoolTestCase.assertNull((Object)cb1.getUnregister());
            SimpleDelegatingClassPoolTestCase.assertNotNull((Object)cb2.getRegister());
            SimpleDelegatingClassPoolTestCase.assertSame((Object)loaderA, (Object)cb2.getRegister());
            SimpleDelegatingClassPoolTestCase.assertNull((Object)cb2.getUnregister());
            cb1.clear();
            cb2.clear();
            repository.unregisterClassLoader(loaderA);
            SimpleDelegatingClassPoolTestCase.assertNull((Object)cb1.getRegister());
            SimpleDelegatingClassPoolTestCase.assertNotNull((Object)cb1.getUnregister());
            SimpleDelegatingClassPoolTestCase.assertSame((Object)loaderA, (Object)cb1.getUnregister());
            SimpleDelegatingClassPoolTestCase.assertNull((Object)cb2.getRegister());
            SimpleDelegatingClassPoolTestCase.assertNotNull((Object)cb2.getUnregister());
            SimpleDelegatingClassPoolTestCase.assertSame((Object)loaderA, (Object)cb2.getUnregister());
        }
        finally {
            repository.removeClassPoolRepositoryCallback((ClassPoolRepositoryCallback)cb1);
            repository.removeClassPoolRepositoryCallback((ClassPoolRepositoryCallback)cb2);
        }
    }
}

