/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.classpool.test;

import javassist.CtClass;
import org.jboss.classpool.domain.AbstractClassPoolDomain;
import org.jboss.classpool.domain.ClassPoolDomain;
import org.jboss.classpool.plugins.DelegatingClassPool;
import org.jboss.test.classpool.support.MockCachePolicy;
import org.jboss.test.classpool.support.SupportArchives;
import org.jboss.test.classpool.support.SupportClasses;
import org.jboss.test.classpool.test.ClassPoolTest;

public class RealCtCacheTestCase
extends ClassPoolTest {
    public RealCtCacheTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        System.setProperty("org.jboss.classpool.policy", MockCachePolicy.class.getName());
    }

    public void testSimple() throws Exception {
        MockCachePolicy.policies.clear();
        AbstractClassPoolDomain parent = RealCtCacheTestCase.createClassPoolDomain("PARENT", null, true);
        DelegatingClassPool pool = RealCtCacheTestCase.createDelegatingClassPool((ClassPoolDomain)parent, SupportArchives.JAR_A_URL);
        RealCtCacheTestCase.assertEquals((int)1, (int)MockCachePolicy.policies.size());
        MockCachePolicy policy = MockCachePolicy.policies.get(0);
        CtClass clazzA1 = pool.get(SupportClasses.CLASS_A);
        RealCtCacheTestCase.assertFalse((String)"Class A should not be cached", (boolean)policy.wasCached(SupportClasses.CLASS_A));
        policy.clearWasCachedClassses();
        CtClass clazzA2 = pool.get(SupportClasses.CLASS_A);
        RealCtCacheTestCase.assertSame((Object)clazzA1, (Object)clazzA2);
    }

    public void testOneDomainLevel() throws Exception {
        MockCachePolicy.policies.clear();
        AbstractClassPoolDomain parent = RealCtCacheTestCase.createClassPoolDomain("PARENT", null, true);
        DelegatingClassPool poolA = RealCtCacheTestCase.createDelegatingClassPool((ClassPoolDomain)parent, SupportArchives.JAR_A_URL);
        RealCtCacheTestCase.assertEquals((int)1, (int)MockCachePolicy.policies.size());
        MockCachePolicy policyA = MockCachePolicy.policies.get(0);
        policyA.clearWasCachedClassses();
        CtClass clazzAa = poolA.get(SupportClasses.CLASS_A);
        RealCtCacheTestCase.assertFalse((boolean)policyA.wasCached(SupportClasses.CLASS_A));
        clazzAa = poolA.get(SupportClasses.CLASS_A);
        DelegatingClassPool poolB = RealCtCacheTestCase.createDelegatingClassPool((ClassPoolDomain)parent, SupportArchives.JAR_B_URL);
        RealCtCacheTestCase.assertEquals((int)2, (int)MockCachePolicy.policies.size());
        MockCachePolicy policyB = MockCachePolicy.policies.get(1);
        RealCtCacheTestCase.assertNotSame((Object)policyA, (Object)policyB);
        policyA.clearWasCachedClassses();
        policyB.clearWasCachedClassses();
        clazzAa = poolA.get(SupportClasses.CLASS_A);
        CtClass clazzBa = poolA.get(SupportClasses.CLASS_B);
        CtClass clazzAb = poolB.get(SupportClasses.CLASS_A);
        CtClass clazzBb = poolB.get(SupportClasses.CLASS_B);
        RealCtCacheTestCase.assertSame((Object)clazzAa, (Object)clazzAb);
        RealCtCacheTestCase.assertSame((Object)clazzBa, (Object)clazzBb);
        RealCtCacheTestCase.assertFalse((boolean)policyA.wasCached(SupportClasses.CLASS_A));
        RealCtCacheTestCase.assertFalse((boolean)policyA.wasCached(SupportClasses.CLASS_B));
        RealCtCacheTestCase.assertFalse((boolean)policyB.wasCached(SupportClasses.CLASS_A));
        RealCtCacheTestCase.assertFalse((boolean)policyB.wasCached(SupportClasses.CLASS_B));
        policyA.clearWasCachedClassses();
        policyB.clearWasCachedClassses();
        CtClass clazzAa1 = poolA.get(SupportClasses.CLASS_A);
        CtClass clazzBa1 = poolA.get(SupportClasses.CLASS_B);
        RealCtCacheTestCase.assertSame((Object)clazzAa1, (Object)clazzAa);
        RealCtCacheTestCase.assertSame((Object)clazzBa1, (Object)clazzBa);
        RealCtCacheTestCase.assertTrue((boolean)policyA.wasCached(SupportClasses.CLASS_B));
        RealCtCacheTestCase.assertFalse((boolean)policyB.wasCached(SupportClasses.CLASS_A));
        RealCtCacheTestCase.assertFalse((boolean)policyB.wasCached(SupportClasses.CLASS_B));
        policyA.clearWasCachedClassses();
        policyB.clearWasCachedClassses();
        CtClass clazzAb1 = poolB.get(SupportClasses.CLASS_A);
        CtClass clazzBb1 = poolB.get(SupportClasses.CLASS_B);
        RealCtCacheTestCase.assertSame((Object)clazzAb1, (Object)clazzAb);
        RealCtCacheTestCase.assertSame((Object)clazzBb1, (Object)clazzBb);
        RealCtCacheTestCase.assertFalse((boolean)policyA.wasCached(SupportClasses.CLASS_A));
        RealCtCacheTestCase.assertFalse((boolean)policyA.wasCached(SupportClasses.CLASS_B));
        RealCtCacheTestCase.assertTrue((boolean)policyB.wasCached(SupportClasses.CLASS_A));
        clazzAa1 = poolA.get(SupportClasses.CLASS_A);
        clazzBa1 = poolA.get(SupportClasses.CLASS_B);
        RealCtCacheTestCase.assertTrue((boolean)policyA.wasCached(SupportClasses.CLASS_B));
        RealCtCacheTestCase.assertTrue((boolean)policyB.wasCached(SupportClasses.CLASS_A));
        poolB.close();
        MockCachePolicy.policies.remove(1);
        policyA.clearWasCachedClassses();
        policyB.clearWasCachedClassses();
        clazzAa1 = poolA.get(SupportClasses.CLASS_A);
        RealCtCacheTestCase.assertFalse((boolean)policyA.wasCached(SupportClasses.CLASS_A));
    }

    public void testParentDelegation() throws Exception {
        MockCachePolicy.policies.clear();
        AbstractClassPoolDomain parent = RealCtCacheTestCase.createClassPoolDomain("PARENT", null, true);
        RealCtCacheTestCase.createDelegatingClassPool((ClassPoolDomain)parent, SupportArchives.JAR_A_URL);
        RealCtCacheTestCase.assertEquals((int)1, (int)MockCachePolicy.policies.size());
        MockCachePolicy.policies.clear();
        AbstractClassPoolDomain child = RealCtCacheTestCase.createClassPoolDomain("CHILD", (ClassPoolDomain)parent, true);
        DelegatingClassPool childB = RealCtCacheTestCase.createDelegatingClassPool((ClassPoolDomain)child, SupportArchives.JAR_B_URL);
        RealCtCacheTestCase.assertEquals((int)1, (int)MockCachePolicy.policies.size());
        MockCachePolicy childPolicyB = MockCachePolicy.policies.get(0);
        CtClass classA = childB.get(SupportClasses.CLASS_A);
        RealCtCacheTestCase.assertFalse((boolean)childPolicyB.wasCached(SupportClasses.CLASS_A));
        childPolicyB.clearWasCachedClassses();
        CtClass classA1 = childB.get(SupportClasses.CLASS_A);
        RealCtCacheTestCase.assertSame((Object)classA, (Object)classA1);
        RealCtCacheTestCase.assertTrue((boolean)childPolicyB.wasCached(SupportClasses.CLASS_A));
        childPolicyB.clearWasCachedClassses();
        DelegatingClassPool parentB = RealCtCacheTestCase.createDelegatingClassPool((ClassPoolDomain)parent, SupportArchives.JAR_B_URL);
        classA1 = childB.get(SupportClasses.CLASS_A);
        RealCtCacheTestCase.assertFalse((boolean)childPolicyB.wasCached(SupportClasses.CLASS_A));
        RealCtCacheTestCase.assertSame((Object)classA, (Object)classA1);
        childPolicyB.clearWasCachedClassses();
        classA1 = childB.get(SupportClasses.CLASS_A);
        RealCtCacheTestCase.assertSame((Object)classA, (Object)classA1);
        RealCtCacheTestCase.assertTrue((boolean)childPolicyB.wasCached(SupportClasses.CLASS_A));
        childPolicyB.clearWasCachedClassses();
        parentB.close();
        classA1 = childB.get(SupportClasses.CLASS_A);
        RealCtCacheTestCase.assertFalse((boolean)childPolicyB.wasCached(SupportClasses.CLASS_A));
        RealCtCacheTestCase.assertSame((Object)classA, (Object)classA1);
        childPolicyB.clearWasCachedClassses();
        classA1 = childB.get(SupportClasses.CLASS_A);
        RealCtCacheTestCase.assertSame((Object)classA, (Object)classA1);
        RealCtCacheTestCase.assertTrue((boolean)childPolicyB.wasCached(SupportClasses.CLASS_A));
    }
}

