/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.spi.version;

import java.io.Serializable;
import java.util.StringTokenizer;
import org.jboss.classloading.spi.version.Version;
import org.jboss.classloading.spi.version.VersionComparatorRegistry;

public class VersionRange
implements Serializable {
    private static final long serialVersionUID = 8494384641173842116L;
    private Object low;
    private boolean lowInclusive;
    private Object high;
    private boolean highInclusive;
    public static final VersionRange ALL_VERSIONS = new VersionRange(Version.DEFAULT_VERSION);

    public static VersionRange valueOf(String rangeSpec) {
        return VersionRange.parseRangeSpec(rangeSpec);
    }

    public static VersionRange parseRangeSpec(String rangeSpec) {
        char end;
        if (rangeSpec == null) {
            throw new IllegalArgumentException("Null rangeSpec");
        }
        int length = (rangeSpec = rangeSpec.trim()).length();
        if (length == 0) {
            return ALL_VERSIONS;
        }
        char start = rangeSpec.charAt(0);
        if (start != '[' && start != '(') {
            Version version = Version.parseVersion(rangeSpec);
            return new VersionRange(version, true, version, true);
        }
        if (length < 2) {
            throw new IllegalArgumentException("Expected a closing ] or ) for version range: " + rangeSpec);
        }
        boolean floorIsInclusive = true;
        boolean ceilingIsInclusive = true;
        if (start == '(') {
            floorIsInclusive = false;
        }
        if ((end = rangeSpec.charAt(length - 1)) == ')') {
            ceilingIsInclusive = false;
        } else if (end != ']') {
            throw new IllegalArgumentException("Expected a closing ] or ) for version range: " + rangeSpec);
        }
        Version floor = null;
        Version ceiling = null;
        StringTokenizer st = new StringTokenizer(rangeSpec.substring(1, length - 1), ",", true);
        boolean mid = false;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals(",")) {
                if (mid) {
                    throw new IllegalArgumentException("Expected only one , in version range: " + rangeSpec);
                }
                mid = true;
                continue;
            }
            try {
                if (!mid) {
                    floor = Version.parseVersion(token);
                    continue;
                }
                ceiling = Version.parseVersion(token);
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("Error parsing version '" + token + "' in " + rangeSpec, e);
            }
        }
        if (ceiling == null && ceilingIsInclusive) {
            ceiling = floor;
        }
        return new VersionRange(floor, floorIsInclusive, ceiling, ceilingIsInclusive);
    }

    public VersionRange(Object low) {
        this(low, null);
    }

    public VersionRange(Object low, Object high) {
        this(low, true, high, false);
    }

    public VersionRange(Object low, boolean lowInclusive, Object high, boolean highInclusive) {
        if (low == null) {
            low = Version.DEFAULT_VERSION;
        }
        this.low = low;
        this.lowInclusive = lowInclusive;
        this.high = high;
        this.highInclusive = highInclusive;
        this.validate();
    }

    protected void validate() {
        if (this.lowInclusive && !this.isInRange(this.low)) {
            throw new IllegalArgumentException("Inclusive low is not in the range: " + this.toString());
        }
        if (this.high != null && this.highInclusive && !this.isInRange(this.high)) {
            throw new IllegalArgumentException("Inclusive high is not in the range: " + this.toString());
        }
        if (this.high != null) {
            VersionComparatorRegistry registry = VersionComparatorRegistry.getInstance();
            int comparison = registry.compare(this.low, this.high);
            if (comparison > 0) {
                throw new IllegalArgumentException("High is less than the low: " + this.toString());
            }
            if (!(comparison != 0 || this.lowInclusive && this.highInclusive)) {
                throw new IllegalArgumentException("High and low don't include each other: " + this.toString());
            }
        }
    }

    public Object getLow() {
        return this.low;
    }

    public boolean isLowInclusive() {
        return this.lowInclusive;
    }

    public Object getHigh() {
        return this.high;
    }

    public boolean isHighInclusive() {
        return this.highInclusive;
    }

    public boolean isInRange(Object version) {
        if (version == null) {
            throw new IllegalArgumentException("Null version");
        }
        VersionComparatorRegistry comparator = VersionComparatorRegistry.getInstance();
        int comparison = comparator.compare(this.low, version);
        if (comparison > 0) {
            return false;
        }
        if (!this.lowInclusive && comparison == 0) {
            return false;
        }
        if (this.high != null) {
            comparison = comparator.compare(this.high, version);
            if (comparison < 0) {
                return false;
            }
            if (!this.highInclusive && comparison == 0) {
                return false;
            }
        }
        return true;
    }

    public boolean isConsistent(VersionRange other) {
        if (other == null) {
            return true;
        }
        Object otherLow = other.getLow();
        Object otherHigh = other.getHigh();
        VersionComparatorRegistry comparator = VersionComparatorRegistry.getInstance();
        int comparison = comparator.compare(this.low, otherLow);
        if (comparison > 0 || !this.lowInclusive && comparison == 0) {
            if (otherHigh == null) {
                return true;
            }
            comparison = comparator.compare(this.low, otherHigh);
            return !(comparison > 0 || !this.lowInclusive && comparison == 0);
        }
        if (this.high == null) {
            return true;
        }
        comparison = comparator.compare(this.high, otherLow);
        return comparison >= 0 && (this.highInclusive || comparison != 0);
    }

    public boolean equals(Object obj) {
        Object otherLow;
        Object thisLow;
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof VersionRange)) {
            return false;
        }
        VersionRange other = (VersionRange)obj;
        VersionComparatorRegistry comparator = VersionComparatorRegistry.getInstance();
        if (!comparator.same(thisLow = other.getLow(), otherLow = other.getLow())) {
            return false;
        }
        if (this.isLowInclusive() != other.isLowInclusive()) {
            return false;
        }
        Object thisHigh = this.getHigh();
        Object otherHigh = other.getHigh();
        if (thisHigh == null ? otherHigh != null : !comparator.same(thisHigh, otherHigh)) {
            return false;
        }
        return thisHigh == null || this.isHighInclusive() == other.isHighInclusive();
    }

    public int hashCode() {
        if (this.high != null) {
            return this.high.hashCode();
        }
        return this.low.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.isLowInclusive()) {
            builder.append("[");
        } else {
            builder.append("(");
        }
        builder.append(this.low);
        builder.append(",");
        if (this.high != null) {
            builder.append(this.high);
            if (this.isHighInclusive()) {
                builder.append("]");
            } else {
                builder.append(")");
            }
        } else {
            builder.append("?)");
        }
        return builder.toString();
    }
}

