/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.plugins.vfs;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.classloading.spi.metadata.ExportAll;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.jboss.vfs.VirtualFileVisitor;
import org.jboss.vfs.VisitorAttributes;
import org.jboss.vfs.util.AbstractVirtualFileFilterWithAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageVisitor
extends AbstractVirtualFileFilterWithAttributes
implements VirtualFileVisitor {
    private Set<String> packages = new HashSet<String>();
    private VirtualFile[] roots;
    private VirtualFile[] excludedRoots;
    private VirtualFile root;
    private ExportAll exportAll;
    private String rootPath;
    private String rootPathWithSlash;
    private ClassFilter included;
    private ClassFilter excluded;
    private ClassFilter excludedExport;

    public static Set<String> determineAllPackages(VirtualFile[] roots, VirtualFile[] excludedRoots, ExportAll exportAll, ClassFilter included, ClassFilter excluded, ClassFilter excludedExport) {
        PackageVisitor visitor = new PackageVisitor(roots, excludedRoots, exportAll, included, excluded, excludedExport);
        for (VirtualFile root : roots) {
            try {
                visitor.setRoot(root);
                root.visit((VirtualFileVisitor)visitor);
            }
            catch (Exception e) {
                throw new Error("Error visiting " + root, e);
            }
        }
        return visitor.getPackages();
    }

    PackageVisitor(VirtualFile[] roots, VirtualFile[] excludedRoots, ExportAll exportAll, ClassFilter included, ClassFilter excluded, ClassFilter excludedExport) {
        if (exportAll == null) {
            throw new IllegalArgumentException("Null export policy");
        }
        this.roots = roots;
        this.excludedRoots = excludedRoots;
        this.exportAll = exportAll;
        this.included = included;
        this.excluded = excluded;
        this.excludedExport = excludedExport;
    }

    void setRoot(VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException("Null root");
        }
        this.root = root;
        this.rootPath = root.getPathName();
        this.rootPathWithSlash = this.rootPath + "/";
    }

    Set<String> getPackages() {
        return this.packages;
    }

    public VisitorAttributes getAttributes() {
        VisitorAttributes attributes = new VisitorAttributes();
        attributes.setIncludeRoot(true);
        attributes.setRecurseFilter((VirtualFileFilter)this);
        return attributes;
    }

    public boolean accepts(VirtualFile file) {
        if (file.equals(this.root)) {
            return true;
        }
        for (VirtualFile other : this.roots) {
            if (!file.equals(other)) continue;
            return false;
        }
        if (this.excludedRoots != null) {
            for (VirtualFile other : this.excludedRoots) {
                if (!file.equals(other)) continue;
                return false;
            }
        }
        return true;
    }

    public void visit(VirtualFile file) {
        if (file.isDirectory() && this.accepts(file)) {
            boolean empty = true;
            if (this.exportAll == ExportAll.ALL) {
                empty = false;
            } else {
                List children = file.getChildren();
                if (children != null && !children.isEmpty()) {
                    for (VirtualFile child : children) {
                        if (!child.isFile()) continue;
                        empty = false;
                        break;
                    }
                }
            }
            if (!empty) {
                String path = file.getPathName();
                if (path.equals(this.rootPath)) {
                    path = "";
                } else if (path.startsWith(this.rootPathWithSlash)) {
                    path = path.substring(this.rootPathWithSlash.length());
                }
                String pkg = path.replace('/', '.');
                if (this.included != null && !this.included.matchesPackageName(pkg)) {
                    return;
                }
                if (this.excluded != null && this.excluded.matchesPackageName(pkg)) {
                    return;
                }
                if (this.excludedExport != null && this.excludedExport.matchesPackageName(pkg)) {
                    return;
                }
                this.packages.add(pkg);
            }
        }
    }
}

