/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.spi.helpers;

import java.net.URL;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.classloader.spi.ClassLoaderCache;
import org.jboss.classloader.spi.Loader;
import org.jboss.util.collection.ConcurrentSet;

public abstract class AbstractClassLoaderCache
implements ClassLoaderCache {
    private volatile Map<String, Loader> classCache;
    private volatile Set<String> classBlackList;
    private volatile Map<String, URL> resourceCache;
    private volatile Set<String> resourceBlackList;

    protected void restoreCache() {
        this.classCache = new ConcurrentHashMap<String, Loader>();
        this.resourceCache = new ConcurrentHashMap<String, URL>();
    }

    protected void destroyCache() {
        this.classCache = null;
        this.resourceCache = null;
    }

    protected void restoreBlackList() {
        this.classBlackList = new ConcurrentSet();
        this.resourceBlackList = new ConcurrentSet();
    }

    protected void destroyBlackList() {
        this.classBlackList = null;
        this.resourceBlackList = null;
    }

    protected void merge(AbstractClassLoaderCache other) {
        if (other.classCache != null) {
            if (this.classCache != null) {
                this.classCache.putAll(other.classCache);
            } else {
                this.classCache = new ConcurrentHashMap<String, Loader>(other.classCache);
            }
        }
        if (other.resourceCache != null) {
            if (this.resourceCache != null) {
                this.resourceCache.putAll(other.resourceCache);
            } else {
                this.resourceCache = new ConcurrentHashMap<String, URL>(other.resourceCache);
            }
        }
        this.flushBlackLists();
    }

    public void flushCaches() {
        if (this.classCache != null) {
            this.classCache.clear();
        }
        if (this.resourceCache != null) {
            this.resourceCache.clear();
        }
        this.flushBlackLists();
    }

    private void flushBlackLists() {
        if (this.classBlackList != null) {
            this.classBlackList.clear();
        }
        if (this.resourceBlackList != null) {
            this.resourceBlackList.clear();
        }
    }

    public Loader getCachedLoader(String name) {
        Map<String, Loader> classCache = this.classCache;
        if (classCache != null) {
            return classCache.get(name);
        }
        return null;
    }

    public void cacheLoader(String name, Loader loader) {
        Map<String, Loader> classCache = this.classCache;
        if (classCache != null) {
            classCache.put(name, loader);
        }
    }

    public boolean isBlackListedClass(String name) {
        Set<String> classBlackList = this.classBlackList;
        return classBlackList != null && classBlackList.contains(name);
    }

    public void blackListClass(String name) {
        Set<String> classBlackList = this.classBlackList;
        if (classBlackList != null) {
            classBlackList.add(name);
        }
    }

    public URL getCachedResource(String name) {
        Map<String, URL> resourceCache = this.resourceCache;
        if (resourceCache != null) {
            return resourceCache.get(name);
        }
        return null;
    }

    public void cacheResource(String name, URL url) {
        Map<String, URL> resourceCache = this.resourceCache;
        if (resourceCache != null) {
            resourceCache.put(name, url);
        }
    }

    public boolean isBlackListedResource(String name) {
        Set<String> resourceBlackList = this.resourceBlackList;
        return resourceBlackList != null && resourceBlackList.contains(name);
    }

    public void blackListResource(String name) {
        Set<String> resourceBlackList = this.resourceBlackList;
        if (resourceBlackList != null) {
            resourceBlackList.add(name);
        }
    }

    public void clearBlackList(String name) {
        if (this.classBlackList != null) {
            this.classBlackList.remove(name);
        }
        if (this.resourceBlackList != null) {
            this.resourceBlackList.remove(name);
        }
    }
}

