/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.util;

import java.lang.constant.Constable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MethodCall {
    protected String method_name = null;
    protected Object[] args = null;
    protected Class[] types = null;
    protected String[] signature = null;
    protected Method method = null;
    protected Object target = null;
    protected static final Log log = LogFactory.getLog(MethodCall.class);

    public MethodCall(Method method, Object[] arguments, Object target) {
        this.init(method);
        if (arguments != null) {
            this.args = arguments;
        }
        this.target = target;
    }

    private void init(Method method) {
        this.method = method;
        this.method_name = method.getName();
    }

    public String getName() {
        return this.method_name;
    }

    public void setName(String n) {
        this.method_name = n;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public void setArgs(Object[] args) {
        if (args != null) {
            this.args = args;
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method m) {
        this.init(m);
    }

    Method findMethod(Class target_class) throws Exception {
        int len = this.args != null ? this.args.length : 0;
        Method[] methods = this.getAllMethods(target_class);
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (!m.getName().equals(this.method_name) || m.getParameterTypes().length != len) continue;
            return m;
        }
        return null;
    }

    Method[] getAllMethods(Class target) {
        ArrayList<Method[]> methods = new ArrayList<Method[]>();
        int size = 0;
        for (Class superclass = target; superclass != null; superclass = superclass.getSuperclass()) {
            Method[] m = superclass.getDeclaredMethods();
            methods.add(m);
            size += m.length;
        }
        Method[] result = new Method[size];
        int index = 0;
        for (Method[] m : methods) {
            System.arraycopy(m, 0, result, index, m.length);
            index += m.length;
        }
        return result;
    }

    Method getMethod(Class target, String methodName, Class[] types) {
        if (types == null) {
            types = new Class[]{};
        }
        Method[] methods = this.getAllMethods(target);
        block0: for (int i = 0; i < methods.length; ++i) {
            Class<?>[] parameters;
            Method m = methods[i];
            if (!methodName.equals(m.getName()) || types.length != (parameters = m.getParameterTypes()).length) continue;
            for (int j = 0; j < types.length; ++j) {
                if (!types[j].equals(parameters[j])) continue block0;
            }
            return m;
        }
        return null;
    }

    public Object invoke() throws Throwable {
        return this.invoke(this.target);
    }

    protected Object invoke(Object target) throws Throwable {
        Method meth = null;
        Object retval = null;
        if (this.method_name == null || target == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)"method name or target is null");
            }
            return null;
        }
        Class<?> cl = target.getClass();
        try {
            if (this.method != null) {
                meth = this.method;
            }
            if (meth == null) {
                throw new NoSuchMethodException(this.method_name);
            }
            retval = meth.invoke(target, this.args);
            return retval;
        }
        catch (InvocationTargetException inv_ex) {
            throw inv_ex.getTargetException();
        }
        catch (NoSuchMethodException no) {
            StringBuffer sb = new StringBuffer();
            sb.append("found no method called ").append(this.method_name).append(" in class ");
            sb.append(cl.getName()).append(" with (");
            if (this.args != null) {
                for (int i = 0; i < this.args.length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(this.args[i] != null ? this.args[i].getClass().getName() : "null");
                }
            }
            sb.append(") formal parameters");
            log.error((Object)sb.toString());
            throw no;
        }
        catch (Throwable e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"exception in invoke()", e);
            }
            throw e;
        }
    }

    public Object invoke(Object target, Object[] args) throws Throwable {
        if (args != null) {
            this.args = args;
        }
        return this.invoke(target);
    }

    Class[] getTypesFromString(Class cl, String[] signature) throws Exception {
        Class[] mytypes = new Class[signature.length];
        for (int i = 0; i < signature.length; ++i) {
            String name = signature[i];
            Class<Constable> parameter = "long".equals(name) ? Long.TYPE : ("int".equals(name) ? Integer.TYPE : ("short".equals(name) ? Short.TYPE : ("char".equals(name) ? Character.TYPE : ("byte".equals(name) ? Byte.TYPE : ("float".equals(name) ? Float.TYPE : ("double".equals(name) ? Double.TYPE : ("boolean".equals(name) ? Boolean.TYPE : Class.forName(name, false, cl.getClassLoader()))))))));
            mytypes[i] = parameter;
        }
        return mytypes;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        boolean first = true;
        if (this.method_name != null) {
            ret.append(this.method_name);
        }
        ret.append('(');
        if (this.args != null) {
            for (int i = 0; i < this.args.length; ++i) {
                if (first) {
                    first = false;
                } else {
                    ret.append(", ");
                }
                ret.append(this.args[i]);
            }
        }
        ret.append(')');
        return ret.toString();
    }

    public String toStringDetails() {
        StringBuffer ret = new StringBuffer();
        ret.append("MethodCall ");
        if (this.method_name != null) {
            ret.append("name=").append(this.method_name);
        }
        ret.append(", number of args=").append(this.args != null ? this.args.length : 0).append(')');
        if (this.args != null) {
            ret.append("\nArgs:");
            for (int i = 0; i < this.args.length; ++i) {
                ret.append("\n[").append(this.args[i]).append(" (").append(this.args[i] != null ? this.args[i].getClass().getName() : "null").append(")]");
            }
        }
        return ret.toString();
    }
}

