/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent.submit;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.byteman.agent.submit.ScriptText;

public class Submit {
    public static final String DEFAULT_ADDRESS = "localhost";
    public static final int DEFAULT_PORT = 9091;
    private final int port;
    private final String address;
    private PrintStream out;

    public Submit() {
        this(DEFAULT_ADDRESS, 9091, System.out);
    }

    public Submit(String address, int port) {
        this(address, port, System.out);
    }

    public Submit(String address, int port, PrintStream out) {
        if (address == null) {
            address = DEFAULT_ADDRESS;
        }
        if (port <= 0) {
            port = 9091;
        }
        if (out == null) {
            out = System.out;
        }
        this.address = address;
        this.port = port;
        this.out = out;
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public String getAgentVersion() throws Exception {
        String version = this.submitRequest("VERSION\n");
        return version != null ? version.trim() : "0";
    }

    public String getClientVersion() throws Exception {
        return this.getClass().getPackage().getImplementationVersion();
    }

    public String deleteAllRules() throws Exception {
        return this.submitRequest("DELETEALL\n");
    }

    public String listAllRules() throws Exception {
        return this.submitRequest("LIST\n");
    }

    public List<ScriptText> getAllScripts() throws Exception {
        ArrayList<String> scriptFileNames = new ArrayList<String>();
        HashMap<String, String> rulesByScript = new HashMap<String, String>();
        Pattern scriptHeaderPattern = Pattern.compile("# File (.*) line \\d+\\s*");
        Pattern ruleNamePattern = Pattern.compile("\\s*RULE\\s+(.+)\\s*");
        Pattern endRuleNamePattern = Pattern.compile("\\s*ENDRULE\\s*");
        String currentScriptName = null;
        String currentRuleName = null;
        StringBuilder currentScriptText = new StringBuilder();
        String allRules = this.listAllRules();
        BufferedReader reader = new BufferedReader(new StringReader(allRules));
        String line = reader.readLine();
        while (line != null) {
            Matcher matcher = scriptHeaderPattern.matcher(line);
            if (matcher.matches()) {
                if (currentScriptName != null) {
                    rulesByScript.put(currentScriptName, currentScriptText.toString());
                }
                if (rulesByScript.containsKey(currentScriptName = matcher.group(1))) {
                    currentScriptText = new StringBuilder((String)rulesByScript.get(currentScriptName));
                } else {
                    currentScriptText = new StringBuilder();
                    scriptFileNames.add(currentScriptName);
                }
            } else {
                matcher = ruleNamePattern.matcher(line);
                if (matcher.matches()) {
                    currentRuleName = matcher.group(1);
                    currentScriptText.append(line).append('\n');
                } else {
                    matcher = endRuleNamePattern.matcher(line);
                    if (matcher.matches()) {
                        if (currentRuleName != null) {
                            currentRuleName = null;
                            currentScriptText.append(line).append('\n');
                        }
                    } else if (currentRuleName != null) {
                        currentScriptText.append(line).append('\n');
                    }
                }
            }
            line = reader.readLine();
        }
        if (currentScriptName != null && currentScriptText.length() > 0) {
            rulesByScript.put(currentScriptName, currentScriptText.toString());
        }
        ArrayList<ScriptText> scriptTexts = new ArrayList<ScriptText>(scriptFileNames.size());
        for (String fileName : scriptFileNames) {
            String text = (String)rulesByScript.get(fileName);
            scriptTexts.add(new ScriptText(fileName, text));
        }
        return scriptTexts;
    }

    @Deprecated
    public Map<String, String> getAllRules() throws Exception {
        HashMap<String, String> rulesByScript = new HashMap<String, String>();
        Pattern scriptHeaderPattern = Pattern.compile("# File (.*) line \\d+\\s*");
        Pattern ruleNamePattern = Pattern.compile("\\s*RULE\\s+(.+)\\s*");
        Pattern endRuleNamePattern = Pattern.compile("\\s*ENDRULE\\s*");
        String currentScriptName = null;
        String currentRuleName = null;
        StringBuilder currentScriptText = new StringBuilder();
        String allRules = this.listAllRules();
        BufferedReader reader = new BufferedReader(new StringReader(allRules));
        String line = reader.readLine();
        while (line != null) {
            Matcher matcher = scriptHeaderPattern.matcher(line);
            if (matcher.matches()) {
                if (currentScriptName != null) {
                    rulesByScript.put(currentScriptName, currentScriptText.toString());
                }
                currentScriptText = rulesByScript.containsKey(currentScriptName = matcher.group(1)) ? new StringBuilder((String)rulesByScript.get(currentScriptName)) : new StringBuilder();
            } else {
                matcher = ruleNamePattern.matcher(line);
                if (matcher.matches()) {
                    currentRuleName = matcher.group(1);
                    currentScriptText.append(line).append('\n');
                } else {
                    matcher = endRuleNamePattern.matcher(line);
                    if (matcher.matches()) {
                        if (currentRuleName != null) {
                            currentRuleName = null;
                            currentScriptText.append(line).append('\n');
                        }
                    } else if (currentRuleName != null) {
                        currentScriptText.append(line).append('\n');
                    }
                }
            }
            line = reader.readLine();
        }
        if (currentScriptName != null && currentScriptText.length() > 0) {
            rulesByScript.put(currentScriptName, currentScriptText.toString());
        }
        return rulesByScript;
    }

    public List<String> splitAllRulesFromScript(String scriptContent) throws Exception {
        ArrayList<String> rules = new ArrayList<String>();
        if (scriptContent == null || scriptContent.length() == 0) {
            return rules;
        }
        Pattern ruleNamePattern = Pattern.compile("\\s*RULE\\s+(.+)\\s*");
        Pattern endRuleNamePattern = Pattern.compile("\\s*ENDRULE\\s*");
        String currentRuleName = null;
        StringBuilder currentRuleText = new StringBuilder();
        BufferedReader reader = new BufferedReader(new StringReader(scriptContent));
        String line = reader.readLine();
        while (line != null) {
            Matcher matcher = ruleNamePattern.matcher(line);
            if (matcher.matches()) {
                currentRuleName = matcher.group(1);
                currentRuleText = new StringBuilder();
                currentRuleText.append(line).append('\n');
            } else {
                matcher = endRuleNamePattern.matcher(line);
                if (matcher.matches()) {
                    if (currentRuleName != null) {
                        currentRuleName = null;
                        currentRuleText.append(line).append('\n');
                        rules.add(currentRuleText.toString());
                    }
                } else if (currentRuleName != null) {
                    currentRuleText.append(line).append('\n');
                }
            }
            line = reader.readLine();
        }
        if (currentRuleName != null && currentRuleText.length() > 0) {
            rules.add(currentRuleText.toString());
        }
        return rules;
    }

    public String determineRuleName(String ruleDefinition) throws Exception {
        Pattern ruleNamePattern = Pattern.compile("\\s*RULE\\s+(.+)\\s*");
        String ruleName = null;
        BufferedReader reader = new BufferedReader(new StringReader(ruleDefinition));
        String line = reader.readLine();
        while (line != null && ruleName == null) {
            Matcher matcher = ruleNamePattern.matcher(line);
            if (matcher.matches()) {
                ruleName = matcher.group(1);
            }
            line = reader.readLine();
        }
        return ruleName;
    }

    public String addJarsToBootClassloader(List<String> jarPaths) throws Exception {
        if (jarPaths == null || jarPaths.size() == 0) {
            return "";
        }
        StringBuilder str = new StringBuilder("BOOT\n");
        for (String jarPath : jarPaths) {
            str.append(jarPath).append("\n");
        }
        str.append("ENDBOOT\n");
        return this.submitRequest(str.toString());
    }

    public String addJarsToSystemClassloader(List<String> jarPaths) throws Exception {
        if (jarPaths == null || jarPaths.size() == 0) {
            return "";
        }
        StringBuilder str = new StringBuilder("SYS\n");
        for (String jarPath : jarPaths) {
            str.append(jarPath).append("\n");
        }
        str.append("ENDSYS\n");
        return this.submitRequest(str.toString());
    }

    public List<String> getLoadedBootClassloaderJars() throws Exception {
        String results = this.submitRequest("LISTBOOT\n");
        ArrayList<String> jars = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new StringReader(results));
        String line = reader.readLine();
        while (line != null) {
            jars.add(line);
            line = reader.readLine();
        }
        return jars;
    }

    public List<String> getLoadedSystemClassloaderJars() throws Exception {
        String results = this.submitRequest("LISTSYS\n");
        ArrayList<String> jars = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new StringReader(results));
        String line = reader.readLine();
        while (line != null) {
            jars.add(line);
            line = reader.readLine();
        }
        return jars;
    }

    public String addRulesFromFiles(List<String> filePaths) throws Exception {
        List<ScriptText> scripts = this.getRulesFromRuleFiles(filePaths);
        return this.addScripts(scripts);
    }

    public String addRulesFromResources(List<InputStream> resourceStreams) throws Exception {
        List<ScriptText> scripts = this.getRulesFromRuleStreams(resourceStreams);
        return this.addScripts(scripts);
    }

    public String addScripts(List<ScriptText> scripts) throws Exception {
        if (scripts == null || scripts.size() == 0) {
            return "";
        }
        StringBuilder str = new StringBuilder("LOAD\n");
        for (ScriptText scriptText : scripts) {
            str.append("SCRIPT " + scriptText.getFileName() + '\n');
            str.append(scriptText.getText()).append('\n');
            str.append("ENDSCRIPT\n");
        }
        str.append("ENDLOAD\n");
        return this.submitRequest(str.toString());
    }

    @Deprecated
    public String addRules(Map<String, String> rules) throws Exception {
        if (rules == null || rules.size() == 0) {
            return "";
        }
        StringBuilder str = new StringBuilder("LOAD\n");
        for (Map.Entry<String, String> entry : rules.entrySet()) {
            str.append("SCRIPT " + entry.getKey() + '\n');
            str.append(entry.getValue()).append('\n');
            str.append("ENDSCRIPT\n");
        }
        str.append("ENDLOAD\n");
        return this.submitRequest(str.toString());
    }

    public String deleteRulesFromFiles(List<String> filePaths) throws Exception {
        List<ScriptText> scripts = this.getRulesFromRuleFiles(filePaths);
        return this.deleteScripts(scripts);
    }

    public String deleteRulesFromResources(List<InputStream> resourceStreams) throws Exception {
        List<ScriptText> scripts = this.getRulesFromRuleStreams(resourceStreams);
        return this.deleteScripts(scripts);
    }

    public String deleteScripts(List<ScriptText> scripts) throws Exception {
        if (scripts == null || scripts.size() == 0) {
            return "";
        }
        StringBuilder str = new StringBuilder("DELETE\n");
        for (ScriptText scriptText : scripts) {
            str.append("SCRIPT " + scriptText.getFileName() + '\n');
            str.append(scriptText.getText()).append('\n');
            str.append("ENDSCRIPT\n");
        }
        str.append("ENDDELETE\n");
        return this.submitRequest(str.toString());
    }

    @Deprecated
    public String deleteRules(Map<String, String> rules) throws Exception {
        if (rules == null || rules.size() == 0) {
            return "";
        }
        StringBuilder str = new StringBuilder("DELETE\n");
        for (Map.Entry<String, String> entry : rules.entrySet()) {
            str.append("SCRIPT " + entry.getKey() + '\n');
            str.append(entry.getValue()).append('\n');
            str.append("ENDSCRIPT\n");
        }
        str.append("ENDDELETE\n");
        return this.submitRequest(str.toString());
    }

    public String setSystemProperties(Properties propsToSet) throws Exception {
        if (propsToSet == null || propsToSet.size() == 0) {
            return "";
        }
        StringBuilder str = new StringBuilder("SETSYSPROPS\n");
        for (Map.Entry<Object, Object> entry : propsToSet.entrySet()) {
            str.append(entry.getKey()).append('=').append(entry.getValue()).append('\n');
        }
        str.append("ENDSETSYSPROPS\n");
        return this.submitRequest(str.toString());
    }

    public Properties listSystemProperties() throws Exception {
        String results = this.submitRequest("LISTSYSPROPS\n");
        Properties props = new Properties();
        BufferedReader reader = new BufferedReader(new StringReader(results));
        String line = reader.readLine();
        while (line != null) {
            String[] nameValuePair = line.split("=", 2);
            if (nameValuePair.length != 2) {
                throw new Exception("Invalid name/value pair in line [" + line + "]. Full response below:\n" + results);
            }
            props.setProperty(nameValuePair[0], nameValuePair[1].replace("\\n", "\n").replace("\\r", "\r"));
            line = reader.readLine();
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String submitRequest(String request) throws Exception {
        Comm comm = new Comm(this.address, this.port);
        try {
            String results;
            comm.print(request);
            String string = results = comm.readResponse();
            return string;
        }
        finally {
            comm.close();
        }
    }

    private List<ScriptText> getRulesFromRuleStreams(List<InputStream> streams) throws Exception {
        if (streams == null || streams.size() == 0) {
            return new ArrayList<ScriptText>(0);
        }
        ArrayList<ScriptText> scripts = new ArrayList<ScriptText>(streams.size());
        for (InputStream is : streams) {
            try {
                InputStreamReader reader = new InputStreamReader(is);
                ScriptText scriptText = this.readScriptText(is.toString(), reader);
                scripts.add(scriptText);
            }
            catch (IOException e) {
                throw new Exception("Error reading from rule input stream: " + is, e);
            }
        }
        return scripts;
    }

    private List<ScriptText> getRulesFromRuleFiles(List<String> filePaths) throws Exception {
        if (filePaths == null || filePaths.size() == 0) {
            return new ArrayList<ScriptText>(0);
        }
        ArrayList<ScriptText> scripts = new ArrayList<ScriptText>(filePaths.size());
        for (String filePath : filePaths) {
            if (!this.confirmRuleFileValidity(filePath)) {
                throw new Exception("Invalid rule file: " + filePath);
            }
            try {
                FileInputStream fis = new FileInputStream(filePath);
                InputStreamReader reader = new InputStreamReader(fis);
                ScriptText scriptText = this.readScriptText(filePath, reader);
                scripts.add(scriptText);
            }
            catch (IOException e) {
                throw new Exception("Error reading from rule file: " + filePath, e);
            }
        }
        return scripts;
    }

    private ScriptText readScriptText(String filePath, InputStreamReader reader) throws Exception {
        char[] readBuffer = new char[4096];
        StringBuilder scriptText = new StringBuilder();
        try {
            int read = reader.read(readBuffer);
            while (read > 0) {
                scriptText.append(readBuffer, 0, read);
                read = reader.read(readBuffer);
            }
            reader.close();
            return new ScriptText(filePath, scriptText.toString());
        }
        catch (IOException e) {
            throw new Exception("Error reading from rule file: " + filePath, e);
        }
    }

    private boolean confirmRuleFileValidity(String path) {
        File file = new File(path);
        return file.isFile() && file.canRead();
    }

    public static void main(String[] args) {
        String outfile = null;
        int port = 9091;
        String hostname = DEFAULT_ADDRESS;
        int startIdx = 0;
        int maxIdx = args.length;
        boolean deleteRules = false;
        boolean addBoot = false;
        boolean addSys = false;
        boolean showVersion = false;
        boolean showAddedClassloaderJars = false;
        boolean sysProps = false;
        int optionCount = 0;
        PrintStream out = System.out;
        while (startIdx < maxIdx && args[startIdx].startsWith("-")) {
            if (maxIdx >= startIdx + 2 && args[startIdx].equals("-o")) {
                FileOutputStream fos;
                outfile = args[startIdx + 1];
                File file = new File(outfile);
                if (file.exists()) {
                    if (file.isDirectory() || !file.canWrite()) {
                        out.println("Submit : invalid output file " + outfile);
                        System.exit(1);
                    }
                    fos = null;
                    try {
                        fos = new FileOutputStream(file, true);
                    }
                    catch (FileNotFoundException e) {
                        out.println("Submit : error opening output file " + outfile);
                    }
                    out = new PrintStream(fos);
                } else {
                    fos = null;
                    try {
                        fos = new FileOutputStream(file, true);
                    }
                    catch (FileNotFoundException e) {
                        out.println("Submit : error opening output file " + outfile);
                    }
                    out = new PrintStream(fos);
                }
                startIdx += 2;
                continue;
            }
            if (maxIdx >= startIdx + 2 && args[startIdx].equals("-p")) {
                try {
                    port = Integer.valueOf(args[startIdx + 1]);
                }
                catch (NumberFormatException e) {
                    out.println("Submit : invalid port " + args[startIdx + 1]);
                    System.exit(1);
                }
                if (port <= 0) {
                    out.println("Submit : invalid port " + args[startIdx + 1]);
                    System.exit(1);
                }
                startIdx += 2;
                continue;
            }
            if (maxIdx >= startIdx + 2 && args[startIdx].equals("-h")) {
                hostname = args[startIdx + 1];
                startIdx += 2;
                continue;
            }
            if (args[startIdx].equals("-u")) {
                deleteRules = true;
                ++startIdx;
                ++optionCount;
                continue;
            }
            if (args[startIdx].equals("-l")) {
                ++startIdx;
                ++optionCount;
                continue;
            }
            if (args[startIdx].equals("-b")) {
                addBoot = true;
                ++startIdx;
                ++optionCount;
                continue;
            }
            if (args[startIdx].equals("-v")) {
                showVersion = true;
                ++startIdx;
                ++optionCount;
                continue;
            }
            if (args[startIdx].equals("-c")) {
                showAddedClassloaderJars = true;
                ++startIdx;
                ++optionCount;
                continue;
            }
            if (args[startIdx].equals("-s")) {
                addSys = true;
                ++startIdx;
                ++optionCount;
                continue;
            }
            if (!args[startIdx].equals("-y")) break;
            sysProps = true;
            ++startIdx;
            ++optionCount;
        }
        if (startIdx < maxIdx && args[startIdx].startsWith("-") || optionCount > 1) {
            Submit.usage(out, 1);
        }
        if (startIdx == maxIdx && (addBoot || addSys)) {
            Submit.usage(out, 1);
        }
        Submit client = new Submit(hostname, port, out);
        String results = null;
        ArrayList<String> argsList = null;
        try {
            if (showVersion) {
                String agentVersion = client.getAgentVersion();
                String clientVersion = client.getClientVersion();
                results = "Agent Version: " + agentVersion + "\nClient Version: " + clientVersion;
            } else if (showAddedClassloaderJars) {
                List<String> bootJars = client.getLoadedBootClassloaderJars();
                List<String> sysJars = client.getLoadedSystemClassloaderJars();
                StringBuilder str = new StringBuilder();
                str.append("Boot Classloader Jars:").append('\n');
                if (bootJars.isEmpty()) {
                    str.append("\t<none>\n");
                } else {
                    for (String jar : bootJars) {
                        str.append('\t').append(jar).append('\n');
                    }
                }
                str.append("System Classloader Jars:").append('\n');
                if (sysJars.isEmpty()) {
                    str.append("\t<none>\n");
                } else {
                    for (String jar : sysJars) {
                        str.append('\t').append(jar).append('\n');
                    }
                }
                results = str.toString();
            } else if (startIdx == maxIdx) {
                if (deleteRules) {
                    results = client.deleteAllRules();
                } else if (sysProps) {
                    Properties props = client.listSystemProperties();
                    StringBuilder str = new StringBuilder();
                    for (Map.Entry<Object, Object> prop : props.entrySet()) {
                        str.append(prop.getKey()).append('=').append(prop.getValue()).append('\n');
                    }
                    results = str.toString();
                } else {
                    results = client.listAllRules();
                }
            } else {
                argsList = new ArrayList<String>();
                for (int i = startIdx; i < maxIdx; ++i) {
                    argsList.add(args[i]);
                }
                if (addBoot) {
                    results = client.addJarsToBootClassloader(argsList);
                } else if (addSys) {
                    results = client.addJarsToSystemClassloader(argsList);
                } else if (sysProps) {
                    Properties propsToSet = new Properties();
                    for (String arg : argsList) {
                        String[] nameValuePair = arg.split("=", 2);
                        if (nameValuePair.length != 2) {
                            throw new Exception("Invalid name/value pair: " + arg);
                        }
                        propsToSet.setProperty(nameValuePair[0], nameValuePair[1]);
                    }
                    results = client.setSystemProperties(propsToSet);
                } else {
                    results = deleteRules ? client.deleteRulesFromFiles(argsList) : client.addRulesFromFiles(argsList);
                }
            }
        }
        catch (Exception e) {
            out.println("Failed to process request: " + e);
            if (argsList != null) {
                out.println("-- Args were: " + argsList);
            }
            if (results != null) {
                out.println("-- Results were: " + results);
            }
            e.printStackTrace();
            System.exit(1);
        }
        out.println(results);
        if (out != System.out) {
            out.close();
        }
    }

    private static void usage(PrintStream out, int exitCode) {
        out.println("usage : Submit [-o outfile] [-p port] [-h hostname] [-l|-u] [scriptfile . . .]");
        out.println("        Submit [-o outfile] [-p port] [-h hostname] [-b|-s] jarfile . . .");
        out.println("        Submit [-o outfile] [-p port] [-h hostname] [-c]");
        out.println("        Submit [-o outfile] [-p port] [-h hostname] [-y] [prop1[=[value1]]. . .]");
        out.println("        Submit [-o outfile] [-p port] [-h hostname] [-v]");
        out.println("        -o redirects output from System.out to outfile");
        out.println("        -p specifies listener port");
        out.println("        -h specifies listener host");
        out.println("        -l (default) with scriptfile(s) means load/reload all rules in scriptfile(s)");
        out.println("                     with no scriptfile means list all currently loaded rules");
        out.println("        -u with scriptfile(s) means unload all rules in scriptfile(s)");
        out.println("           with no scriptfile means unload all currently loaded rules");
        out.println("        -b with jarfile(s) means add jars to bootstrap classpath");
        out.println("        -s with jarfile(s) means add jars to system classpath");
        out.println("        -c prints the jars that have been added to the system and boot classloaders");
        out.println("        -y with no args list all byteman config system properties");
        out.println("           with args modifies specified byteman config system properties");
        out.println("             prop=value sets system property 'prop' to value");
        out.println("             prop= sets system property 'prop' to an empty string");
        out.println("             prop unsets system property 'prop'");
        out.println("        -v prints the version of the byteman agent and this client");
        if (out != System.out) {
            out.close();
        }
        System.exit(exitCode);
    }

    private class Comm {
        private Socket commSocket;
        private BufferedReader commInput;
        private PrintWriter commOutput;

        public Comm(String address, int port) throws Exception {
            OutputStream os;
            InputStream is;
            this.commSocket = new Socket(address, port);
            try {
                is = this.commSocket.getInputStream();
            }
            catch (Exception e) {
                try {
                    this.commSocket.close();
                }
                catch (Exception e1) {
                    // empty catch block
                }
                throw e;
            }
            try {
                os = this.commSocket.getOutputStream();
            }
            catch (Exception e) {
                try {
                    this.commSocket.close();
                }
                catch (Exception e1) {
                    // empty catch block
                }
                throw e;
            }
            this.commInput = new BufferedReader(new InputStreamReader(is));
            this.commOutput = new PrintWriter(new OutputStreamWriter(os));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            try {
                this.commSocket.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.commSocket = null;
                this.commInput = null;
                this.commOutput = null;
            }
        }

        public void println(String line) {
            this.commOutput.println(line);
            this.commOutput.flush();
        }

        public void print(String line) {
            this.commOutput.print(line);
            this.commOutput.flush();
        }

        public String readResponse() throws Exception {
            StringBuilder str = new StringBuilder();
            StringBuilder errorStr = null;
            String line = this.commInput.readLine();
            while (line != null && !line.trim().equals("OK")) {
                if (((line = line.trim()).startsWith("ERROR") || line.startsWith("EXCEPTION")) && errorStr == null) {
                    errorStr = new StringBuilder();
                }
                if (errorStr != null) {
                    errorStr.append(line).append('\n');
                }
                str.append(line).append('\n');
                line = this.commInput.readLine();
            }
            if (errorStr != null) {
                StringBuilder msg = new StringBuilder();
                msg.append("The remote byteman agent reported an error:\n").append((CharSequence)errorStr);
                if (!errorStr.toString().equals(str.toString())) {
                    msg.append("\nThe full response received from the byteman agent follows:\n").append((CharSequence)str);
                }
                throw new Exception(msg.toString());
            }
            return str.toString();
        }
    }
}

