/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bootstrap.impl.mc.server;

import org.jboss.bootstrap.impl.base.server.AbstractVersion;

/**
 * Provides access to JBoss MC version (and build) properties.
 *
 * @author <a href="mailto:baileyje@gmail.com">John Bailey</a>
 * @version $Revision: 63730 $
 */
public final class MCVersion extends AbstractVersion
{

   /**
   * The single instance.
   */
   private static MCVersion instance = null;

   /**
   * Get the single <tt>MCVersion</tt> instance.
   *
   * @return The single <tt>MCVersion</tt> instance.
   */
   public synchronized static MCVersion getInstance()
   {
      if (instance == null)
      {
         instance = new MCVersion();
      }
      return instance;
   }

   /**
    * Do not allow direct public construction.
    */
   private MCVersion()
   {
   }

   @Override
   protected Class<?> getImplClass()
   {
      return MCVersion.class;
   }

   @Override
   protected String getVersionResourceLocation()
   {
      return "/org/jboss/mc-version.properties";
   }

}
