/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bootstrap.impl.base.config;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.bootstrap.api.config.ServerConfig;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBasicServerConfig<T extends ServerConfig<T>>
implements ServerConfig<T> {
    private static final Logger log = Logger.getLogger(AbstractBasicServerConfig.class);
    private static final String TRAILING_SLASH = "/";
    private volatile Class<T> actualClass;
    private URL bootstrapUrl;
    private URL bootstrapHome;
    private String bootstrapName;
    private ConcurrentMap<String, String> properties;
    private volatile boolean frozen;

    public AbstractBasicServerConfig(Class<T> actualClass) {
        this(actualClass, null);
    }

    public AbstractBasicServerConfig(Class<T> actualClass, Map<String, String> overrideProperties) {
        Properties sysProps = System.getProperties();
        ConcurrentHashMap<String, String> properties = new ConcurrentHashMap<String, String>();
        Set<Object> sysPropKeys = sysProps.keySet();
        for (Object sysPropKey : sysPropKeys) {
            String sysPropKeyString = (String)sysPropKey;
            String value = sysProps.getProperty(sysPropKeyString);
            properties.put(sysPropKeyString, value);
        }
        if (overrideProperties != null) {
            properties.putAll(overrideProperties);
        }
        this.properties = properties;
        this.actualClass = actualClass;
        this.frozen = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getBootstrapHome() {
        URL url = null;
        AbstractBasicServerConfig abstractBasicServerConfig = this;
        synchronized (abstractBasicServerConfig) {
            url = this.bootstrapHome;
        }
        return this.copyURL(url);
    }

    public synchronized String getBootstrapName() {
        return this.bootstrapName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getBootstrapUrl() {
        URL url = null;
        AbstractBasicServerConfig abstractBasicServerConfig = this;
        synchronized (abstractBasicServerConfig) {
            url = this.bootstrapUrl;
        }
        return this.copyURL(url);
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public String getProperty(String key) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("key must be specified");
        }
        String value = (String)this.properties.get(key);
        return value;
    }

    public synchronized T bootstrapHome(URL bootstrapHome) throws IllegalArgumentException {
        this.checkMutable();
        URL newUrl = this.adjustToDirectory(bootstrapHome);
        this.setPropertyForUrl("jboss.bootstrap.home.url", newUrl);
        this.bootstrapHome = newUrl;
        return this.covarientReturn();
    }

    public synchronized T bootstrapName(String name) throws IllegalArgumentException {
        this.checkMutable();
        this.setPropertyForString("jboss.bootstrap.name", name);
        this.bootstrapName = name;
        return this.covarientReturn();
    }

    public synchronized T bootstrapUrl(URL bootstrapLocation) throws IllegalArgumentException {
        this.checkMutable();
        this.setPropertyForUrl("jboss.bootstrap.url", bootstrapLocation);
        this.bootstrapUrl = bootstrapLocation;
        return this.covarientReturn();
    }

    public T property(String key, String value) throws IllegalArgumentException {
        this.checkMutable();
        if (key == null) {
            throw new IllegalArgumentException("Key may not be null");
        }
        this.setPropertyForString(key, value);
        return this.covarientReturn();
    }

    public T properties(Map<String, String> properties) throws IllegalArgumentException, IllegalStateException {
        this.checkMutable();
        if (properties == null) {
            throw new IllegalArgumentException("properties may not be null");
        }
        for (String propName : properties.keySet()) {
            String propValue = properties.get(propName);
            this.setPropertyForString(propName, propValue);
        }
        return this.covarientReturn();
    }

    public T properties(Properties properties) throws IllegalArgumentException, IllegalStateException {
        this.checkMutable();
        if (properties == null) {
            throw new IllegalArgumentException("properties may not be null");
        }
        for (Object propName : properties.keySet()) {
            String propNameString = null;
            try {
                propNameString = (String)propName;
            }
            catch (ClassCastException cce) {
                throw new IllegalArgumentException("Properties supported must be in String/String pairs, but found: " + propName + " of type: " + propName.getClass().getName(), cce);
            }
            Object propValue = properties.get(propNameString);
            String propValueString = null;
            try {
                propValueString = (String)propValue;
            }
            catch (ClassCastException cce) {
                throw new IllegalArgumentException("Properties supported must be in String/String pairs, but found: " + propName + " with value: " + propValue + "of type: " + propValue.getClass().getName(), cce);
            }
            this.setPropertyForString(propNameString, propValueString);
        }
        return this.covarientReturn();
    }

    public void freeze() throws IllegalStateException {
        this.frozen = true;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public T bootstrapHome(String bootstrapHome) throws IllegalArgumentException, IllegalStateException {
        this.bootstrapHome(this.urlFromString(bootstrapHome));
        return this.covarientReturn();
    }

    public T bootstrapUrl(String bootstrapUrl) throws IllegalArgumentException, IllegalStateException {
        this.bootstrapUrl(this.urlFromString(bootstrapUrl));
        return this.covarientReturn();
    }

    protected void setPropertyForUrl(String propertyName, URL url) {
        String urlString = url != null ? url.toExternalForm() : null;
        this.setPropertyForString(propertyName, urlString);
    }

    protected void setPropertyForString(String propertyName, String value) {
        ConcurrentMap<String, String> properties = this.properties;
        String valueToSet = value;
        if (valueToSet == null) {
            valueToSet = "";
        }
        properties.put(propertyName, valueToSet);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Set property \"" + propertyName + "\" to: " + (value != null ? "\"" + value + "\"" : "[EMPTY]")));
        }
    }

    protected void setPropertyForString(String propertyName, Integer value) {
        String stringValue = value != null ? value.toString() : null;
        this.setPropertyForString(propertyName, stringValue);
    }

    protected void setPropertyForString(String propertyName, Boolean value) {
        String stringValue = value != null ? value.toString() : null;
        this.setPropertyForString(propertyName, stringValue);
    }

    protected void checkMutable() throws IllegalStateException {
        if (this.isFrozen()) {
            throw new IllegalStateException("Cannot mutate state of the configuration after it has been frozen");
        }
    }

    protected URL adjustToDirectory(URL url) {
        if (url == null) {
            return null;
        }
        String externalForm = url.toExternalForm();
        if (externalForm.endsWith(TRAILING_SLASH)) {
            return url;
        }
        String newLocation = externalForm + TRAILING_SLASH;
        URL newUrl = null;
        try {
            newUrl = new URL(newLocation);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Could not create new URL to point to directory", e);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Appended trailing slash to " + url + " to point to directory: " + newUrl));
        }
        return newUrl;
    }

    protected Class<T> getActualClass() {
        return this.actualClass;
    }

    protected final T covarientReturn() throws ClassCastException {
        try {
            return (T)((ServerConfig)this.getActualClass().cast(this));
        }
        catch (ClassCastException cce) {
            throw new RuntimeException("Could not return the expected type; ensure that this configuration was constructed with the correct actual class", cce);
        }
    }

    protected final URL copyURL(URL url) {
        if (url == null) {
            return url;
        }
        try {
            return new URL(url.toExternalForm());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Error in copying URL", e);
        }
    }

    protected final URL urlFromString(String url) throws IllegalArgumentException {
        try {
            return url != null ? new URL(url) : null;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Could not construct " + URL.class.getSimpleName() + " from the supplied argument: " + url, e);
        }
    }
}

