/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.bootstrap.impl.as.lifecycle;

import java.net.URL;

import org.jboss.bootstrap.api.lifecycle.LifecycleEventException;
import org.jboss.bootstrap.api.lifecycle.LifecycleEventHandler;
import org.jboss.bootstrap.api.lifecycle.LifecycleState;
import org.jboss.logging.Logger;
import org.jboss.net.protocol.URLStreamHandlerFactory;
import org.jboss.virtual.VFS;

/**
 * VfsInitializingLifecycleEventHandler
 * 
 * Initializes VFS via an explicit call to {@link VFS#init()}
 *
 * @author <a href="mailto:andrew.rubinger@jboss.org">ALR</a>
 * @version $Revision: $
 * @deprecated JBBOOT-67 -This is in place only until we've got a mechanism to initialize
 * VFS explictly via a configurable deployable bootstrap XML, not this built-in hack
 * (which supports the legacy behaviour).
 */
@Deprecated
//TODO Remove JBBOOT-67, JBBOOT-68
public class VfsInitializingLifecycleEventHandler implements LifecycleEventHandler
{

   //-------------------------------------------------------------------------------------||
   // Class Members ----------------------------------------------------------------------||
   //-------------------------------------------------------------------------------------||

   /**
    * Logger
    */
   private static final Logger log = Logger.getLogger(VfsInitializingLifecycleEventHandler.class);

   //-------------------------------------------------------------------------------------||
   // Instance Members -------------------------------------------------------------------||
   //-------------------------------------------------------------------------------------||

   /**
    * Flag to indicate whether this has yet been run
    */
   private boolean beenRun;

   //-------------------------------------------------------------------------------------||
   // Required Implementations -----------------------------------------------------------||
   //-------------------------------------------------------------------------------------||

   /* (non-Javadoc)
    * @see org.jboss.bootstrap.spi.lifecycle.LifecycleEventHandler#handleEvent(org.jboss.bootstrap.spi.lifecycle.LifecycleState)
    */
   public synchronized void handleEvent(final LifecycleState state) throws LifecycleEventException
   {
      // Only run this instance once
      if (!beenRun)
      {
         // Log
         log.debug("Initializing the virtual filesystem...");

         // Init the virtual filesystem
         VFS.init();

         // This bit was copied from the legacy AbstractServerImpl
         try
         {
            // Install a URLStreamHandlerFactory that uses the TCL
            URL.setURLStreamHandlerFactory(new URLStreamHandlerFactory());

            // Preload JBoss URL handlers
            URLStreamHandlerFactory.preload();
         }
         catch (final Error e)
         {
            // very naughty but we HAVE to do this or
            // we'll fail if we ever try to do this again
            log.warn("Caught Throwable Error, this probably means "
                  + "we've already set the URLStreamHAndlerFactory before", e);
         }

         // Mark
         beenRun = true;
      }
   }
}