/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.bootstrap.api.lifecycle;

/**
 * Describes state of the Server lifecycle
 * 
 * INSTANCIATED == Instanciated, the initial state of new servers.  Never re-enters this state 
 *   (so lifecycle event callbacks will never be made here)
 * PRE_INIT == Just prior to initialization, open to configuration, mutable operations permitted.
 *   In this state no more than once.  
 * INITIALIZED == Initialization completed, mutable operations frozen.  In this state
 *   no more than once.
 * IDLE == Not yet started, or has previously stopped.  Awaiting start.
 * STARTING == In start lifecycle
 * STARTED == Fully started, in service
 * STOPPING == In stop lifecycle
 * STOPPED == Transition state to denote fully stopped before returning to IDLE
 *
 * @author <a href="mailto:andrew.rubinger@jboss.org">ALR</a>
 * @version $Revision: $
 */
public enum LifecycleState {

   /*
    * Lifecycle States for Servers
    */

   INSTANCIATED, PRE_INIT, INITIALIZED, IDLE, STARTING, STARTED, STOPPING, STOPPED
}
