/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bootstrap.api.descriptor;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import org.jboss.bootstrap.api.descriptor.BootstrapDescriptor;
import org.jboss.bootstrap.api.descriptor.BootstrapDescriptorBase;
import org.jboss.bootstrap.api.descriptor.UrlBootstrapDescriptor;

public class FileBootstrapDescriptor
extends BootstrapDescriptorBase
implements BootstrapDescriptor {
    private static final Logger log = Logger.getLogger(FileBootstrapDescriptor.class.getName());
    private final BootstrapDescriptor urlDescriptor;

    public FileBootstrapDescriptor(File file) throws IllegalArgumentException {
        URL url;
        if (file == null) {
            throw new IllegalArgumentException("file must be specified");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("file must exist: " + file.getAbsolutePath());
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("file must not be a directory: " + file.getAbsolutePath());
        }
        try {
            url = file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Error in obtaining URL for File: " + file.getAbsolutePath(), e);
        }
        UrlBootstrapDescriptor delegate = new UrlBootstrapDescriptor(url);
        this.urlDescriptor = delegate;
    }

    @Override
    public String getName() {
        return this.urlDescriptor.getName();
    }

    @Override
    public InputStream getContent() {
        return this.urlDescriptor.getContent();
    }
}

