/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.beanvalidation.util;

import javax.naming.NamingException;
import javax.validation.ValidatorFactory;

/**
 * Create jndi name for Validator Factory.
 *
 * @author <a href="mailto:stan.silvert@jboss.org">Stan Silvert</a>
 */
public interface JndiBinder
{
   /**
    * Bind a ValidatorFactory to the given name.
    *
    * @param name The name that the factory will be bound to.
    * @param validatorFactory The factory to bind.
    */
   public void bind(String name, ValidatorFactory validatorFactory) throws NamingException;
           
   /**
    * Unbind a ValidatorFactory.
    *
    * @param rootContext the root JNDI context (not the BV subcontext)
    * @return new jndi name for VF
    */
   public void unbind(String name) throws NamingException;
}
