/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.beanvalidation.util;

import java.util.Set;

import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.DeploymentUnitFilter;

/**
 * Check if any attachment is present in deployment unit.
 *
 * @author <a href="mailto:ales.justin@jboss.org">Ales Justin</a>
 */
public class AttachmentPresentDeploymentUnitFilter implements DeploymentUnitFilter
{
   private Set<String> attachmentNames;

   public boolean accepts(DeploymentUnit unit)
   {
      if (attachmentNames != null && attachmentNames.isEmpty() == false)
      {
         for (String name : attachmentNames)
         {
            if (unit.isAttachmentPresent(name))
               return true;
         }
      }
      return false;
   }

   /**
    * Set attachment names.
    *
    * @param attachmentNames the attachment names
    */
   public void setAttachmentNames(Set<String> attachmentNames)
   {
      this.attachmentNames = attachmentNames;
   }
}
