/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.beanvalidation.deployers;

import javax.naming.NamingException;
import javax.validation.ValidatorFactory;

import org.jboss.beanvalidation.util.JndiBinder;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.structure.spi.DeploymentUnit;

/**
 * Bind ValidatorFactory to jndi.
 *
 * @author <a href="mailto:ales.justin@jboss.org">Ales Justin</a>
 * @author <a href="mailto:stan.silvert@jboss.org">Stan Silvert</a>
 */
public class ValidatorFactoryJndiBinderDeployer extends AbstractSimpleRealDeployer<ValidatorFactory>
{
   private JndiBinder jndiBinder;

   public ValidatorFactoryJndiBinderDeployer(JndiBinder jndiBinder)
   {
      super(ValidatorFactory.class);

      if (jndiBinder == null)
         throw new IllegalArgumentException("Null jndi binder");

      setStage(DeploymentStages.PRE_REAL);
      addOutput(ValidatorFactory.class.getName() + ".JNDI_NAME");
      
      this.jndiBinder = jndiBinder;
   }

   @Override
   public void deploy(DeploymentUnit unit, ValidatorFactory validatorFactory) throws DeploymentException
   {
      try
      {
         jndiBinder.bind(unit.getSimpleName(), validatorFactory);
      }
      catch (NamingException e)
      {
         throw DeploymentException.rethrowAsDeploymentException("Cannot bind validator factory.", e);
      }
   }
   
   @Override
   public void undeploy(DeploymentUnit unit, ValidatorFactory validatorFactory)
   {
      try
      {
         jndiBinder.unbind(unit.getSimpleName());
      }
      catch (NamingException e)
      {
         log.warn("Exception unbinding validator factory: " + e);
      }
   }

}