/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.beanvalidation.deployers;

import javax.validation.ValidatorFactory;

import org.jboss.beans.metadata.spi.factory.BeanFactory;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.DeploymentUnitFilter;

/**
 * Create ValidatorFactory and add it into deployment unit.
 *
 * @author <a href="mailto:ales.justin@jboss.org">Ales Justin</a>
 */
public class ValidatorFactoryDeployer extends AbstractRealDeployer
{
   private BeanFactory factory;
   private DeploymentUnitFilter filter;

   public ValidatorFactoryDeployer(BeanFactory factory)
   {
      if (factory == null)
         throw new IllegalArgumentException("Null factory");

      setStage(DeploymentStages.PRE_REAL);
      setOutput(ValidatorFactory.class);

      this.factory = factory;
   }

   /**
    * Is deployer relevant.
    *
    * @param unit the deployment unit
    * @return true if deployer is relevant, false otherwise
    */
   protected boolean isRelevant(DeploymentUnit unit)
   {
      return filter != null && filter.accepts(unit);
   }

   protected void internalDeploy(DeploymentUnit unit) throws DeploymentException
   {
      if (isRelevant(unit))
      {
         try
         {
            Object result = factory.createBean();
            ValidatorFactory vf = ValidatorFactory.class.cast(result);
            unit.addAttachment(ValidatorFactory.class, vf);
         }
         catch (Throwable t)
         {
            throw DeploymentException.rethrowAsDeploymentException("Error creating validator factory", t);
         }
      }
   }

   /**
    * Set deployment unit filter.
    *
    * @param filter the deployment unit filter
    */
   public void setFilter(DeploymentUnitFilter filter)
   {
      this.filter = filter;
   }
}
