/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.auto;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapperBuilder;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.Version;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.function.Supplier;
import org.jboss.auto.GenerationException;

public class CodeGenerator {
    public static final Version VERSION = new Version(2, 3, 23);
    private final Configuration config = new Configuration(VERSION);

    public CodeGenerator(Class resourceLoaderClass, String templates) {
        this.config.setDefaultEncoding("UTF-8");
        this.config.setClassForTemplateLoading(resourceLoaderClass, templates);
        this.config.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapperBuilder(VERSION).build());
    }

    public StringBuffer generate(String template, Supplier<Map<String, Object>> context) {
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        try {
            Template t = this.config.getTemplate(template);
            t.process(context.get(), (Writer)bw);
        }
        catch (TemplateException | IOException e) {
            throw new GenerationException("Error generating template " + template + ": " + e.getMessage(), (Exception)e);
        }
        finally {
            try {
                bw.close();
                sw.close();
            }
            catch (IOException ioe) {
                throw new GenerationException("Error generating template " + template + ": " + ioe.getMessage(), ioe);
            }
        }
        return sw.getBuffer();
    }
}

