/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deploymentoverlay;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.operations.CompositeOperationAwareTransformer;
import org.jboss.as.controller.operations.OperationAttachments;
import org.jboss.as.controller.operations.validation.AbstractParameterValidator;
import org.jboss.as.controller.operations.validation.ChainedParameterValidator;
import org.jboss.as.controller.operations.validation.ListValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersOfValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.DeploymentFileRepository;
import org.jboss.as.server.ServerLogger;
import org.jboss.as.server.ServerMessages;
import org.jboss.as.server.deploymentoverlay.ContentDefinition;
import org.jboss.as.server.deploymentoverlay.service.ContentService;
import org.jboss.as.server.deploymentoverlay.service.DeploymentOverlayService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;

public class ContentAdd
extends AbstractAddStepHandler {
    protected final ContentRepository contentRepository;
    private final DeploymentFileRepository remoteRepository;
    protected final ParametersValidator validator = new ParametersValidator();
    protected final ParametersValidator managedContentValidator = new ParametersValidator();

    public ContentAdd(ContentRepository contentRepository, DeploymentFileRepository remoteRepository) {
        this.contentRepository = contentRepository;
        this.remoteRepository = remoteRepository;
        ParametersValidator contentValidator = new ParametersValidator();
        contentValidator.registerValidator("hash", (ParameterValidator)new ModelTypeValidator(ModelType.BYTES, true));
        contentValidator.registerValidator("input-stream-index", (ParameterValidator)new ModelTypeValidator(ModelType.INT, true));
        contentValidator.registerValidator("bytes", (ParameterValidator)new ModelTypeValidator(ModelType.BYTES, true));
        contentValidator.registerValidator("url", (ParameterValidator)new StringLengthValidator(1, true));
        this.validator.registerValidator("content", ChainedParameterValidator.chain((ParameterValidator[])new ParameterValidator[]{new ListValidator((ParameterValidator)new ParametersOfValidator(contentValidator)), new AbstractParameterValidator(){

            public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
                ContentAdd.validateOnePieceOfContent(value);
            }
        }}));
        this.managedContentValidator.registerValidator("hash", (ParameterValidator)new ModelTypeValidator(ModelType.BYTES));
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        byte[] hash;
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String path = address.getLastElement().getValue();
        String name = address.getElement(address.size() - 2).getValue();
        ModelNode content = operation.get("content");
        if (content.hasDefined("hash")) {
            this.managedContentValidator.validate(content);
            hash = content.require("hash").asBytes();
            this.addFromHash(hash, name, path, context);
        } else {
            hash = this.addFromContentAdditionParameter(context, content);
            ModelNode slave = operation.clone();
            slave.get("content").clear();
            slave.get("content").get("hash").set(hash);
            ArrayList<CompositeOperationAwareTransformer> transformers = (ArrayList<CompositeOperationAwareTransformer>)context.getAttachment(OperationAttachments.SLAVE_SERVER_OPERATION_TRANSFORMERS);
            if (transformers == null) {
                transformers = new ArrayList<CompositeOperationAwareTransformer>();
                context.attach(OperationAttachments.SLAVE_SERVER_OPERATION_TRANSFORMERS, transformers);
            }
            transformers.add(new CompositeOperationAwareTransformer(slave));
        }
        ModelNode modified = operation.clone();
        modified.get("content").clone();
        modified.get("content").set(hash);
        for (AttributeDefinition attr : ContentDefinition.attributes()) {
            attr.validateAndSet(modified, resource.getModel());
        }
        if (!this.contentRepository.syncContent(hash)) {
            throw ServerMessages.MESSAGES.noSuchDeploymentContent(Arrays.toString(hash));
        }
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String path = address.getLastElement().getValue();
        String name = address.getElement(address.size() - 2).getValue();
        byte[] content = model.get("content").asBytes();
        ContentAdd.installServices(context, verificationHandler, newControllers, name, path, content);
    }

    static void installServices(OperationContext context, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers, String name, String path, byte[] content) {
        ServiceName serviceName = ContentService.SERVICE_NAME.append(new String[]{name}).append(new String[]{path});
        ContentService service = new ContentService(path, content);
        ServiceBuilder builder = context.getServiceTarget().addService(serviceName, (Service)service).addDependency(DeploymentOverlayService.SERVICE_NAME.append(new String[]{name}), DeploymentOverlayService.class, service.getDeploymentOverlayServiceInjectedValue()).addDependency(ContentRepository.SERVICE_NAME, ContentRepository.class, service.getContentRepositoryInjectedValue());
        if (verificationHandler != null) {
            builder.addListener((ServiceListener)verificationHandler);
        }
        ServiceController controller = builder.install();
        if (newControllers != null) {
            newControllers.add(controller);
        }
    }

    protected static void validateOnePieceOfContent(ModelNode content) throws OperationFailedException {
        if (content.asList().size() != 1) {
            throw ServerMessages.MESSAGES.multipleContentItemsNotSupported();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    byte[] addFromHash(byte[] hash, String deploymentOverlayName, String contentName, OperationContext context) throws OperationFailedException {
        if (this.remoteRepository != null) {
            this.remoteRepository.getDeploymentFiles(hash);
        }
        if (this.contentRepository.syncContent(hash)) return hash;
        if (!context.isBooting()) throw ServerMessages.MESSAGES.noSuchDeploymentOverlayContent(HashUtil.bytesToHexString((byte[])hash));
        if (context.getRunningMode() != RunningMode.ADMIN_ONLY) throw ServerMessages.MESSAGES.noSuchDeploymentOverlayContentAtBoot(HashUtil.bytesToHexString((byte[])hash), deploymentOverlayName, contentName);
        ServerLogger.DEPLOYMENT_LOGGER.reportAdminOnlyMissingDeploymentOverlayContent(HashUtil.bytesToHexString((byte[])hash), deploymentOverlayName, contentName);
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] addFromContentAdditionParameter(OperationContext context, ModelNode contentItemNode) throws OperationFailedException {
        byte[] hash;
        InputStream in = ContentAdd.getInputStream(context, contentItemNode);
        try {
            try {
                hash = this.contentRepository.addContent(in);
            }
            catch (IOException e) {
                throw ContentAdd.createFailureException(e.toString());
            }
        }
        finally {
            StreamUtils.safeClose((Closeable)in);
        }
        return hash;
    }

    protected static OperationFailedException createFailureException(String msg) {
        return new OperationFailedException(new ModelNode(msg));
    }

    protected static InputStream getInputStream(OperationContext context, ModelNode operation) throws OperationFailedException {
        InputStream in = null;
        if (operation.hasDefined("input-stream-index")) {
            int maxIndex;
            int streamIndex = operation.get("input-stream-index").asInt();
            if (streamIndex > (maxIndex = context.getAttachmentStreamCount())) {
                throw ServerMessages.MESSAGES.invalidStreamIndex("input-stream-index", streamIndex, maxIndex);
            }
            in = context.getAttachmentStream(streamIndex);
        } else {
            if (operation.hasDefined("bytes")) {
                try {
                    in = new ByteArrayInputStream(operation.get("bytes").asBytes());
                }
                catch (IllegalArgumentException iae) {
                    throw ServerMessages.MESSAGES.invalidStreamBytes("bytes");
                }
            }
            if (operation.hasDefined("url")) {
                String urlSpec = operation.get("url").asString();
                try {
                    in = new URL(urlSpec).openStream();
                }
                catch (MalformedURLException e) {
                    throw ServerMessages.MESSAGES.invalidStreamURL(e, urlSpec);
                }
                catch (IOException e) {
                    throw ServerMessages.MESSAGES.invalidStreamURL(e, urlSpec);
                }
            }
        }
        if (in == null) {
            throw new IllegalStateException();
        }
        return in;
    }
}

