/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.util.Locale;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.DeploymentDescription;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.deployment.AbstractDeploymentHandler;
import org.jboss.as.server.deployment.DeploymentHandlerUtil;
import org.jboss.as.server.deployment.repository.api.ContentRepository;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class DeploymentReplaceHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "replace-deployment";
    private final ContentRepository contentRepository;
    private final ParametersValidator validator = new ParametersValidator();
    private final ParametersValidator unmanagedContentValidator = new ParametersValidator();
    private final ParametersValidator managedContentValidator = new ParametersValidator();

    static final ModelNode getOperation(ModelNode address) {
        return Util.getEmptyOperation((String)OPERATION_NAME, (ModelNode)address);
    }

    public DeploymentReplaceHandler(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
        this.validator.registerValidator("name", (ParameterValidator)new StringLengthValidator(1));
        this.validator.registerValidator("to-replace", (ParameterValidator)new StringLengthValidator(1));
        this.managedContentValidator.registerValidator("hash", (ParameterValidator)new ModelTypeValidator(ModelType.BYTES));
        this.unmanagedContentValidator.registerValidator("archive", (ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN));
        this.unmanagedContentValidator.registerValidator("path", (ParameterValidator)new StringLengthValidator(1));
    }

    public ModelNode getModelDescription(Locale locale) {
        return DeploymentDescription.getReplaceDeploymentOperation((Locale)locale);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.validator.validate(operation);
        Resource root = context.readResource(PathAddress.EMPTY_ADDRESS);
        String name = operation.require("name").asString();
        String toReplace = operation.require("to-replace").asString();
        if (name.equals(toReplace)) {
            throw DeploymentReplaceHandler.operationFailed(String.format("Cannot use %s with the same value for parameters %s and %s. Use %s to redeploy the same content or %s to replace content with a new version with the same name.", OPERATION_NAME, "name", "to-replace", "redeploy", "full-replace-deployment"));
        }
        PathElement deployPath = PathElement.pathElement((String)"deployment", (String)name);
        PathElement replacePath = PathElement.pathElement((String)"deployment", (String)toReplace);
        if (!root.hasChild(replacePath)) {
            throw DeploymentReplaceHandler.operationFailed(String.format("No deployment with name %s found", toReplace));
        }
        Resource resource = context.readResource(PathAddress.pathAddress((PathElement[])new PathElement[]{replacePath}));
        ModelNode replaceNode = resource.getModel();
        String replacedName = replaceNode.require("runtime-name").asString();
        Resource deployResource = root.getChild(deployPath);
        if (deployResource == null) {
            if (!operation.hasDefined("content")) {
                throw DeploymentReplaceHandler.operationFailed(String.format("No deployment with name %s found", name));
            }
            ModelNode content = operation.require("content").clone();
            ModelNode contentItemNode = content.require(0);
            if (contentItemNode.hasDefined("hash")) {
                this.managedContentValidator.validate(contentItemNode);
                byte[] hash = contentItemNode.require("hash").asBytes();
                if (!this.contentRepository.hasContent(hash)) {
                    throw AbstractDeploymentHandler.createFailureException("No deployment content with hash %s is available in the deployment content repository.", HashUtil.bytesToHexString((byte[])hash));
                }
            } else {
                this.unmanagedContentValidator.validate(contentItemNode);
            }
            String runtimeName = operation.hasDefined("runtime-name") ? operation.get("runtime-name").asString() : replacedName;
            deployResource = context.createResource(PathAddress.pathAddress((PathElement[])new PathElement[]{deployPath}));
            ModelNode deployNode = deployResource.getModel();
            deployNode.get("runtime-name").set(runtimeName);
            deployNode.get("content").set(content);
            DeploymentHandlerUtil.ContentItem[] contents = AbstractDeploymentHandler.getContents(deployNode.require("content"));
            DeploymentHandlerUtil.replace(context, replaceNode, runtimeName, name, replacedName, contents);
        } else if (deployResource.getModel().get("enabled").asBoolean()) {
            throw DeploymentReplaceHandler.operationFailed(String.format("Deployment %s is already started", toReplace));
        }
        replaceNode.get("enabled").set(false);
        context.completeStep();
    }

    private static OperationFailedException operationFailed(String msg) {
        return new OperationFailedException(new ModelNode().set(msg));
    }
}

