/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.process;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.process.ProcessInfo;
import org.jboss.as.process.ProcessLogger;
import org.jboss.as.process.ProcessMessageHandler;
import org.jboss.as.process.ProcessMessages;
import org.jboss.as.protocol.old.Connection;
import org.jboss.as.protocol.old.MessageHandler;
import org.jboss.as.protocol.old.ProtocolClient;
import org.jboss.as.protocol.old.StreamUtils;

public final class ProcessControllerClient
implements Closeable {
    private final Connection connection;

    ProcessControllerClient(Connection connection) {
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessControllerClient connect(ProtocolClient.Configuration configuration, final byte[] authCode, final ProcessMessageHandler messageHandler) throws IOException {
        if (configuration == null) {
            throw ProcessMessages.MESSAGES.nullVar("configuration");
        }
        if (authCode == null) {
            throw ProcessMessages.MESSAGES.nullVar("authCode");
        }
        if (messageHandler == null) {
            throw ProcessMessages.MESSAGES.nullVar("messageHandler");
        }
        configuration.setMessageHandler(new MessageHandler(){

            public void handleMessage(Connection connection, InputStream dataStream) throws IOException {
                ProcessControllerClient client = (ProcessControllerClient)connection.getAttachment();
                int cmd = StreamUtils.readUnsignedByte((InputStream)dataStream);
                switch (cmd) {
                    case 16: {
                        String processName = StreamUtils.readUTFZBytes((InputStream)dataStream);
                        dataStream.close();
                        ProcessLogger.CLIENT_LOGGER.tracef("Received process_added for process %s", processName);
                        messageHandler.handleProcessAdded(client, processName);
                        break;
                    }
                    case 17: {
                        String processName = StreamUtils.readUTFZBytes((InputStream)dataStream);
                        dataStream.close();
                        ProcessLogger.CLIENT_LOGGER.tracef("Received process_started for process %s", processName);
                        messageHandler.handleProcessStarted(client, processName);
                        break;
                    }
                    case 18: {
                        String processName = StreamUtils.readUTFZBytes((InputStream)dataStream);
                        long uptimeMillis = StreamUtils.readLong((InputStream)dataStream);
                        dataStream.close();
                        ProcessLogger.CLIENT_LOGGER.tracef("Received process_stopped for process %s", processName);
                        messageHandler.handleProcessStopped(client, processName, uptimeMillis);
                        break;
                    }
                    case 19: {
                        String processName = StreamUtils.readUTFZBytes((InputStream)dataStream);
                        dataStream.close();
                        ProcessLogger.CLIENT_LOGGER.tracef("Received process_removed for process %s", processName);
                        messageHandler.handleProcessRemoved(client, processName);
                        break;
                    }
                    case 20: {
                        int cnt = StreamUtils.readInt((InputStream)dataStream);
                        HashMap<String, ProcessInfo> inventory = new HashMap<String, ProcessInfo>();
                        for (int i = 0; i < cnt; ++i) {
                            String processName = StreamUtils.readUTFZBytes((InputStream)dataStream);
                            byte[] processAuthCode = new byte[16];
                            boolean processRunning = StreamUtils.readBoolean((InputStream)dataStream);
                            StreamUtils.readFully((InputStream)dataStream, (byte[])processAuthCode);
                            inventory.put(processName, new ProcessInfo(processName, authCode, processRunning));
                        }
                        dataStream.close();
                        ProcessLogger.CLIENT_LOGGER.tracef("Received process_inventory", new Object[0]);
                        messageHandler.handleProcessInventory(client, inventory);
                        break;
                    }
                    default: {
                        ProcessLogger.CLIENT_LOGGER.receivedUnknownMessageCode(cmd);
                        dataStream.close();
                    }
                }
            }

            public void handleShutdown(Connection connection) throws IOException {
                ProcessControllerClient client = (ProcessControllerClient)connection.getAttachment();
                messageHandler.handleConnectionShutdown(client);
            }

            public void handleFailure(Connection connection, IOException cause) throws IOException {
                ProcessControllerClient client = (ProcessControllerClient)connection.getAttachment();
                messageHandler.handleConnectionFailure(client, cause);
            }

            public void handleFinished(Connection connection) throws IOException {
                ProcessControllerClient client = (ProcessControllerClient)connection.getAttachment();
                messageHandler.handleConnectionFinished(client);
            }
        });
        ProtocolClient client = new ProtocolClient(configuration);
        Connection connection = client.connect();
        boolean ok = false;
        try {
            ProcessControllerClient processControllerClient;
            OutputStream os = connection.writeMessage();
            try {
                os.write(238);
                os.write(1);
                os.write(authCode);
                ProcessControllerClient processControllerClient2 = new ProcessControllerClient(connection);
                connection.attach((Object)processControllerClient2);
                ProcessLogger.CLIENT_LOGGER.trace("Sent initial greeting message");
                os.close();
                ok = true;
                processControllerClient = processControllerClient2;
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose((Closeable)os);
                throw throwable;
            }
            StreamUtils.safeClose((Closeable)os);
            return processControllerClient;
        }
        finally {
            if (!ok) {
                StreamUtils.safeClose((Closeable)connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream sendStdin(String processName) throws IOException {
        OutputStream os = this.connection.writeMessage();
        boolean ok = false;
        try {
            os.write(20);
            StreamUtils.writeUTFZBytes((OutputStream)os, (String)processName);
            ok = true;
            OutputStream outputStream = os;
            return outputStream;
        }
        finally {
            if (!ok) {
                StreamUtils.safeClose((Closeable)os);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProcess(String processName, byte[] authKey, String[] cmd, String workingDir, Map<String, String> env) throws IOException {
        if (processName == null) {
            throw ProcessMessages.MESSAGES.nullVar("processName");
        }
        if (authKey == null) {
            throw ProcessMessages.MESSAGES.nullVar("authKey");
        }
        if (cmd == null) {
            throw ProcessMessages.MESSAGES.nullVar("cmd");
        }
        if (workingDir == null) {
            throw ProcessMessages.MESSAGES.nullVar("workingDir");
        }
        if (env == null) {
            throw ProcessMessages.MESSAGES.nullVar("env");
        }
        if (cmd.length < 1) {
            throw ProcessMessages.MESSAGES.invalidCommandLen();
        }
        if (authKey.length != 16) {
            throw ProcessMessages.MESSAGES.invalidAuthKeyLen();
        }
        OutputStream os = this.connection.writeMessage();
        try {
            os.write(16);
            StreamUtils.writeUTFZBytes((OutputStream)os, (String)processName);
            os.write(authKey);
            StreamUtils.writeInt((OutputStream)os, (int)cmd.length);
            for (String c : cmd) {
                StreamUtils.writeUTFZBytes((OutputStream)os, (String)c);
            }
            StreamUtils.writeInt((OutputStream)os, (int)env.size());
            for (String key : env.keySet()) {
                String value = env.get(key);
                StreamUtils.writeUTFZBytes((OutputStream)os, (String)key);
                if (value != null) {
                    StreamUtils.writeUTFZBytes((OutputStream)os, (String)value);
                    continue;
                }
                StreamUtils.writeUTFZBytes((OutputStream)os, (String)"");
            }
            StreamUtils.writeUTFZBytes((OutputStream)os, (String)workingDir);
            os.close();
        }
        finally {
            StreamUtils.safeClose((Closeable)os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startProcess(String processName) throws IOException {
        if (processName == null) {
            throw ProcessMessages.MESSAGES.nullVar("processName");
        }
        OutputStream os = this.connection.writeMessage();
        try {
            os.write(17);
            StreamUtils.writeUTFZBytes((OutputStream)os, (String)processName);
            os.close();
        }
        finally {
            StreamUtils.safeClose((Closeable)os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopProcess(String processName) throws IOException {
        if (processName == null) {
            throw ProcessMessages.MESSAGES.nullVar("processName");
        }
        OutputStream os = this.connection.writeMessage();
        try {
            os.write(18);
            StreamUtils.writeUTFZBytes((OutputStream)os, (String)processName);
            os.close();
        }
        finally {
            StreamUtils.safeClose((Closeable)os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProcess(String processName) throws IOException {
        if (processName == null) {
            throw ProcessMessages.MESSAGES.nullVar("processName");
        }
        OutputStream os = this.connection.writeMessage();
        try {
            os.write(19);
            StreamUtils.writeUTFZBytes((OutputStream)os, (String)processName);
            os.close();
        }
        finally {
            StreamUtils.safeClose((Closeable)os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestProcessInventory() throws IOException {
        OutputStream os = this.connection.writeMessage();
        try {
            os.write(21);
            os.close();
        }
        finally {
            StreamUtils.safeClose((Closeable)os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnectProcess(String processName, String hostName, int port) throws IOException {
        if (processName == null) {
            throw ProcessMessages.MESSAGES.nullVar("processName");
        }
        OutputStream os = this.connection.writeMessage();
        try {
            os.write(22);
            StreamUtils.writeUTFZBytes((OutputStream)os, (String)processName);
            StreamUtils.writeUTFZBytes((OutputStream)os, (String)hostName);
            StreamUtils.writeInt((OutputStream)os, (int)port);
            os.close();
        }
        finally {
            StreamUtils.safeClose((Closeable)os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws IOException {
        OutputStream os = this.connection.writeMessage();
        try {
            os.write(23);
            os.close();
        }
        finally {
            StreamUtils.safeClose((Closeable)os);
        }
    }

    @Override
    public void close() throws IOException {
        this.connection.close();
    }
}

